/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;

@InternalApi(value="for testing")
public class FakeStubSettings
extends StubSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();

    private FakeStubSettings(Builder builder) throws IOException {
        super(builder);
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    @Override
    public String getServiceName() {
        return "test";
    }

    @Override
    public StubSettings.Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends StubSettings.Builder {
        public Builder(ClientContext clientContext) {
            super(clientContext);
        }

        public Builder(StubSettings stubSettings) {
            super(stubSettings);
        }

        public Builder() {
            super((ClientContext)null);
        }

        public FakeStubSettings build() throws IOException {
            return new FakeStubSettings(this);
        }

        public static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setCredentialsProvider(Builder.defaultCredentialsProviderBuilder());
            return builder;
        }

        public static GoogleCredentialsProvider defaultCredentialsProviderBuilder() {
            return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true).build();
        }
    }
}

