/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ClientStreamReadyObserver;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CancellationException;

@InternalApi(value="for testing")
public class FakeStreamingApi {

    public static class ClientStreamingStashCallable<RequestT, ResponseT>
    extends ClientStreamingCallable<RequestT, ResponseT> {
        private ApiCallContext context;
        private ApiStreamObserver<ResponseT> responseObserver;
        private AccumulatingStreamObserver<RequestT> requestObserver;
        private ResponseT response;

        public ClientStreamingStashCallable() {
        }

        public ClientStreamingStashCallable(ResponseT response) {
            this.response = response;
        }

        @Override
        public ApiStreamObserver<RequestT> clientStreamingCall(ApiStreamObserver<ResponseT> responseObserver, ApiCallContext context) {
            Preconditions.checkNotNull(responseObserver);
            this.responseObserver = responseObserver;
            this.context = context;
            this.requestObserver = new AccumulatingStreamObserver();
            return this.requestObserver;
        }

        public ApiCallContext getContext() {
            return this.context;
        }

        public ApiStreamObserver<ResponseT> getActualObserver() {
            return this.responseObserver;
        }

        public List<RequestT> getActualRequests() {
            return this.requestObserver.getValues();
        }

        private void sendResponses() {
            this.responseObserver.onNext(this.response);
            this.responseObserver.onCompleted();
        }

        private class AccumulatingStreamObserver<T>
        implements ApiStreamObserver<T> {
            private List<T> requestList = new ArrayList<T>();
            private Throwable error;
            private boolean completed = false;

            private AccumulatingStreamObserver() {
            }

            @Override
            public void onNext(T value) {
                this.requestList.add(value);
            }

            @Override
            public void onError(Throwable t) {
                this.error = t;
            }

            @Override
            public void onCompleted() {
                this.completed = true;
                ClientStreamingStashCallable.this.sendResponses();
            }

            public List<T> getValues() {
                if (!this.completed) {
                    throw new IllegalStateException("Stream not completed.");
                }
                if (this.error != null) {
                    throw ApiExceptionFactory.createException(this.error, FakeStatusCode.of(StatusCode.Code.UNKNOWN), false);
                }
                return this.requestList;
            }
        }
    }

    private static class StreamControllerStash<ResponseT>
    implements StreamController {
        final ResponseObserver<ResponseT> observer;
        final Queue<ResponseT> queue;
        boolean autoFlowControl = true;
        long numPending;
        Throwable error;
        boolean delivering;
        boolean closed;

        public StreamControllerStash(List<ResponseT> responseList, ResponseObserver<ResponseT> observer) {
            this.observer = observer;
            this.queue = Queues.newArrayDeque(responseList);
        }

        public void start() {
            this.observer.onStart(this);
            if (this.autoFlowControl) {
                this.numPending = Integer.MAX_VALUE;
            }
            this.deliver();
        }

        public void startBidi() {
            this.start();
        }

        @Override
        public void disableAutoInboundFlowControl() {
            this.autoFlowControl = false;
        }

        @Override
        public void request(int count) {
            this.numPending += (long)count;
            this.deliver();
        }

        @Override
        public void cancel() {
            this.error = new CancellationException("User cancelled stream");
            this.deliver();
        }

        private void deliver() {
            if (this.delivering || this.closed) {
                return;
            }
            this.delivering = true;
            try {
                while (this.error == null && this.numPending > 0L && !this.queue.isEmpty()) {
                    --this.numPending;
                    this.observer.onResponse(this.queue.poll());
                }
                if (this.error != null || this.queue.isEmpty()) {
                    if (this.error != null) {
                        this.observer.onError(this.error);
                    } else {
                        this.observer.onComplete();
                    }
                    this.closed = true;
                }
            }
            finally {
                this.delivering = false;
            }
        }
    }

    public static class ServerStreamingStashCallable<RequestT, ResponseT>
    extends ServerStreamingCallable<RequestT, ResponseT> {
        private ApiCallContext context;
        private ResponseObserver<ResponseT> actualObserver;
        private RequestT actualRequest;
        private List<ResponseT> responseList;

        public ServerStreamingStashCallable() {
            this.responseList = new ArrayList<ResponseT>();
        }

        public ServerStreamingStashCallable(List<ResponseT> responseList) {
            this.responseList = responseList;
        }

        @Override
        public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
            Preconditions.checkNotNull(request);
            Preconditions.checkNotNull(responseObserver);
            this.actualRequest = request;
            this.actualObserver = responseObserver;
            this.context = context;
            StreamControllerStash<ResponseT> controller = new StreamControllerStash<ResponseT>(this.responseList, responseObserver);
            controller.start();
        }

        public ApiCallContext getContext() {
            return this.context;
        }

        public ResponseObserver<ResponseT> getActualObserver() {
            return this.actualObserver;
        }

        public RequestT getActualRequest() {
            return this.actualRequest;
        }
    }

    public static class BidiStreamingStashCallable<RequestT, ResponseT>
    extends BidiStreamingCallable<RequestT, ResponseT> {
        private ApiCallContext context;
        private ResponseObserver<ResponseT> responseObserver;
        private AccumulatingClientStream<RequestT> clientStream;
        private List<ResponseT> responseList;

        public BidiStreamingStashCallable() {
            this.responseList = new ArrayList<ResponseT>();
        }

        public BidiStreamingStashCallable(List<ResponseT> responseList) {
            this.responseList = responseList;
        }

        @Override
        public ClientStream<RequestT> internalCall(ResponseObserver<ResponseT> responseObserver, ClientStreamReadyObserver<RequestT> onReady, ApiCallContext context) {
            Preconditions.checkNotNull(responseObserver);
            this.responseObserver = responseObserver;
            this.context = context;
            this.clientStream = new AccumulatingClientStream();
            StreamControllerStash<ResponseT> controller = new StreamControllerStash<ResponseT>(this.responseList, responseObserver);
            controller.startBidi();
            onReady.onReady(this.clientStream);
            return this.clientStream;
        }

        public ApiCallContext getContext() {
            return this.context;
        }

        public ResponseObserver<ResponseT> getActualObserver() {
            return this.responseObserver;
        }

        public List<RequestT> getActualRequests() {
            return this.clientStream.getValues();
        }

        private void sendResponses() {
            for (ResponseT response : this.responseList) {
                this.responseObserver.onResponse(response);
            }
            this.responseObserver.onComplete();
        }

        private class AccumulatingClientStream<T>
        implements ClientStream<T> {
            private List<T> requestList = new ArrayList<T>();
            private Throwable error;
            private boolean completed = false;

            private AccumulatingClientStream() {
            }

            @Override
            public void send(T value) {
                this.requestList.add(value);
            }

            @Override
            public void closeSendWithError(Throwable t) {
                this.error = t;
            }

            @Override
            public void closeSend() {
                this.completed = true;
            }

            @Override
            public boolean isSendReady() {
                return true;
            }

            public List<T> getValues() {
                if (!this.completed) {
                    throw new IllegalStateException("Stream not completed.");
                }
                if (this.error != null) {
                    throw ApiExceptionFactory.createException(this.error, FakeStatusCode.of(StatusCode.Code.UNKNOWN), false);
                }
                return this.requestList;
            }
        }
    }
}

