/*
 * Decompiled with CFR 0.152.
 */
package com.google.re2j;

import com.google.re2j.Inst;
import com.google.re2j.MachineInput;
import com.google.re2j.Prog;
import com.google.re2j.RE2;
import com.google.re2j.Utils;
import java.util.Arrays;

class Machine {
    private RE2 re2;
    private final Prog prog;
    private final Queue q0;
    private final Queue q1;
    private Thread[] pool = new Thread[10];
    private int poolSize;
    private boolean matched;
    private int[] matchcap;
    private int ncap;
    Machine next;

    Machine(RE2 re2) {
        this.prog = re2.prog;
        this.re2 = re2;
        this.q0 = new Queue(this.prog.numInst());
        this.q1 = new Queue(this.prog.numInst());
        this.matchcap = new int[this.prog.numCap < 2 ? 2 : this.prog.numCap];
    }

    Machine(Machine copy) {
        this.re2 = copy.re2;
        this.prog = copy.prog;
        this.q0 = copy.q0;
        this.q1 = copy.q1;
        this.pool = copy.pool;
        this.poolSize = copy.poolSize;
        this.matched = copy.matched;
        this.matchcap = copy.matchcap;
        this.ncap = copy.ncap;
    }

    void init(int ncap) {
        this.ncap = ncap;
        if (ncap > this.matchcap.length) {
            this.initNewCap(ncap);
        } else {
            this.resetCap(ncap);
        }
    }

    private void resetCap(int ncap) {
        for (int i = 0; i < this.poolSize; ++i) {
            Thread t2 = this.pool[i];
            Arrays.fill(t2.cap, 0, ncap, 0);
        }
    }

    private void initNewCap(int ncap) {
        for (int i = 0; i < this.poolSize; ++i) {
            Thread t2 = this.pool[i];
            t2.cap = new int[ncap];
        }
        this.matchcap = new int[ncap];
    }

    int[] submatches() {
        if (this.ncap == 0) {
            return Utils.EMPTY_INTS;
        }
        return Arrays.copyOf(this.matchcap, this.ncap);
    }

    private Thread alloc(Inst inst) {
        Thread t2;
        if (this.poolSize > 0) {
            --this.poolSize;
            t2 = this.pool[this.poolSize];
        } else {
            t2 = new Thread(this.matchcap.length);
        }
        t2.inst = inst;
        return t2;
    }

    private void free(Queue queue) {
        this.free(queue, 0);
    }

    private void free(Queue queue, int from) {
        int numberOfThread = queue.size - from;
        int requiredPoolLength = this.poolSize + numberOfThread;
        if (this.pool.length < requiredPoolLength) {
            this.pool = Arrays.copyOf(this.pool, Math.max(this.pool.length * 2, requiredPoolLength));
        }
        for (int i = from; i < queue.size; ++i) {
            Thread t2 = queue.denseThreads[i];
            if (t2 == null) continue;
            this.pool[this.poolSize] = t2;
            ++this.poolSize;
        }
        queue.clear();
    }

    private void free(Thread t2) {
        if (this.pool.length <= this.poolSize) {
            this.pool = Arrays.copyOf(this.pool, this.pool.length * 2);
        }
        this.pool[this.poolSize] = t2;
        ++this.poolSize;
    }

    boolean match(MachineInput in, int pos, int anchor) {
        int startCond = this.re2.cond;
        if (startCond == -1) {
            return false;
        }
        if ((anchor == 1 || anchor == 2) && pos != 0) {
            return false;
        }
        this.matched = false;
        Arrays.fill(this.matchcap, 0, this.prog.numCap, -1);
        Queue runq = this.q0;
        Queue nextq = this.q1;
        int r = in.step(pos);
        int rune = r >> 3;
        int width = r & 7;
        int rune1 = -1;
        int width1 = 0;
        if (r != -8) {
            r = in.step(pos + width);
            rune1 = r >> 3;
            width1 = r & 7;
        }
        int flag = pos == 0 ? Utils.emptyOpContext(-1, rune) : in.context(pos);
        while (true) {
            if (runq.isEmpty()) {
                if ((startCond & 4) != 0 && pos != 0 || this.matched) break;
                if (!this.re2.prefix.isEmpty() && rune1 != this.re2.prefixRune && in.canCheckPrefix()) {
                    int advance = in.index(this.re2, pos);
                    if (advance < 0) break;
                    r = in.step(pos += advance);
                    rune = r >> 3;
                    width = r & 7;
                    r = in.step(pos + width);
                    rune1 = r >> 3;
                    width1 = r & 7;
                }
            }
            if (!(this.matched || pos != 0 && anchor != 0)) {
                if (this.ncap > 0) {
                    this.matchcap[0] = pos;
                }
                this.add(runq, this.prog.start, pos, this.matchcap, flag, null);
            }
            int nextPos = pos + width;
            flag = in.context(nextPos);
            this.step(runq, nextq, pos, nextPos, rune, flag, anchor, pos == in.endPos());
            if (width == 0 || this.ncap == 0 && this.matched) break;
            pos += width;
            rune = rune1;
            width = width1;
            if (rune != -1) {
                r = in.step(pos + width);
                rune1 = r >> 3;
                width1 = r & 7;
            }
            Queue tmpq = runq;
            runq = nextq;
            nextq = tmpq;
        }
        this.free(nextq);
        return this.matched;
    }

    private void step(Queue runq, Queue nextq, int pos, int nextPos, int c, int nextCond, int anchor, boolean atEnd) {
        boolean longest = this.re2.longest;
        for (int j = 0; j < runq.size; ++j) {
            Thread t2 = runq.denseThreads[j];
            if (t2 == null) continue;
            if (longest && this.matched && this.ncap > 0 && this.matchcap[0] < t2.cap[0]) {
                this.free(t2);
                continue;
            }
            Inst i = t2.inst;
            boolean add = false;
            switch (i.op) {
                case 6: {
                    if (anchor == 2 && !atEnd) break;
                    if (!(this.ncap <= 0 || longest && this.matched && this.matchcap[1] >= pos)) {
                        t2.cap[1] = pos;
                        System.arraycopy(t2.cap, 0, this.matchcap, 0, this.ncap);
                    }
                    if (!longest) {
                        this.free(runq, j + 1);
                    }
                    this.matched = true;
                    break;
                }
                case 8: {
                    add = i.matchRune(c);
                    break;
                }
                case 9: {
                    add = c == i.runes[0];
                    break;
                }
                case 10: {
                    add = true;
                    break;
                }
                case 11: {
                    add = c != 10;
                    break;
                }
                default: {
                    throw new IllegalStateException("bad inst");
                }
            }
            if (add) {
                t2 = this.add(nextq, i.out, nextPos, t2.cap, nextCond, t2);
            }
            if (t2 == null) continue;
            this.free(t2);
            runq.denseThreads[j] = null;
        }
        runq.clear();
    }

    private Thread add(Queue q, int pc, int pos, int[] cap, int cond, Thread t2) {
        if (pc == 0) {
            return t2;
        }
        if (q.contains(pc)) {
            return t2;
        }
        int d = q.add(pc);
        Inst inst = this.prog.inst[pc];
        switch (inst.op) {
            default: {
                throw new IllegalStateException("unhandled");
            }
            case 5: {
                break;
            }
            case 1: 
            case 2: {
                t2 = this.add(q, inst.out, pos, cap, cond, t2);
                t2 = this.add(q, inst.arg, pos, cap, cond, t2);
                break;
            }
            case 4: {
                if ((inst.arg & ~cond) != 0) break;
                t2 = this.add(q, inst.out, pos, cap, cond, t2);
                break;
            }
            case 7: {
                t2 = this.add(q, inst.out, pos, cap, cond, t2);
                break;
            }
            case 3: {
                if (inst.arg < this.ncap) {
                    int opos = cap[inst.arg];
                    cap[inst.arg] = pos;
                    this.add(q, inst.out, pos, cap, cond, null);
                    cap[inst.arg] = opos;
                    break;
                }
                t2 = this.add(q, inst.out, pos, cap, cond, t2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (t2 == null) {
                    t2 = this.alloc(inst);
                } else {
                    t2.inst = inst;
                }
                if (this.ncap > 0 && t2.cap != cap) {
                    System.arraycopy(cap, 0, t2.cap, 0, this.ncap);
                }
                q.denseThreads[d] = t2;
                t2 = null;
            }
        }
        return t2;
    }

    private static class Queue {
        final Thread[] denseThreads;
        final int[] densePcs;
        final int[] sparse;
        int size;

        Queue(int n) {
            this.sparse = new int[n];
            this.densePcs = new int[n];
            this.denseThreads = new Thread[n];
        }

        boolean contains(int pc) {
            int j = this.sparse[pc];
            return j < this.size && this.densePcs[j] == pc;
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        int add(int pc) {
            int j;
            this.sparse[pc] = j = this.size++;
            this.denseThreads[j] = null;
            this.densePcs[j] = pc;
            return j;
        }

        void clear() {
            this.size = 0;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append('{');
            for (int i = 0; i < this.size; ++i) {
                if (i != 0) {
                    out.append(", ");
                }
                out.append(this.densePcs[i]);
            }
            out.append('}');
            return out.toString();
        }
    }

    private static class Thread {
        int[] cap;
        Inst inst;

        Thread(int n) {
            this.cap = new int[n];
        }
    }
}

