/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.mtls;

import com.google.api.gax.rpc.mtls.CertificateBasedAccess;
import com.google.api.gax.rpc.testing.FakeMtlsProvider;
import com.google.auth.mtls.MtlsProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractMtlsTransportChannelTest {
    protected abstract Object getMtlsObjectFromTransportChannel(MtlsProvider var1, CertificateBasedAccess var2) throws IOException, GeneralSecurityException;

    @Test
    void testNotUseClientCertificate() throws IOException, GeneralSecurityException {
        CertificateBasedAccess certificateBasedAccess = new CertificateBasedAccess(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "auto" : "false");
        FakeMtlsProvider provider = new FakeMtlsProvider(null, "", false);
        Assertions.assertNull((Object)this.getMtlsObjectFromTransportChannel(provider, certificateBasedAccess));
    }

    @Test
    void testUseClientCertificate() throws IOException, GeneralSecurityException {
        CertificateBasedAccess certificateBasedAccess = new CertificateBasedAccess(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "auto" : "true");
        FakeMtlsProvider provider = new FakeMtlsProvider(FakeMtlsProvider.createTestMtlsKeyStore(), "", false);
        Assertions.assertNotNull((Object)this.getMtlsObjectFromTransportChannel(provider, certificateBasedAccess));
    }

    @Test
    void testNoClientCertificate() throws IOException, GeneralSecurityException {
        CertificateBasedAccess certificateBasedAccess = new CertificateBasedAccess(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "auto" : "true");
        FakeMtlsProvider provider = new FakeMtlsProvider(null, "", false);
        Assertions.assertNull((Object)this.getMtlsObjectFromTransportChannel(provider, certificateBasedAccess));
    }

    @Test
    void testGetKeyStoreThrows() throws GeneralSecurityException {
        CertificateBasedAccess certificateBasedAccess = new CertificateBasedAccess(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "auto" : "true");
        FakeMtlsProvider provider = new FakeMtlsProvider(null, "", true);
        IOException actual = (IOException)Assertions.assertThrows(IOException.class, () -> this.getMtlsObjectFromTransportChannel(provider, certificateBasedAccess));
        Assertions.assertTrue((boolean)actual.getMessage().contains("getKeyStore throws exception"));
    }
}

