/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.doclint;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.openjdk.javax.lang.model.element.Element;
import org.openjdk.javax.lang.model.element.ElementKind;
import org.openjdk.javax.lang.model.element.ExecutableElement;
import org.openjdk.javax.lang.model.element.Modifier;
import org.openjdk.javax.lang.model.type.TypeMirror;
import org.openjdk.javax.lang.model.util.Elements;
import org.openjdk.javax.lang.model.util.Types;
import org.openjdk.source.doctree.DocCommentTree;
import org.openjdk.source.tree.CompilationUnitTree;
import org.openjdk.source.util.DocSourcePositions;
import org.openjdk.source.util.DocTrees;
import org.openjdk.source.util.JavacTask;
import org.openjdk.source.util.TreePath;
import org.openjdk.tools.doclint.HtmlVersion;
import org.openjdk.tools.doclint.Messages;
import org.openjdk.tools.javac.model.JavacTypes;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.MatchingUtils;
import org.openjdk.tools.javac.util.StringUtils;

public class Env {
    final Messages messages;
    int implicitHeaderLevel = 0;
    Set<String> customTags;
    Set<Pattern> includePackages;
    Set<Pattern> excludePackages;
    HtmlVersion htmlVersion = HtmlVersion.HTML4;
    DocTrees trees;
    Elements elements;
    Types types;
    TypeMirror java_lang_Error;
    TypeMirror java_lang_RuntimeException;
    TypeMirror java_lang_Throwable;
    TypeMirror java_lang_Void;
    TreePath currPath;
    Element currElement;
    DocCommentTree currDocComment;
    AccessKind currAccess;
    Set<? extends ExecutableElement> currOverriddenMethods;

    Env() {
        this.messages = new Messages(this);
    }

    void init(JavacTask javacTask) {
        this.init(DocTrees.instance(javacTask), javacTask.getElements(), javacTask.getTypes());
    }

    void init(DocTrees docTrees, Elements elements, Types types) {
        this.trees = docTrees;
        this.elements = elements;
        this.types = types;
    }

    void initTypes() {
        if (this.java_lang_Error != null) {
            return;
        }
        this.java_lang_Error = this.elements.getTypeElement("java.lang.Error").asType();
        this.java_lang_RuntimeException = this.elements.getTypeElement("java.lang.RuntimeException").asType();
        this.java_lang_Throwable = this.elements.getTypeElement("java.lang.Throwable").asType();
        this.java_lang_Void = this.elements.getTypeElement("java.lang.Void").asType();
    }

    void setImplicitHeaders(int n) {
        this.implicitHeaderLevel = n;
    }

    void setCustomTags(String string) {
        this.customTags = new LinkedHashSet<String>();
        for (String string2 : string.split(",")) {
            if (string2.isEmpty()) continue;
            this.customTags.add(string2);
        }
    }

    void setCheckPackages(String string) {
        this.includePackages = new HashSet<Pattern>();
        this.excludePackages = new HashSet<Pattern>();
        for (String string2 : string.split(",")) {
            boolean bl = false;
            if (string2.startsWith("-")) {
                string2 = string2.substring(1);
                bl = true;
            }
            if (string2.isEmpty()) continue;
            Pattern pattern = MatchingUtils.validImportStringToPattern(string2);
            if (bl) {
                this.excludePackages.add(pattern);
                continue;
            }
            this.includePackages.add(pattern);
        }
    }

    static boolean validatePackages(String string) {
        for (String string2 : string.split(",")) {
            if (string2.startsWith("-")) {
                string2 = string2.substring(1);
            }
            if (string2.isEmpty() || MatchingUtils.isValidImportString(string2)) continue;
            return false;
        }
        return true;
    }

    void setHtmlVersion(HtmlVersion htmlVersion) {
        this.htmlVersion = htmlVersion;
    }

    void setCurrent(TreePath treePath, DocCommentTree docCommentTree) {
        this.currPath = treePath;
        this.currDocComment = docCommentTree;
        this.currElement = this.trees.getElement(this.currPath);
        this.currOverriddenMethods = ((JavacTypes)this.types).getOverriddenMethods(this.currElement);
        AccessKind accessKind = AccessKind.PUBLIC;
        for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
            Element element = this.trees.getElement(treePath2);
            if (element == null || element.getKind() == ElementKind.PACKAGE || element.getKind() == ElementKind.MODULE) continue;
            accessKind = this.min(accessKind, AccessKind.of(element.getModifiers()));
        }
        this.currAccess = accessKind;
    }

    AccessKind getAccessKind() {
        return this.currAccess;
    }

    long getPos(TreePath treePath) {
        return ((JCTree)treePath.getLeaf()).pos;
    }

    long getStartPos(TreePath treePath) {
        DocSourcePositions docSourcePositions = this.trees.getSourcePositions();
        return docSourcePositions.getStartPosition(treePath.getCompilationUnit(), treePath.getLeaf());
    }

    boolean shouldCheck(CompilationUnitTree compilationUnitTree) {
        String string;
        if (this.includePackages == null) {
            return true;
        }
        String string2 = string = compilationUnitTree.getPackageName() != null ? compilationUnitTree.getPackageName().toString() : "";
        if (!this.includePackages.isEmpty()) {
            boolean bl = false;
            for (Pattern pattern : this.includePackages) {
                if (!pattern.matcher(string).matches()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        for (Pattern pattern : this.excludePackages) {
            if (!pattern.matcher(string).matches()) continue;
            return false;
        }
        return true;
    }

    private <T extends Comparable<T>> T min(T t2, T t3) {
        return t2 == null ? t3 : (t3 == null ? t2 : (t2.compareTo(t3) <= 0 ? t2 : t3));
    }

    public static enum AccessKind {
        PRIVATE,
        PACKAGE,
        PROTECTED,
        PUBLIC;


        static boolean accepts(String string) {
            for (AccessKind accessKind : AccessKind.values()) {
                if (!string.equals(StringUtils.toLowerCase(accessKind.name()))) continue;
                return true;
            }
            return false;
        }

        static AccessKind of(Set<Modifier> set) {
            if (set.contains((Object)Modifier.PUBLIC)) {
                return PUBLIC;
            }
            if (set.contains((Object)Modifier.PROTECTED)) {
                return PROTECTED;
            }
            if (set.contains((Object)Modifier.PRIVATE)) {
                return PRIVATE;
            }
            return PACKAGE;
        }
    }
}

