/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.gapic.model.AutoValue_GapicContext;
import com.google.api.generator.gapic.model.GapicServiceConfig;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.model.Transport;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gapic.metadata.GapicMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@AutoValue
public abstract class GapicContext {
    private GapicMetadata gapicMetadata = GapicContext.defaultGapicMetadata();
    public static final GapicContext EMPTY = GapicContext.builder().setServices(Collections.emptyList()).setMessages(Collections.emptyMap()).setServiceConfig(GapicServiceConfig.create(Optional.empty())).setResourceNames(Collections.emptyMap()).setHelperResourceNames(Collections.emptySet()).setTransport(Transport.GRPC).build();

    public abstract ImmutableMap<String, Message> messages();

    public abstract ImmutableMap<String, ResourceName> resourceNames();

    public abstract ImmutableList<Service> services();

    public abstract ImmutableList<Service> mixinServices();

    public abstract ImmutableMap<String, ResourceName> helperResourceNames();

    public abstract boolean gapicMetadataEnabled();

    public abstract boolean restNumericEnumsEnabled();

    public GapicMetadata gapicMetadata() {
        return this.gapicMetadata;
    }

    @Nullable
    public abstract GapicServiceConfig serviceConfig();

    @Nullable
    public abstract com.google.api.Service serviceYamlProto();

    public boolean containsServices() {
        return !this.services().isEmpty();
    }

    public boolean hasServiceYamlProto() {
        return this.serviceYamlProto() != null;
    }

    public void updateGapicMetadata(GapicMetadata newMetadata) {
        this.gapicMetadata = newMetadata;
    }

    static GapicMetadata defaultGapicMetadata() {
        return GapicMetadata.newBuilder().setSchema("1.0").setComment("This file maps proto services/RPCs to the corresponding library clients/methods").setLanguage("java").build();
    }

    public abstract Builder toBuilder();

    public abstract Transport transport();

    public static Builder builder() {
        return new AutoValue_GapicContext.Builder().setMixinServices(Collections.emptyList()).setGapicMetadataEnabled(false).setRestNumericEnumsEnabled(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMessages(Map<String, Message> var1);

        public abstract Builder setResourceNames(Map<String, ResourceName> var1);

        public abstract Builder setServices(List<Service> var1);

        public abstract Builder setMixinServices(List<Service> var1);

        public Builder setHelperResourceNames(Set<ResourceName> helperResourceNames) {
            return this.setHelperResourceNames(helperResourceNames.stream().collect(Collectors.toMap(r -> r.resourceTypeString(), r -> r)));
        }

        abstract Builder setHelperResourceNames(Map<String, ResourceName> var1);

        public abstract Builder setServiceConfig(GapicServiceConfig var1);

        public abstract Builder setServiceYamlProto(com.google.api.Service var1);

        public abstract Builder setGapicMetadataEnabled(boolean var1);

        public abstract Builder setRestNumericEnumsEnabled(boolean var1);

        public abstract Builder setTransport(Transport var1);

        abstract ImmutableMap<String, ResourceName> resourceNames();

        abstract ImmutableMap<String, ResourceName> helperResourceNames();

        abstract GapicContext autoBuild();

        public GapicContext build() {
            this.setResourceNames(new TreeMap<String, ResourceName>(this.resourceNames()));
            this.setHelperResourceNames(new TreeMap<String, ResourceName>(this.helperResourceNames()));
            return this.autoBuild();
        }
    }
}

