/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.Service;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ServiceYamlParser {
    public static Optional<Service> parse(String serviceYamlFilePath) {
        if (Strings.isNullOrEmpty(serviceYamlFilePath) || !new File(serviceYamlFilePath).exists()) {
            return Optional.empty();
        }
        String fileContents = null;
        try {
            fileContents = new String(Files.readAllBytes(Paths.get(serviceYamlFilePath, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Optional.empty();
        }
        Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
        Map yamlMap = (Map)yaml.load(fileContents);
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        String jsonString = gson.toJson((Object)yamlMap, (Type)((Object)LinkedHashMap.class));
        Service.Builder serviceBuilder = Service.newBuilder();
        try {
            JsonFormat.parser().ignoringUnknownFields().merge(jsonString, (Message.Builder)serviceBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            return Optional.empty();
        }
        return Optional.of(serviceBuilder.build());
    }
}

