/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.gapic.model.AutoValue_Message;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.OperationResponse;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

@AutoValue
public abstract class Message {
    public abstract String name();

    public abstract String fullProtoName();

    public abstract ImmutableList<Field> fields();

    public abstract ImmutableMap<String, Integer> enumValues();

    public abstract TypeNode type();

    public abstract ImmutableMap<String, Field> fieldMap();

    @Nullable
    public abstract OperationResponse operationResponse();

    public abstract Map<String, String> operationRequestFields();

    public abstract BiMap<String, String> operationResponseFields();

    @Nullable
    public abstract ResourceName resource();

    public abstract ImmutableList<String> outerNestedTypes();

    public abstract ImmutableList<String> nestedEnums();

    public abstract Builder toBuilder();

    public boolean isEnum() {
        return !this.enumValues().isEmpty();
    }

    public boolean hasResource() {
        return this.resource() != null;
    }

    public void validateField(String fieldName, Map<String, Message> messageTypes, TypeNode type) {
        List<String> subFields = Splitter.on(".").splitToList(fieldName);
        Message nestedMessage = this;
        for (int i = 0; i < subFields.size(); ++i) {
            String subFieldName = subFields.get(i);
            Preconditions.checkState(!Strings.isNullOrEmpty(subFieldName), String.format("Null or empty field name found for message %s", nestedMessage.name()));
            Field field = nestedMessage.fieldMap().get(subFieldName);
            Preconditions.checkNotNull(field, String.format("Expected message %s to contain field %s but none found", nestedMessage.name(), subFieldName));
            if (i < subFields.size() - 1) {
                nestedMessage = messageTypes.get(field.type().reference().fullName());
                Preconditions.checkNotNull(nestedMessage, String.format("No containing message found for field %s with type %s", field.name(), field.type().reference().simpleName()));
                continue;
            }
            Preconditions.checkState(!field.isRepeated() && field.type().equals(type), String.format("The type of field %s must be String and not repeated.", field.name()));
        }
    }

    @Nullable
    public Field findAndUnwrapPaginatedRepeatedField() {
        for (Field field : this.fields()) {
            if (!field.isMap()) continue;
            ImmutableList<Reference> repeatedGenericMapRefs = field.type().reference().generics();
            TypeNode paginatedType = TypeNode.withReference(ConcreteReference.builder().setClazz(Map.Entry.class).setGenerics(Arrays.asList((Reference)repeatedGenericMapRefs.get(0), (Reference)repeatedGenericMapRefs.get(1))).build());
            return field.toBuilder().setType(paginatedType).build();
        }
        for (Field field : this.fields()) {
            if (!field.isRepeated() || field.isMap()) continue;
            Reference repeatedGenericRef = (Reference)field.type().reference().generics().get(0);
            return field.toBuilder().setType(TypeNode.withReference(repeatedGenericRef)).build();
        }
        return null;
    }

    public static Builder builder() {
        return new AutoValue_Message.Builder().setNestedEnums(Collections.emptyList()).setOuterNestedTypes(Collections.emptyList()).setFields(Collections.emptyList()).setFieldMap(Collections.emptyMap()).setEnumValues(Collections.emptyMap()).setOperationResponseFields(HashBiMap.create()).setOperationRequestFields(Collections.emptyMap());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setFullProtoName(String var1);

        public abstract Builder setFields(List<Field> var1);

        public Builder setEnumValues(List<String> names, List<Integer> numbers) {
            return this.setEnumValues(IntStream.range(0, names.size()).boxed().collect(Collectors.toMap(i -> (String)names.get((int)i), i -> (Integer)numbers.get((int)i))));
        }

        public abstract Builder setEnumValues(Map<String, Integer> var1);

        public abstract Builder setType(TypeNode var1);

        public abstract Builder setResource(ResourceName var1);

        public abstract Builder setOuterNestedTypes(List<String> var1);

        public abstract Builder setOperationResponse(OperationResponse var1);

        public abstract Builder setOperationRequestFields(Map<String, String> var1);

        public abstract Builder setOperationResponseFields(BiMap<String, String> var1);

        public abstract Builder setNestedEnums(List<String> var1);

        abstract Builder setFieldMap(Map<String, Field> var1);

        abstract ImmutableList<Field> fields();

        abstract ImmutableMap<String, Integer> enumValues();

        abstract Message autoBuild();

        public Message build() {
            Message message = this.autoBuild();
            if (!message.fields().isEmpty()) {
                Map<String, Field> fieldMap = this.fields().stream().collect(Collectors.toMap(f -> f.name(), f -> f));
                this.fields().stream().filter(f -> f.hasFieldNameConflict()).forEach(f -> fieldMap.put(f.originalName(), (Field)f));
                message = message.toBuilder().setFieldMap(fieldMap).autoBuild();
            }
            return message;
        }
    }
}

