/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.GrpcApiExceptionFactory;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StreamController;
import java.util.concurrent.CancellationException;

class ExceptionResponseObserver<RequestT, ResponseT>
extends StateCheckingResponseObserver<ResponseT> {
    private ResponseObserver<ResponseT> innerObserver;
    private volatile CancellationException cancellationException;
    private final GrpcApiExceptionFactory exceptionFactory;

    public ExceptionResponseObserver(ResponseObserver<ResponseT> innerObserver, GrpcApiExceptionFactory exceptionFactory) {
        this.innerObserver = innerObserver;
        this.exceptionFactory = exceptionFactory;
    }

    @Override
    protected void onStartImpl(final StreamController controller) {
        this.innerObserver.onStart(new StreamController(){

            @Override
            public void cancel() {
                ExceptionResponseObserver.this.cancellationException = new CancellationException("User cancelled stream");
                controller.cancel();
            }

            @Override
            public void disableAutoInboundFlowControl() {
                controller.disableAutoInboundFlowControl();
            }

            @Override
            public void request(int count) {
                controller.request(count);
            }
        });
    }

    @Override
    protected void onResponseImpl(ResponseT response) {
        this.innerObserver.onResponse(response);
    }

    @Override
    protected void onErrorImpl(Throwable t2) {
        t2 = this.cancellationException != null ? this.cancellationException : this.exceptionFactory.create(t2);
        this.innerObserver.onError(t2);
    }

    @Override
    protected void onCompleteImpl() {
        this.innerObserver.onComplete();
    }
}

