/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.client.util.SecurityUtils;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.mtls.MtlsProvider;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;

@InternalApi(value="for testing")
public class FakeMtlsProvider
extends MtlsProvider {
    private boolean useClientCertificate;
    private MtlsProvider.MtlsEndpointUsagePolicy mtlsEndpointUsagePolicy;
    private KeyStore keyStore;
    private boolean throwExceptionForGetKeyStore;

    public FakeMtlsProvider(boolean useClientCertificate, MtlsProvider.MtlsEndpointUsagePolicy mtlsEndpointUsagePolicy, KeyStore keystore, String keyStorePassword, boolean throwExceptionForGetKeyStore) {
        this.useClientCertificate = useClientCertificate;
        this.mtlsEndpointUsagePolicy = mtlsEndpointUsagePolicy;
        this.keyStore = keystore;
        this.throwExceptionForGetKeyStore = throwExceptionForGetKeyStore;
    }

    @Override
    public boolean useMtlsClientCertificate() {
        return this.useClientCertificate;
    }

    @Override
    public MtlsProvider.MtlsEndpointUsagePolicy getMtlsEndpointUsagePolicy() {
        return this.mtlsEndpointUsagePolicy;
    }

    @Override
    public KeyStore getKeyStore() throws IOException {
        if (this.throwExceptionForGetKeyStore) {
            throw new IOException("getKeyStore throws exception");
        }
        return this.keyStore;
    }

    public static KeyStore createTestMtlsKeyStore() throws IOException {
        try {
            InputStream certAndKey = FakeMtlsProvider.class.getClassLoader().getResourceAsStream("com/google/api/gax/rpc/mtls/mtlsCertAndKey.pem");
            return SecurityUtils.createMtlsKeyStore(certAndKey);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to create key store", e);
        }
    }
}

