/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.Status;
import io.grpc.internal.PickFirstLoadBalancerProvider;
import io.grpc.util.ForwardingLoadBalancerHelper;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@Internal
public abstract class MultiChildLoadBalancer
extends LoadBalancer {
    private static final Logger logger = Logger.getLogger(MultiChildLoadBalancer.class.getName());
    private final Map<Object, ChildLbState> childLbStates = new LinkedHashMap<Object, ChildLbState>();
    private final LoadBalancer.Helper helper;
    protected boolean resolvingAddresses;
    protected final LoadBalancerProvider pickFirstLbProvider = new PickFirstLoadBalancerProvider();
    protected ConnectivityState currentConnectivityState;

    protected MultiChildLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        logger.log(Level.FINE, "Created");
    }

    protected abstract void updateOverallBalancingState();

    protected Map<Object, LoadBalancer.ResolvedAddresses> createChildAddressesMap(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        HashMap<Object, LoadBalancer.ResolvedAddresses> childAddresses = new HashMap<Object, LoadBalancer.ResolvedAddresses>();
        for (EquivalentAddressGroup eag : resolvedAddresses.getAddresses()) {
            LoadBalancer.ResolvedAddresses addresses = resolvedAddresses.toBuilder().setAddresses(Collections.singletonList(eag)).setAttributes(Attributes.newBuilder().set(IS_PETIOLE_POLICY, true).build()).setLoadBalancingPolicyConfig(null).build();
            childAddresses.put(new Endpoint(eag), addresses);
        }
        return childAddresses;
    }

    protected ChildLbState createChildLbState(Object key) {
        return new ChildLbState(key, this.pickFirstLbProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        try {
            this.resolvingAddresses = true;
            AcceptResolvedAddrRetVal acceptRetVal = this.acceptResolvedAddressesInternal(resolvedAddresses);
            if (!acceptRetVal.status.isOk()) {
                Status status = acceptRetVal.status;
                return status;
            }
            this.updateOverallBalancingState();
            this.shutdownRemoved(acceptRetVal.removedChildren);
            Status status = acceptRetVal.status;
            return status;
        }
        finally {
            this.resolvingAddresses = false;
        }
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.currentConnectivityState != ConnectivityState.READY) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error)));
        }
    }

    @Override
    public void shutdown() {
        logger.log(Level.FINE, "Shutdown");
        for (ChildLbState state : this.childLbStates.values()) {
            state.shutdown();
        }
        this.childLbStates.clear();
    }

    protected final AcceptResolvedAddrRetVal acceptResolvedAddressesInternal(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        logger.log(Level.FINE, "Received resolution result: {0}", resolvedAddresses);
        Map<Object, LoadBalancer.ResolvedAddresses> newChildAddresses = this.createChildAddressesMap(resolvedAddresses);
        if (newChildAddresses.isEmpty()) {
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. " + resolvedAddresses);
            this.handleNameResolutionError(unavailableStatus);
            return new AcceptResolvedAddrRetVal(unavailableStatus, null);
        }
        this.updateChildrenWithResolvedAddresses(newChildAddresses);
        return new AcceptResolvedAddrRetVal(Status.OK, this.getRemovedChildren(newChildAddresses.keySet()));
    }

    private void updateChildrenWithResolvedAddresses(Map<Object, LoadBalancer.ResolvedAddresses> newChildAddresses) {
        for (Map.Entry<Object, LoadBalancer.ResolvedAddresses> entry : newChildAddresses.entrySet()) {
            ChildLbState childLbState = this.childLbStates.get(entry.getKey());
            if (childLbState == null) {
                childLbState = this.createChildLbState(entry.getKey());
                this.childLbStates.put(entry.getKey(), childLbState);
            }
            childLbState.setResolvedAddresses(entry.getValue());
            childLbState.lb.handleResolvedAddresses(entry.getValue());
        }
    }

    private List<ChildLbState> getRemovedChildren(Set<Object> newChildKeys) {
        ArrayList<ChildLbState> removedChildren = new ArrayList<ChildLbState>();
        for (Object e : ImmutableList.copyOf(this.childLbStates.keySet())) {
            if (newChildKeys.contains(e)) continue;
            ChildLbState childLbState = this.childLbStates.remove(e);
            removedChildren.add(childLbState);
        }
        return removedChildren;
    }

    protected final void shutdownRemoved(List<ChildLbState> removedChildren) {
        for (ChildLbState childLbState : removedChildren) {
            childLbState.shutdown();
        }
    }

    @Nullable
    protected static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    protected final LoadBalancer.Helper getHelper() {
        return this.helper;
    }

    @VisibleForTesting
    public final Collection<ChildLbState> getChildLbStates() {
        return this.childLbStates.values();
    }

    @VisibleForTesting
    public final ChildLbState getChildLbState(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof EquivalentAddressGroup) {
            key = new Endpoint((EquivalentAddressGroup)key);
        }
        return this.childLbStates.get(key);
    }

    @VisibleForTesting
    public final ChildLbState getChildLbStateEag(EquivalentAddressGroup eag) {
        return this.getChildLbState(new Endpoint(eag));
    }

    protected final List<ChildLbState> getReadyChildren() {
        ArrayList<ChildLbState> activeChildren = new ArrayList<ChildLbState>();
        for (ChildLbState child : this.getChildLbStates()) {
            if (child.getCurrentState() != ConnectivityState.READY) continue;
            activeChildren.add(child);
        }
        return activeChildren;
    }

    protected static class AcceptResolvedAddrRetVal {
        public final Status status;
        public final List<ChildLbState> removedChildren;

        public AcceptResolvedAddrRetVal(Status status, List<ChildLbState> removedChildren) {
            this.status = status;
            this.removedChildren = removedChildren;
        }
    }

    protected static class Endpoint {
        final Collection<SocketAddress> addrs;
        final int hashCode;

        public Endpoint(EquivalentAddressGroup eag) {
            Preconditions.checkNotNull(eag, "eag");
            this.addrs = eag.getAddresses().size() < 10 ? eag.getAddresses() : new HashSet<SocketAddress>(eag.getAddresses());
            int sum = 0;
            for (SocketAddress address : eag.getAddresses()) {
                sum += address.hashCode();
            }
            this.hashCode = sum;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Endpoint)) {
                return false;
            }
            Endpoint o = (Endpoint)other;
            if (o.hashCode != this.hashCode || o.addrs.size() != this.addrs.size()) {
                return false;
            }
            return o.addrs.containsAll(this.addrs);
        }

        public String toString() {
            return this.addrs.toString();
        }
    }

    public class ChildLbState {
        private final Object key;
        private LoadBalancer.ResolvedAddresses resolvedAddresses;
        private final LoadBalancer lb;
        private ConnectivityState currentState;
        private LoadBalancer.SubchannelPicker currentPicker = new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult());

        public ChildLbState(Object key, LoadBalancer.Factory policyFactory) {
            this.key = key;
            this.lb = policyFactory.newLoadBalancer(this.createChildHelper());
            this.currentState = ConnectivityState.CONNECTING;
        }

        protected ChildLbStateHelper createChildHelper() {
            return new ChildLbStateHelper();
        }

        protected void shutdown() {
            this.lb.shutdown();
            this.currentState = ConnectivityState.SHUTDOWN;
            logger.log(Level.FINE, "Child balancer {0} deleted", this.key);
        }

        public String toString() {
            return "Address = " + this.key + ", state = " + (Object)((Object)this.currentState) + ", picker type: " + this.currentPicker.getClass() + ", lb: " + this.lb;
        }

        public final Object getKey() {
            return this.key;
        }

        @VisibleForTesting
        public final LoadBalancer getLb() {
            return this.lb;
        }

        @VisibleForTesting
        public final LoadBalancer.SubchannelPicker getCurrentPicker() {
            return this.currentPicker;
        }

        public final ConnectivityState getCurrentState() {
            return this.currentState;
        }

        protected final void setCurrentState(ConnectivityState newState) {
            this.currentState = newState;
        }

        protected final void setCurrentPicker(LoadBalancer.SubchannelPicker newPicker) {
            this.currentPicker = newPicker;
        }

        public final EquivalentAddressGroup getEag() {
            if (this.resolvedAddresses == null || this.resolvedAddresses.getAddresses().isEmpty()) {
                return null;
            }
            return this.resolvedAddresses.getAddresses().get(0);
        }

        protected final void setResolvedAddresses(LoadBalancer.ResolvedAddresses newAddresses) {
            Preconditions.checkNotNull(newAddresses, "Missing address list for child");
            this.resolvedAddresses = newAddresses;
        }

        @VisibleForTesting
        public final LoadBalancer.ResolvedAddresses getResolvedAddresses() {
            return this.resolvedAddresses;
        }

        protected class ChildLbStateHelper
        extends ForwardingLoadBalancerHelper {
            protected ChildLbStateHelper() {
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (ChildLbState.this.currentState == ConnectivityState.SHUTDOWN) {
                    return;
                }
                ChildLbState.this.currentState = newState;
                ChildLbState.this.currentPicker = newPicker;
                if (!MultiChildLoadBalancer.this.resolvingAddresses) {
                    MultiChildLoadBalancer.this.updateOverallBalancingState();
                }
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return MultiChildLoadBalancer.this.helper;
            }
        }
    }
}

