/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.generator.gapic.model.GapicServiceConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.serviceconfig.ServiceConfig;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Optional;

public class ServiceConfigParser {
    public static Optional<GapicServiceConfig> parse(String serviceConfigFilePath) {
        Optional<ServiceConfig> rawConfigOpt = ServiceConfigParser.parseFile(serviceConfigFilePath);
        return Optional.of(GapicServiceConfig.create(rawConfigOpt));
    }

    @VisibleForTesting
    static Optional<ServiceConfig> parseFile(String serviceConfigFilePath) {
        if (Strings.isNullOrEmpty(serviceConfigFilePath)) {
            return Optional.empty();
        }
        ServiceConfig.Builder builder = ServiceConfig.newBuilder();
        FileReader file = null;
        try {
            file = new FileReader(serviceConfigFilePath);
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
        try {
            JsonFormat.parser().merge(file, (Message.Builder)builder);
        }
        catch (IOException e) {
            return Optional.empty();
        }
        return Optional.of(builder.build());
    }
}

