/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_SynchronizedStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.ThisObjectValue;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;

@AutoValue
public abstract class SynchronizedStatement
implements Statement {
    public abstract Expr lock();

    public abstract ImmutableList<Statement> body();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_SynchronizedStatement.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public Builder setLock(ThisObjectValue thisObjectValue) {
            return this.setLock(ValueExpr.withValue(thisObjectValue));
        }

        public Builder setLock(VariableExpr variableExpr) {
            Preconditions.checkState(TypeNode.isReferenceType(variableExpr.type()), String.format("Synchronized lock object %s must be an object type, was %s", variableExpr.variable().identifier().name(), variableExpr.type()));
            return this.setLock((Expr)variableExpr);
        }

        public Builder setBody(Statement ... statements) {
            return this.setBody(Arrays.asList(statements));
        }

        public abstract Builder setBody(List<Statement> var1);

        abstract Builder setLock(Expr var1);

        abstract ImmutableList<Statement> body();

        abstract SynchronizedStatement autoBuild();

        public SynchronizedStatement build() {
            NodeValidator.checkNoNullElements(this.body(), "body statements", "synchronized statement");
            return this.autoBuild();
        }
    }
}

