/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.gapic.model.AutoValue_GapicBatchingSettings;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.Service;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class GapicBatchingSettings {
    public abstract String protoPakkage();

    public abstract String serviceName();

    public abstract String methodName();

    public abstract int elementCountThreshold();

    public abstract long requestByteThreshold();

    public abstract long delayThresholdMillis();

    @Nullable
    public abstract Integer flowControlElementLimit();

    @Nullable
    public abstract Integer flowControlByteLimit();

    public abstract FlowControlLimitExceededBehavior flowControlLimitExceededBehavior();

    public abstract String batchedFieldName();

    public abstract ImmutableList<String> discriminatorFieldNames();

    @Nullable
    public abstract String subresponseFieldName();

    public boolean matches(Service service, Method method) {
        return this.protoPakkage().equals(service.protoPakkage()) && this.serviceName().equals(service.name()) && this.methodName().equals(method.name());
    }

    public static Builder builder() {
        return new AutoValue_GapicBatchingSettings.Builder().setFlowControlLimitExceededBehavior(FlowControlLimitExceededBehavior.IGNORE);
    }

    public static enum FlowControlLimitExceededBehavior {
        THROW_EXCEPTION,
        BLOCK,
        IGNORE;

    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setProtoPakkage(String var1);

        public abstract Builder setServiceName(String var1);

        public abstract Builder setMethodName(String var1);

        public abstract Builder setElementCountThreshold(int var1);

        public abstract Builder setRequestByteThreshold(long var1);

        public abstract Builder setDelayThresholdMillis(long var1);

        public abstract Builder setFlowControlElementLimit(Integer var1);

        public abstract Builder setFlowControlByteLimit(Integer var1);

        public abstract Builder setFlowControlLimitExceededBehavior(FlowControlLimitExceededBehavior var1);

        public abstract Builder setBatchedFieldName(String var1);

        public abstract Builder setDiscriminatorFieldNames(List<String> var1);

        public abstract Builder setSubresponseFieldName(String var1);

        public abstract GapicBatchingSettings build();
    }
}

