/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_AssignmentExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.TypeMismatchException;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class AssignmentExpr
implements Expr {
    public abstract VariableExpr variableExpr();

    public abstract Expr valueExpr();

    @Override
    public TypeNode type() {
        return TypeNode.VOID;
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_AssignmentExpr.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setVariableExpr(VariableExpr var1);

        public abstract Builder setValueExpr(Expr var1);

        abstract AssignmentExpr autoBuild();

        public AssignmentExpr build() {
            AssignmentExpr assignmentExpr = this.autoBuild();
            TypeNode lhsType = assignmentExpr.variableExpr().variable().type();
            TypeNode rhsType = assignmentExpr.valueExpr().type();
            if (lhsType.isPrimitiveType() || rhsType.isPrimitiveType()) {
                if (rhsType == TypeNode.NULL || lhsType == TypeNode.NULL) {
                    throw new TypeMismatchException(String.format("Null cannot be assigned to the primitive type %s", lhsType.toString()));
                }
                if (!lhsType.equals(rhsType)) {
                    throw new TypeMismatchException(String.format("LHS type %s must match RHS type %s", lhsType.toString(), rhsType.toString()));
                }
            } else if (rhsType != TypeNode.NULL && !lhsType.isSupertypeOrEquals(rhsType)) {
                throw new TypeMismatchException(String.format("LHS type %s of variable %s must be a supertype of the RHS type %s", lhsType.reference().name(), assignmentExpr.variableExpr().variable().identifier(), rhsType.reference().name()));
            }
            if (!assignmentExpr.variableExpr().isDecl()) {
                Preconditions.checkState(!assignmentExpr.variableExpr().isFinal(), String.format("Cannot assign a value to final variable '%s'.", assignmentExpr.variableExpr().variable().name()));
            }
            return assignmentExpr;
        }
    }
}

