/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.samplecode;

import com.google.api.core.ApiFuture;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStream;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.generator.engine.ast.AnonymousClassExpr;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.BreakStatement;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.ForStatement;
import com.google.api.generator.engine.ast.IfStatement;
import com.google.api.generator.engine.ast.LineComment;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.PrimitiveValue;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.TryCatchStatement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.UnaryOperationExpr;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.Variable;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.engine.ast.WhileStatement;
import com.google.api.generator.gapic.composer.defaultvalue.DefaultValueComposer;
import com.google.api.generator.gapic.composer.samplecode.SampleComposerUtil;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.RegionTag;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.Sample;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.longrunning.Operation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ServiceClientCallableMethodSampleComposer {
    private static Sample composeUnaryOrLroCallableSample(Method method, VariableExpr clientVarExpr, VariableExpr requestVarExpr, Service service) {
        ArrayList<Statement> bodyStatements = new ArrayList<Statement>();
        TypeNode apiFutureType = TypeNode.withReference(ConcreteReference.builder().setClazz(ApiFuture.class).setGenerics(method.hasLro() ? ConcreteReference.withClazz(Operation.class) : method.outputType().reference()).build());
        VariableExpr apiFutureVarExpr = VariableExpr.withVariable(Variable.builder().setName("future").setType(apiFutureType).build());
        MethodInvocationExpr callableMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientVarExpr).setMethodName(JavaStyle.toLowerCamelCase(String.format("%sCallable", method.name()))).build();
        callableMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(callableMethodInvocationExpr).setMethodName("futureCall").setArguments(requestVarExpr).setReturnType(apiFutureType).build();
        AssignmentExpr futureAssignmentExpr = AssignmentExpr.builder().setVariableExpr(apiFutureVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(callableMethodInvocationExpr).build();
        bodyStatements.add(ExprStatement.withExpr(futureAssignmentExpr));
        bodyStatements.add(CommentStatement.withComment(LineComment.withComment("Do something.")));
        MethodInvocationExpr getMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(apiFutureVarExpr).setMethodName("get").setReturnType(method.outputType()).build();
        TypeNode methodOutputType = method.hasLro() ? method.lro().responseType() : method.outputType();
        boolean returnsVoid = methodOutputType.isProtoEmptyType();
        if (returnsVoid) {
            bodyStatements.add(ExprStatement.withExpr(getMethodInvocationExpr));
        } else {
            VariableExpr responseVarExpr = VariableExpr.builder().setVariable(Variable.builder().setType(method.outputType()).setName("response").build()).setIsDecl(true).build();
            AssignmentExpr responseAssignmentExpr = AssignmentExpr.builder().setVariableExpr(responseVarExpr).setValueExpr(getMethodInvocationExpr).build();
            bodyStatements.add(ExprStatement.withExpr(responseAssignmentExpr));
        }
        RegionTag regionTag = RegionTag.builder().setServiceName(service.name()).setRpcName(method.name()).setIsAsynchronous(true).build();
        return Sample.builder().setBody(bodyStatements).setRegionTag(regionTag).setIsCanonical(true).build();
    }

    private static Sample composePagedCallableSample(Method method, VariableExpr clientVarExpr, VariableExpr requestVarExpr, Map<String, Message> messageTypes, Service service) {
        Message methodOutputMessage = messageTypes.get(method.outputType().reference().fullName());
        Field repeatedPagedResultsField = methodOutputMessage.findAndUnwrapPaginatedRepeatedField();
        Preconditions.checkNotNull(repeatedPagedResultsField, String.format("No repeated field found on message %s for method %s", methodOutputMessage.name(), method.name()));
        TypeNode repeatedResponseType = repeatedPagedResultsField.type();
        VariableExpr responseVarExpr = VariableExpr.withVariable(Variable.builder().setName("response").setType(method.outputType()).build());
        MethodInvocationExpr pagedCallableMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientVarExpr).setMethodName(JavaStyle.toLowerCamelCase(String.format("%sCallable", method.name()))).build();
        pagedCallableMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(pagedCallableMethodInvocationExpr).setMethodName("call").setArguments(requestVarExpr).setReturnType(method.outputType()).build();
        AssignmentExpr responseAssignmentExpr = AssignmentExpr.builder().setVariableExpr(responseVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(pagedCallableMethodInvocationExpr).build();
        ArrayList<Statement> whileBodyStatements = new ArrayList<Statement>();
        whileBodyStatements.add(ExprStatement.withExpr(responseAssignmentExpr));
        VariableExpr repeatedResponseVarExpr = VariableExpr.withVariable(Variable.builder().setName("element").setType(repeatedResponseType).build());
        MethodInvocationExpr getResponseListMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(responseVarExpr).setMethodName("get" + JavaStyle.toUpperCamelCase(String.format("%s", repeatedPagedResultsField.name())) + "List").build();
        ForStatement responseForStatements = ForStatement.builder().setLocalVariableExpr(repeatedResponseVarExpr.toBuilder().setIsDecl(true).build()).setCollectionExpr(getResponseListMethodInvocationExpr).setBody(Arrays.asList(CommentStatement.withComment(LineComment.withComment("doThingsWith(element);")))).build();
        whileBodyStatements.add(responseForStatements);
        VariableExpr nextPageTokenVarExpr = VariableExpr.withVariable(Variable.builder().setName("nextPageToken").setType(TypeNode.STRING).build());
        MethodInvocationExpr getNextPageTokenMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(responseVarExpr).setMethodName("getNextPageToken").setReturnType(TypeNode.STRING).build();
        AssignmentExpr nextPageTokenAssignmentExpr = AssignmentExpr.builder().setVariableExpr(nextPageTokenVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(getNextPageTokenMethodInvocationExpr).build();
        whileBodyStatements.add(ExprStatement.withExpr(nextPageTokenAssignmentExpr));
        UnaryOperationExpr conditionExpr = UnaryOperationExpr.logicalNotWithExpr(MethodInvocationExpr.builder().setStaticReferenceType(TypeNode.withReference(ConcreteReference.withClazz(Strings.class))).setMethodName("isNullOrEmpty").setArguments(nextPageTokenVarExpr).setReturnType(TypeNode.BOOLEAN).build());
        MethodInvocationExpr setPageTokenMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(requestVarExpr).setMethodName("toBuilder").build();
        setPageTokenMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(setPageTokenMethodInvocationExpr).setMethodName("setPageToken").setArguments(nextPageTokenVarExpr).build();
        setPageTokenMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(setPageTokenMethodInvocationExpr).setMethodName("build").setReturnType(method.inputType()).build();
        AssignmentExpr requestReAssignmentExpr = AssignmentExpr.builder().setVariableExpr(requestVarExpr).setValueExpr(setPageTokenMethodInvocationExpr).build();
        IfStatement nextPageTokenIfStatement = IfStatement.builder().setConditionExpr(conditionExpr).setBody(Arrays.asList(ExprStatement.withExpr(requestReAssignmentExpr))).setElseBody(Arrays.asList(BreakStatement.create())).build();
        whileBodyStatements.add(nextPageTokenIfStatement);
        WhileStatement pagedWhileStatement = WhileStatement.builder().setConditionExpr(ValueExpr.withValue(PrimitiveValue.builder().setValue("true").setType(TypeNode.BOOLEAN).build())).setBody(whileBodyStatements).build();
        RegionTag regionTag = RegionTag.builder().setServiceName(service.name()).setRpcName(method.name()).setOverloadDisambiguation("Paged").setIsAsynchronous(true).build();
        return Sample.builder().setBody(Arrays.asList(pagedWhileStatement)).setRegionTag(regionTag).build();
    }

    public static Sample composeLroCallableMethod(Method method, TypeNode clientType, Map<String, ResourceName> resourceNames, Map<String, Message> messageTypes, Service service) {
        VariableExpr clientVarExpr = VariableExpr.withVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(clientType.reference().name())).setType(clientType).build());
        VariableExpr requestVarExpr = VariableExpr.withVariable(Variable.builder().setName("request").setType(method.inputType()).build());
        Message requestMessage = messageTypes.get(method.inputType().reference().fullName());
        Preconditions.checkNotNull(requestMessage, String.format("Could not find the message type %s.", method.inputType().reference().fullName()));
        Expr requestBuilderExpr = DefaultValueComposer.createSimpleMessageBuilderValue(requestMessage, resourceNames, messageTypes, method.httpBindings());
        AssignmentExpr requestAssignmentExpr = AssignmentExpr.builder().setVariableExpr(requestVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(requestBuilderExpr).build();
        ArrayList<Expr> bodyExprs = new ArrayList<Expr>();
        bodyExprs.add(requestAssignmentExpr);
        TypeNode operationFutureType = TypeNode.withReference(ConcreteReference.builder().setClazz(OperationFuture.class).setGenerics(method.lro().responseType().reference(), method.lro().metadataType().reference()).build());
        VariableExpr operationFutureVarExpr = VariableExpr.withVariable(Variable.builder().setName("future").setType(operationFutureType).build());
        MethodInvocationExpr rpcMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientVarExpr).setMethodName(String.format("%sOperationCallable", JavaStyle.toLowerCamelCase(method.name()))).build();
        rpcMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(rpcMethodInvocationExpr).setMethodName("futureCall").setArguments(requestVarExpr).setReturnType(operationFutureType).build();
        bodyExprs.add(AssignmentExpr.builder().setVariableExpr(operationFutureVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(rpcMethodInvocationExpr).build());
        List<Statement> bodyStatements = bodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList());
        bodyExprs.clear();
        bodyStatements.add(CommentStatement.withComment(LineComment.withComment("Do something.")));
        MethodInvocationExpr futureGetMethodExpr = MethodInvocationExpr.builder().setExprReferenceExpr(operationFutureVarExpr).setMethodName("get").setReturnType(method.lro().responseType()).build();
        boolean returnsVoid = method.lro().responseType().isProtoEmptyType();
        if (returnsVoid) {
            bodyExprs.add(futureGetMethodExpr);
        } else {
            VariableExpr responseVarExpr = VariableExpr.builder().setVariable(Variable.builder().setName("response").setType(method.lro().responseType()).build()).setIsDecl(true).build();
            bodyExprs.add(AssignmentExpr.builder().setVariableExpr(responseVarExpr).setValueExpr(futureGetMethodExpr).build());
        }
        bodyStatements.addAll(bodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
        bodyExprs.clear();
        RegionTag regionTag = RegionTag.builder().setServiceName(service.name()).setRpcName(method.name()).setIsAsynchronous(true).setOverloadDisambiguation("LRO").build();
        List<Statement> body = Arrays.asList(TryCatchStatement.builder().setTryResourceExpr(SampleComposerUtil.assignClientVariableWithCreateMethodExpr(clientVarExpr)).setTryBody(bodyStatements).setIsSampleCode(true).build());
        return Sample.builder().setBody(body).setRegionTag(regionTag).build();
    }

    public static Sample composePagedCallableMethod(Method method, TypeNode clientType, Map<String, ResourceName> resourceNames, Map<String, Message> messageTypes, Service service) {
        VariableExpr clientVarExpr = VariableExpr.withVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(clientType.reference().name())).setType(clientType).build());
        VariableExpr requestVarExpr = VariableExpr.withVariable(Variable.builder().setName("request").setType(method.inputType()).build());
        Message requestMessage = messageTypes.get(method.inputType().reference().fullName());
        Preconditions.checkNotNull(requestMessage, String.format("Could not find the message type %s.", method.inputType().reference().fullName()));
        Expr requestBuilderExpr = DefaultValueComposer.createSimpleMessageBuilderValue(requestMessage, resourceNames, messageTypes, method.httpBindings());
        AssignmentExpr requestAssignmentExpr = AssignmentExpr.builder().setVariableExpr(requestVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(requestBuilderExpr).build();
        ArrayList<AssignmentExpr> bodyExprs = new ArrayList<AssignmentExpr>();
        bodyExprs.add(requestAssignmentExpr);
        Message methodOutputMessage = messageTypes.get(method.outputType().reference().fullName());
        Field repeatedPagedResultsField = methodOutputMessage.findAndUnwrapPaginatedRepeatedField();
        Preconditions.checkNotNull(repeatedPagedResultsField, String.format("No repeated field found on message %s for method %s", methodOutputMessage.name(), method.name()));
        TypeNode repeatedResponseType = repeatedPagedResultsField.type();
        TypeNode apiFutureType = TypeNode.withReference(ConcreteReference.builder().setClazz(ApiFuture.class).setGenerics(repeatedResponseType.reference()).build());
        VariableExpr apiFutureVarExpr = VariableExpr.withVariable(Variable.builder().setName("future").setType(apiFutureType).build());
        MethodInvocationExpr pagedCallableFutureMethodExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientVarExpr).setMethodName(String.format("%sPagedCallable", JavaStyle.toLowerCamelCase(method.name()))).build();
        pagedCallableFutureMethodExpr = MethodInvocationExpr.builder().setExprReferenceExpr(pagedCallableFutureMethodExpr).setMethodName("futureCall").setArguments(requestVarExpr).setReturnType(apiFutureType).build();
        AssignmentExpr apiFutureAssignmentExpr = AssignmentExpr.builder().setVariableExpr(apiFutureVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(pagedCallableFutureMethodExpr).build();
        bodyExprs.add(apiFutureAssignmentExpr);
        List<Statement> bodyStatements = bodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList());
        bodyExprs.clear();
        bodyStatements.add(CommentStatement.withComment(LineComment.withComment("Do something.")));
        VariableExpr repeatedResponseVarExpr = VariableExpr.withVariable(Variable.builder().setName("element").setType(repeatedResponseType).build());
        MethodInvocationExpr futureGetIterateAllMethodExpr = MethodInvocationExpr.builder().setExprReferenceExpr(apiFutureVarExpr).setMethodName("get").build();
        futureGetIterateAllMethodExpr = MethodInvocationExpr.builder().setExprReferenceExpr(futureGetIterateAllMethodExpr).setMethodName("iterateAll").setReturnType(repeatedResponseType).build();
        CommentStatement lineCommentStatement = CommentStatement.withComment(LineComment.withComment("doThingsWith(element);"));
        ForStatement repeatedResponseForStatement = ForStatement.builder().setLocalVariableExpr(repeatedResponseVarExpr.toBuilder().setIsDecl(true).build()).setCollectionExpr(futureGetIterateAllMethodExpr).setBody(Arrays.asList(lineCommentStatement)).build();
        bodyStatements.add(repeatedResponseForStatement);
        List<Statement> body = Arrays.asList(TryCatchStatement.builder().setTryResourceExpr(SampleComposerUtil.assignClientVariableWithCreateMethodExpr(clientVarExpr)).setTryBody(bodyStatements).setIsSampleCode(true).build());
        RegionTag regionTag = RegionTag.builder().setServiceName(service.name()).setRpcName(method.name()).setIsAsynchronous(true).build();
        return Sample.builder().setBody(body).setRegionTag(regionTag).build();
    }

    public static Sample composeRegularCallableMethod(Method method, TypeNode clientType, Map<String, ResourceName> resourceNames, Map<String, Message> messageTypes, Service service) {
        RegionTag regionTag;
        VariableExpr clientVarExpr = VariableExpr.withVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(clientType.reference().name())).setType(clientType).build());
        VariableExpr requestVarExpr = VariableExpr.withVariable(Variable.builder().setName("request").setType(method.inputType()).build());
        Message requestMessage = messageTypes.get(method.inputType().reference().fullName());
        Preconditions.checkNotNull(requestMessage, String.format("Could not find the message type %s.", method.inputType().reference().fullName()));
        Expr requestBuilderExpr = DefaultValueComposer.createSimpleMessageBuilderValue(requestMessage, resourceNames, messageTypes, method.httpBindings());
        AssignmentExpr requestAssignmentExpr = AssignmentExpr.builder().setVariableExpr(requestVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(requestBuilderExpr).build();
        ArrayList<Statement> bodyStatements = new ArrayList<Statement>();
        bodyStatements.add(ExprStatement.withExpr(requestAssignmentExpr));
        if (method.isPaged()) {
            Sample pagedCallable = ServiceClientCallableMethodSampleComposer.composePagedCallableSample(method, clientVarExpr, requestVarExpr, messageTypes, service);
            bodyStatements.addAll(pagedCallable.body());
            regionTag = pagedCallable.regionTag();
        } else {
            Sample unaryOrLroCallable = ServiceClientCallableMethodSampleComposer.composeUnaryOrLroCallableSample(method, clientVarExpr, requestVarExpr, service);
            bodyStatements.addAll(unaryOrLroCallable.body());
            regionTag = unaryOrLroCallable.regionTag();
        }
        List<Statement> body = Arrays.asList(TryCatchStatement.builder().setTryResourceExpr(SampleComposerUtil.assignClientVariableWithCreateMethodExpr(clientVarExpr)).setTryBody(bodyStatements).setIsSampleCode(true).build());
        return Sample.builder().setBody(body).setRegionTag(regionTag).build();
    }

    public static Sample composeStreamCallableMethod(Method method, TypeNode clientType, Map<String, ResourceName> resourceNames, Map<String, Message> messageTypes, Service service) {
        VariableExpr clientVarExpr = VariableExpr.withVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(clientType.reference().name())).setType(clientType).build());
        VariableExpr requestVarExpr = VariableExpr.withVariable(Variable.builder().setName("request").setType(method.inputType()).build());
        Message requestMessage = messageTypes.get(method.inputType().reference().fullName());
        Preconditions.checkNotNull(requestMessage, String.format("Could not find the message type %s.", method.inputType().reference().fullName()));
        Expr requestBuilderExpr = DefaultValueComposer.createSimpleMessageBuilderValue(requestMessage, resourceNames, messageTypes, method.httpBindings());
        AssignmentExpr requestAssignmentExpr = AssignmentExpr.builder().setVariableExpr(requestVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(requestBuilderExpr).build();
        RegionTag regionTag = null;
        ArrayList<Statement> bodyStatements = new ArrayList<Statement>();
        if (method.stream().equals((Object)Method.Stream.SERVER)) {
            Sample streamServer = ServiceClientCallableMethodSampleComposer.composeStreamServerSample(method, clientVarExpr, requestAssignmentExpr, service);
            bodyStatements.addAll(streamServer.body());
            regionTag = streamServer.regionTag();
        } else if (method.stream().equals((Object)Method.Stream.BIDI)) {
            Sample streamBidi = ServiceClientCallableMethodSampleComposer.composeStreamBidiSample(method, clientVarExpr, requestAssignmentExpr, service);
            bodyStatements.addAll(streamBidi.body());
            regionTag = streamBidi.regionTag();
        } else if (method.stream().equals((Object)Method.Stream.CLIENT)) {
            Sample streamClient = ServiceClientCallableMethodSampleComposer.composeStreamClientSample(method, clientVarExpr, requestAssignmentExpr, service);
            bodyStatements.addAll(streamClient.body());
            regionTag = streamClient.regionTag();
        }
        List<Statement> body = Arrays.asList(TryCatchStatement.builder().setTryResourceExpr(SampleComposerUtil.assignClientVariableWithCreateMethodExpr(clientVarExpr)).setTryBody(bodyStatements).setIsSampleCode(true).build());
        return Sample.builder().setBody(body).setRegionTag(regionTag).build();
    }

    private static Sample composeStreamServerSample(Method method, VariableExpr clientVarExpr, AssignmentExpr requestAssignmentExpr, Service service) {
        ArrayList<AssignmentExpr> bodyExprs = new ArrayList<AssignmentExpr>();
        bodyExprs.add(requestAssignmentExpr);
        TypeNode serverStreamType = TypeNode.withReference(ConcreteReference.builder().setClazz(ServerStream.class).setGenerics(method.outputType().reference()).build());
        VariableExpr serverStreamVarExpr = VariableExpr.withVariable(Variable.builder().setName("stream").setType(serverStreamType).build());
        MethodInvocationExpr clientStreamCallMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientVarExpr).setMethodName(JavaStyle.toLowerCamelCase(String.format("%sCallable", method.name()))).build();
        clientStreamCallMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientStreamCallMethodInvocationExpr).setMethodName("call").setArguments(requestAssignmentExpr.variableExpr().toBuilder().setIsDecl(false).build()).setReturnType(serverStreamType).build();
        AssignmentExpr streamAssignmentExpr = AssignmentExpr.builder().setVariableExpr(serverStreamVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(clientStreamCallMethodInvocationExpr).build();
        bodyExprs.add(streamAssignmentExpr);
        List<Statement> bodyStatements = bodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList());
        VariableExpr responseVarExpr = VariableExpr.builder().setVariable(Variable.builder().setName("response").setType(method.outputType()).build()).setIsDecl(true).build();
        ForStatement forStatement = ForStatement.builder().setLocalVariableExpr(responseVarExpr).setCollectionExpr(serverStreamVarExpr).setBody(Arrays.asList(CommentStatement.withComment(LineComment.withComment("Do something when a response is received.")))).build();
        bodyStatements.add(forStatement);
        RegionTag regionTag = RegionTag.builder().setServiceName(service.name()).setRpcName(method.name()).setIsAsynchronous(true).build();
        return Sample.builder().setBody(bodyStatements).setRegionTag(regionTag).build();
    }

    private static Sample composeStreamBidiSample(Method method, VariableExpr clientVarExpr, AssignmentExpr requestAssignmentExpr, Service service) {
        ArrayList<Expr> bodyExprs = new ArrayList<Expr>();
        TypeNode bidiStreamType = TypeNode.withReference(ConcreteReference.builder().setClazz(BidiStream.class).setGenerics(method.inputType().reference(), method.outputType().reference()).build());
        VariableExpr bidiStreamVarExpr = VariableExpr.withVariable(Variable.builder().setName("bidiStream").setType(bidiStreamType).build());
        MethodInvocationExpr clientBidiStreamCallMethodInvoationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientVarExpr).setMethodName(JavaStyle.toLowerCamelCase(String.format("%sCallable", method.name()))).build();
        clientBidiStreamCallMethodInvoationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientBidiStreamCallMethodInvoationExpr).setMethodName("call").setReturnType(bidiStreamType).build();
        AssignmentExpr bidiStreamAssignmentExpr = AssignmentExpr.builder().setVariableExpr(bidiStreamVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(clientBidiStreamCallMethodInvoationExpr).build();
        bodyExprs.add(bidiStreamAssignmentExpr);
        bodyExprs.add(requestAssignmentExpr);
        MethodInvocationExpr sendMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(bidiStreamVarExpr).setArguments(requestAssignmentExpr.variableExpr().toBuilder().setIsDecl(false).build()).setMethodName("send").build();
        bodyExprs.add(sendMethodInvocationExpr);
        List<Statement> bodyStatements = bodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList());
        ForStatement forStatement = ForStatement.builder().setLocalVariableExpr(VariableExpr.builder().setVariable(Variable.builder().setType(method.outputType()).setName("response").build()).setIsDecl(true).build()).setCollectionExpr(bidiStreamVarExpr).setBody(Arrays.asList(CommentStatement.withComment(LineComment.withComment("Do something when a response is received.")))).build();
        bodyStatements.add(forStatement);
        RegionTag regionTag = RegionTag.builder().setServiceName(service.name()).setRpcName(method.name()).setIsAsynchronous(true).build();
        return Sample.builder().setBody(bodyStatements).setRegionTag(regionTag).build();
    }

    private static Sample composeStreamClientSample(Method method, VariableExpr clientVarExpr, AssignmentExpr requestAssignmentExpr, Service service) {
        ArrayList<Expr> bodyExprs = new ArrayList<Expr>();
        TypeNode responseObserverType = TypeNode.withReference(ConcreteReference.builder().setClazz(ApiStreamObserver.class).setGenerics(method.inputType().reference()).build());
        VariableExpr responseObserverVarExpr = VariableExpr.withVariable(Variable.builder().setName("responseObserver").setType(responseObserverType).build());
        MethodDefinition onNextMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setName("onNext").setArguments(VariableExpr.builder().setVariable(Variable.builder().setName("response").setType(method.outputType()).build()).setIsDecl(true).build()).setBody(Arrays.asList(CommentStatement.withComment(LineComment.withComment("Do something when a response is received.")))).setReturnType(TypeNode.VOID).build();
        MethodDefinition onErrorMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setName("onError").setArguments(VariableExpr.builder().setVariable(Variable.builder().setName("t").setType(TypeNode.withReference(ConcreteReference.withClazz(Throwable.class))).build()).setIsDecl(true).build()).setBody(Arrays.asList(CommentStatement.withComment(LineComment.withComment("Add error-handling")))).setReturnType(TypeNode.VOID).build();
        MethodDefinition onCompletedMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setName("onCompleted").setBody(Arrays.asList(CommentStatement.withComment(LineComment.withComment("Do something when complete.")))).setReturnType(TypeNode.VOID).build();
        AnonymousClassExpr anonymousClassExpr = AnonymousClassExpr.builder().setType(responseObserverType).setMethods(onNextMethod, onErrorMethod, onCompletedMethod).build();
        AssignmentExpr responseObserverAssignmentExpr = AssignmentExpr.builder().setVariableExpr(responseObserverVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(anonymousClassExpr).build();
        bodyExprs.add(responseObserverAssignmentExpr);
        TypeNode requestObserverType = TypeNode.withReference(ConcreteReference.builder().setClazz(ApiStreamObserver.class).setGenerics(method.inputType().reference()).build());
        VariableExpr requestObserverVarExpr = VariableExpr.withVariable(Variable.builder().setName("requestObserver").setType(responseObserverType).build());
        MethodInvocationExpr clientStreamCallMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientVarExpr).setMethodName(JavaStyle.toLowerCamelCase(method.name())).build();
        clientStreamCallMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientStreamCallMethodInvocationExpr).setArguments(responseObserverVarExpr).setMethodName("clientStreamingCall").setReturnType(requestObserverType).build();
        AssignmentExpr requestObserverAssignmentExpr = AssignmentExpr.builder().setVariableExpr(requestObserverVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(clientStreamCallMethodInvocationExpr).build();
        bodyExprs.add(requestObserverAssignmentExpr);
        bodyExprs.add(requestAssignmentExpr);
        MethodInvocationExpr onNextMethodExpr = MethodInvocationExpr.builder().setExprReferenceExpr(requestObserverVarExpr).setMethodName("onNext").setArguments(requestAssignmentExpr.variableExpr().toBuilder().setIsDecl(false).build()).build();
        bodyExprs.add(onNextMethodExpr);
        RegionTag regionTag = RegionTag.builder().setServiceName(service.name()).setRpcName(method.name()).setIsAsynchronous(true).build();
        return Sample.builder().setBody(bodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).setRegionTag(regionTag).build();
    }
}

