/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.EndpointContext;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.internal.ApiCallContextOptions;
import com.google.api.gax.rpc.internal.Headers;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.BaseApiTracer;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@InternalApi(value="for testing")
public class FakeCallContext
implements ApiCallContext {
    private final Credentials credentials;
    private final FakeChannel channel;
    private final Duration timeout;
    private final Duration streamWaitTimeout;
    private final Duration streamIdleTimeout;
    private final ImmutableMap<String, List<String>> extraHeaders;
    private final ApiCallContextOptions options;
    private final ApiTracer tracer;
    private final RetrySettings retrySettings;
    private final ImmutableSet<StatusCode.Code> retryableCodes;
    private final EndpointContext endpointContext;

    private FakeCallContext(Credentials credentials, FakeChannel channel, Duration timeout, Duration streamWaitTimeout, Duration streamIdleTimeout, ImmutableMap<String, List<String>> extraHeaders, ApiCallContextOptions options, ApiTracer tracer, RetrySettings retrySettings, Set<StatusCode.Code> retryableCodes, EndpointContext endpointContext) {
        this.credentials = credentials;
        this.channel = channel;
        this.timeout = timeout;
        this.streamWaitTimeout = streamWaitTimeout;
        this.streamIdleTimeout = streamIdleTimeout;
        this.extraHeaders = extraHeaders;
        this.options = options;
        this.tracer = tracer;
        this.retrySettings = retrySettings;
        this.retryableCodes = retryableCodes == null ? null : ImmutableSet.copyOf(retryableCodes);
        try {
            this.endpointContext = endpointContext == null ? EndpointContext.newBuilder().build() : endpointContext;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FakeCallContext createDefault() {
        return new FakeCallContext(null, null, null, null, null, ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null, null, null);
    }

    @Override
    public FakeCallContext nullToSelf(ApiCallContext inputContext) {
        FakeCallContext fakeCallContext;
        if (inputContext == null) {
            fakeCallContext = this;
        } else {
            if (!(inputContext instanceof FakeCallContext)) {
                throw new IllegalArgumentException("context must be an instance of FakeCallContext, but found " + inputContext.getClass().getName());
            }
            fakeCallContext = (FakeCallContext)inputContext;
        }
        return fakeCallContext;
    }

    @Override
    public ApiCallContext merge(ApiCallContext inputCallContext) {
        ImmutableSet<StatusCode.Code> newRetryableCodes;
        RetrySettings newRetrySettings;
        ApiTracer newTracer;
        Duration newStreamIdleTimeout;
        Duration newStreamWaitTimeout;
        Duration newTimeout;
        Credentials newCallCredentials;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof FakeCallContext)) {
            throw new IllegalArgumentException("context must be an instance of FakeCallContext, but found " + inputCallContext.getClass().getName());
        }
        FakeCallContext fakeCallContext = (FakeCallContext)inputCallContext;
        FakeChannel newChannel = fakeCallContext.channel;
        if (newChannel == null) {
            newChannel = this.channel;
        }
        if ((newCallCredentials = fakeCallContext.credentials) == null) {
            newCallCredentials = this.credentials;
        }
        if ((newTimeout = fakeCallContext.timeout) == null) {
            newTimeout = this.timeout;
        }
        if ((newStreamWaitTimeout = fakeCallContext.streamWaitTimeout) == null) {
            newStreamWaitTimeout = this.streamWaitTimeout;
        }
        if ((newStreamIdleTimeout = fakeCallContext.streamIdleTimeout) == null) {
            newStreamIdleTimeout = this.streamIdleTimeout;
        }
        if ((newTracer = fakeCallContext.tracer) == null) {
            newTracer = this.tracer;
        }
        if ((newRetrySettings = fakeCallContext.retrySettings) == null) {
            newRetrySettings = this.retrySettings;
        }
        if ((newRetryableCodes = fakeCallContext.retryableCodes) == null) {
            newRetryableCodes = this.retryableCodes;
        }
        ImmutableMap<String, List<String>> newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, fakeCallContext.extraHeaders);
        ApiCallContextOptions newOptions = this.options.merge(fakeCallContext.options);
        return new FakeCallContext(newCallCredentials, newChannel, newTimeout, newStreamWaitTimeout, newStreamIdleTimeout, newExtraHeaders, newOptions, newTracer, newRetrySettings, newRetryableCodes, this.endpointContext);
    }

    @Override
    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    @Override
    public FakeCallContext withRetrySettings(RetrySettings retrySettings) {
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    public Set<StatusCode.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    @Override
    public FakeCallContext withRetryableCodes(Set<StatusCode.Code> retryableCodes) {
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, retryableCodes, this.endpointContext);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public FakeChannel getChannel() {
        return this.channel;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    @Nullable
    public Duration getStreamWaitTimeout() {
        return this.streamWaitTimeout;
    }

    @Override
    @Nullable
    public Duration getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    @Override
    public FakeCallContext withCredentials(Credentials credentials) {
        return new FakeCallContext(credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    public FakeCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull(inputChannel);
        if (!(inputChannel instanceof FakeTransportChannel)) {
            throw new IllegalArgumentException("Expected FakeTransportChannel, got " + inputChannel.getClass().getName());
        }
        FakeTransportChannel transportChannel = (FakeTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    @Override
    public FakeCallContext withEndpointContext(EndpointContext endpointContext) {
        Preconditions.checkNotNull(endpointContext);
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, endpointContext);
    }

    public FakeCallContext withChannel(FakeChannel channel) {
        return new FakeCallContext(this.credentials, channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    public FakeCallContext withTimeout(Duration timeout) {
        if (timeout != null && (timeout.isZero() || timeout.isNegative())) {
            timeout = null;
        }
        if (timeout != null && this.timeout != null && this.timeout.compareTo(timeout) <= 0) {
            return this;
        }
        return new FakeCallContext(this.credentials, this.channel, timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    public ApiCallContext withStreamWaitTimeout(@Nullable Duration streamWaitTimeout) {
        return new FakeCallContext(this.credentials, this.channel, this.timeout, streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    public ApiCallContext withStreamIdleTimeout(@Nullable Duration streamIdleTimeout) {
        Preconditions.checkNotNull(streamIdleTimeout);
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    public ApiCallContext withExtraHeaders(Map<String, List<String>> extraHeaders) {
        Preconditions.checkNotNull(extraHeaders);
        ImmutableMap<String, List<String>> newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, extraHeaders);
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, newExtraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    @Override
    public <T> ApiCallContext withOption(ApiCallContext.Key<T> key, T value) {
        Preconditions.checkNotNull(key);
        ApiCallContextOptions newOptions = this.options.withOption(key, value);
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, newOptions, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    public <T> T getOption(ApiCallContext.Key<T> key) {
        Preconditions.checkNotNull(key);
        return this.options.getOption(key);
    }

    @Override
    @Nonnull
    public ApiTracer getTracer() {
        if (this.tracer == null) {
            return BaseApiTracer.getInstance();
        }
        return this.tracer;
    }

    @Override
    public ApiCallContext withTracer(@Nonnull ApiTracer tracer) {
        Preconditions.checkNotNull(tracer);
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    public static FakeCallContext create(ClientContext clientContext) {
        return FakeCallContext.createDefault().withTransportChannel(clientContext.getTransportChannel()).withCredentials(clientContext.getCredentials());
    }
}

