/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.gapic.model.GapicBatchingSettings;
import com.google.api.generator.gapic.model.GapicLanguageSettings;
import com.google.api.generator.gapic.model.GapicLroRetrySettings;
import com.google.api.generator.gapic.model.GapicRetrySettings;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.Service;
import com.google.protobuf.Duration;
import com.google.rpc.Code;
import io.grpc.serviceconfig.MethodConfig;
import io.grpc.serviceconfig.ServiceConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class GapicServiceConfig {
    public static final MethodConfig.RetryPolicy EMPTY_RETRY_POLICY = MethodConfig.RetryPolicy.newBuilder().build();
    public static final Duration EMPTY_TIMEOUT = Duration.newBuilder().setSeconds(5L).build();
    public static final List<Code> EMPTY_RETRY_CODES = Collections.emptyList();
    private static final String NO_RETRY_CODES_NAME = "no_retry_codes";
    private static final String NO_RETRY_PARAMS_NAME = "no_retry_params";
    private static final String NO_RETRY_CODES_PATTERN = "no_retry_%d_codes";
    private static final String NO_RETRY_PARAMS_PATTERN = "no_retry_%d_params";
    private static final String RETRY_CODES_PATTERN = "retry_policy_%d_codes";
    private static final String RETRY_PARAMS_PATTERN = "retry_policy_%d_params";
    private final List<MethodConfig> methodConfigs;
    private final Map<MethodConfig.Name, Integer> methodConfigTable;
    private final Map<MethodConfig.Name, GapicLroRetrySettings> lroRetrySettingsTable = new HashMap<MethodConfig.Name, GapicLroRetrySettings>();
    private final Map<MethodConfig.Name, GapicBatchingSettings> batchingSettingsTable = new HashMap<MethodConfig.Name, GapicBatchingSettings>();
    private Optional<GapicLanguageSettings> languageSettingsOpt = Optional.empty();

    private GapicServiceConfig(List<MethodConfig> methodConfigs, Map<MethodConfig.Name, Integer> methodConfigTable) {
        this.methodConfigs = methodConfigs;
        this.methodConfigTable = methodConfigTable;
    }

    public static GapicServiceConfig create(Optional<ServiceConfig> serviceConfigOpt) {
        if (!serviceConfigOpt.isPresent()) {
            return new GapicServiceConfig(Collections.emptyList(), Collections.emptyMap());
        }
        ServiceConfig serviceConfig = serviceConfigOpt.get();
        HashMap<MethodConfig.Name, Integer> methodConfigTable = new HashMap<MethodConfig.Name, Integer>();
        List<MethodConfig> methodConfigs = serviceConfig.getMethodConfigList();
        for (int i = 0; i < methodConfigs.size(); ++i) {
            MethodConfig methodConfig = methodConfigs.get(i);
            for (MethodConfig.Name name : methodConfig.getNameList()) {
                methodConfigTable.put(name, i);
            }
        }
        return new GapicServiceConfig(methodConfigs, methodConfigTable);
    }

    public void setLroRetrySettings(Optional<List<GapicLroRetrySettings>> lroRetrySettingsOpt) {
        if (!lroRetrySettingsOpt.isPresent()) {
            return;
        }
        this.lroRetrySettingsTable.clear();
        for (GapicLroRetrySettings lroRetrySetting : lroRetrySettingsOpt.get()) {
            this.lroRetrySettingsTable.put(MethodConfig.Name.newBuilder().setService(String.format("%s.%s", lroRetrySetting.protoPakkage(), lroRetrySetting.serviceName())).setMethod(lroRetrySetting.methodName()).build(), lroRetrySetting);
        }
    }

    public void setBatchingSettings(Optional<List<GapicBatchingSettings>> batchingSettingsOpt) {
        if (!batchingSettingsOpt.isPresent()) {
            return;
        }
        this.batchingSettingsTable.clear();
        for (GapicBatchingSettings batchingSetting : batchingSettingsOpt.get()) {
            this.batchingSettingsTable.put(MethodConfig.Name.newBuilder().setService(String.format("%s.%s", batchingSetting.protoPakkage(), batchingSetting.serviceName())).setMethod(batchingSetting.methodName()).build(), batchingSetting);
        }
    }

    public void setLanguageSettings(Optional<GapicLanguageSettings> languageSettingsOpt) {
        this.languageSettingsOpt = languageSettingsOpt;
    }

    public Optional<GapicLanguageSettings> getLanguageSettingsOpt() {
        return this.languageSettingsOpt;
    }

    public Map<String, GapicRetrySettings> getAllGapicRetrySettings(Service service) {
        return service.methods().stream().collect(Collectors.toMap(m4 -> this.getRetryParamsName(service, (Method)m4), m4 -> this.toGapicRetrySettings(service, (Method)m4), (r1, r2) -> r2, LinkedHashMap::new));
    }

    public Map<String, List<Code>> getAllRetryCodes(Service service) {
        return service.methods().stream().collect(Collectors.toMap(m4 -> this.getRetryCodeName(service, (Method)m4), m4 -> this.retryCodesLookup(service, (Method)m4), (l1, l2) -> l2, LinkedHashMap::new));
    }

    public String getRetryCodeName(Service service, Method method) {
        Optional<Integer> retryPolicyIndexOpt = this.retryPolicyIndexLookup(service, method);
        if (retryPolicyIndexOpt.isPresent()) {
            return this.getRetryCodeName(retryPolicyIndexOpt.get());
        }
        return NO_RETRY_CODES_NAME;
    }

    public String getRetryParamsName(Service service, Method method) {
        Optional<Integer> retryPolicyIndexOpt = this.retryPolicyIndexLookup(service, method);
        if (retryPolicyIndexOpt.isPresent()) {
            return this.getRetryParamsName(retryPolicyIndexOpt.get());
        }
        return NO_RETRY_PARAMS_NAME;
    }

    public boolean hasLroRetrySetting(Service service, Method method) {
        return this.lroRetrySettingsTable.containsKey(this.toName(service, method));
    }

    public boolean hasBatchingSetting(Service service, Method method) {
        return this.batchingSettingsTable.containsKey(this.toName(service, method));
    }

    public boolean hasBatchingSetting(String protoPakkage, String serviceName, String methodName) {
        return this.batchingSettingsTable.containsKey(MethodConfig.Name.newBuilder().setService(String.format("%s.%s", protoPakkage, serviceName)).setMethod(methodName).build());
    }

    public Optional<GapicLroRetrySettings> getLroRetrySetting(Service service, Method method) {
        return this.hasLroRetrySetting(service, method) ? Optional.of(this.lroRetrySettingsTable.get(this.toName(service, method))) : Optional.empty();
    }

    public Optional<GapicBatchingSettings> getBatchingSetting(Service service, Method method) {
        return this.hasBatchingSetting(service, method) ? Optional.of(this.batchingSettingsTable.get(this.toName(service, method))) : Optional.empty();
    }

    private GapicRetrySettings toGapicRetrySettings(Service service, Method method) {
        MethodConfig methodConfig;
        GapicRetrySettings.Kind kind = GapicRetrySettings.Kind.FULL;
        Optional<Integer> retryPolicyIndexOpt = this.retryPolicyIndexLookup(service, method);
        kind = !retryPolicyIndexOpt.isPresent() ? GapicRetrySettings.Kind.NONE : (!(methodConfig = this.methodConfigs.get(retryPolicyIndexOpt.get())).hasTimeout() && !methodConfig.hasRetryPolicy() ? GapicRetrySettings.Kind.NONE : (methodConfig.hasRetryPolicy() ? GapicRetrySettings.Kind.FULL : GapicRetrySettings.Kind.NO_RETRY));
        return GapicRetrySettings.builder().setTimeout(this.timeoutLookup(service, method)).setRetryPolicy(this.retryPolicyLookup(service, method)).setKind(kind).build();
    }

    private List<Code> retryCodesLookup(Service service, Method method) {
        MethodConfig.RetryPolicy retryPolicy = this.retryPolicyLookup(service, method);
        if (retryPolicy.equals(EMPTY_RETRY_POLICY)) {
            return Collections.emptyList();
        }
        return retryPolicy.getRetryableStatusCodesList();
    }

    private MethodConfig.RetryPolicy retryPolicyLookup(Service service, Method method) {
        Optional<Integer> retryPolicyIndexOpt = this.retryPolicyIndexLookup(service, method);
        if (retryPolicyIndexOpt.isPresent()) {
            MethodConfig methodConfig = this.methodConfigs.get(retryPolicyIndexOpt.get());
            return methodConfig.hasRetryPolicy() ? methodConfig.getRetryPolicy() : EMPTY_RETRY_POLICY;
        }
        return EMPTY_RETRY_POLICY;
    }

    private Duration timeoutLookup(Service service, Method method) {
        Optional<Integer> retryPolicyIndexOpt = this.retryPolicyIndexLookup(service, method);
        if (retryPolicyIndexOpt.isPresent()) {
            MethodConfig methodConfig = this.methodConfigs.get(retryPolicyIndexOpt.get());
            return methodConfig.hasTimeout() ? methodConfig.getTimeout() : EMPTY_TIMEOUT;
        }
        return EMPTY_TIMEOUT;
    }

    private Optional<Integer> retryPolicyIndexLookup(Service service, Method method) {
        MethodConfig.Name serviceMethodName = this.toName(service, method);
        if (this.methodConfigTable.containsKey(serviceMethodName)) {
            return Optional.of(this.methodConfigTable.get(serviceMethodName));
        }
        MethodConfig.Name serviceName = this.toName(service);
        if (this.methodConfigTable.containsKey(serviceName)) {
            return Optional.of(this.methodConfigTable.get(serviceName));
        }
        return Optional.empty();
    }

    private String getRetryCodeName(int methodConfigIndex) {
        MethodConfig methodConfig = this.methodConfigs.get(methodConfigIndex);
        if (!methodConfig.hasTimeout() && !methodConfig.hasRetryPolicy()) {
            return NO_RETRY_CODES_NAME;
        }
        return String.format(methodConfig.hasRetryPolicy() ? RETRY_CODES_PATTERN : NO_RETRY_CODES_PATTERN, methodConfigIndex);
    }

    private String getRetryParamsName(int methodConfigIndex) {
        MethodConfig methodConfig = this.methodConfigs.get(methodConfigIndex);
        if (!methodConfig.hasTimeout() && !methodConfig.hasRetryPolicy()) {
            return NO_RETRY_PARAMS_NAME;
        }
        return String.format(methodConfig.hasRetryPolicy() ? RETRY_PARAMS_PATTERN : NO_RETRY_PARAMS_PATTERN, methodConfigIndex);
    }

    private MethodConfig.Name toName(Service service) {
        return MethodConfig.Name.newBuilder().setService(this.serviceToNameString(service)).build();
    }

    private MethodConfig.Name toName(Service service, Method method) {
        return MethodConfig.Name.newBuilder().setService(this.serviceToNameString(service)).setMethod(method.name()).build();
    }

    private String serviceToNameString(Service service) {
        return String.format("%s.%s", service.protoPakkage(), service.name());
    }
}

