/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_NewObjectExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class NewObjectExpr
implements Expr {
    @Override
    public abstract TypeNode type();

    public abstract ImmutableList<Expr> arguments();

    public abstract boolean isGeneric();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static NewObjectExpr withType(TypeNode type) {
        return NewObjectExpr.builder().setType(type).build();
    }

    public static Builder builder() {
        return new AutoValue_NewObjectExpr.Builder().setArguments(Collections.emptyList()).setIsGeneric(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setType(TypeNode var1);

        public Builder setArguments(Expr ... arguments) {
            return this.setArguments(Arrays.asList(arguments));
        }

        public abstract Builder setArguments(List<Expr> var1);

        public abstract Builder setIsGeneric(boolean var1);

        abstract TypeNode type();

        abstract boolean isGeneric();

        abstract ImmutableList<Expr> arguments();

        abstract NewObjectExpr autoBuild();

        public NewObjectExpr build() {
            Preconditions.checkState(TypeNode.isReferenceType(this.type()), "New object expression should be reference types.");
            NodeValidator.checkNoNullElements(this.arguments(), "the \"new\" constructor", this.type().reference().name());
            this.setIsGeneric(this.isGeneric() || !this.type().reference().generics().isEmpty());
            return this.autoBuild();
        }
    }
}

