/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.grpc;

import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.EnumRefExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.StringObjectValue;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.gapic.composer.common.AbstractTransportServiceStubClassComposer;
import com.google.api.generator.gapic.composer.grpc.GrpcContext;
import com.google.api.generator.gapic.composer.store.TypeStore;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.Service;
import com.google.longrunning.stub.GrpcOperationsStub;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class GrpcServiceStubClassComposer
extends AbstractTransportServiceStubClassComposer {
    private static final GrpcServiceStubClassComposer INSTANCE = new GrpcServiceStubClassComposer();
    private static final Set<String> REROUTE_TO_GRPC_INTERFACE_SERVICE_ALLOWLIST = new HashSet<String>(Arrays.asList("google.pubsub.v1"));
    private static final Set<String> REROUTE_TO_GRPC_INTERFACE_IAM_METHOD_ALLOWLIST = new HashSet<String>(Arrays.asList("SetIamPolicy", "GetIamPolicy", "TestIamPermissions"));
    private static final TypeStore FIXED_GRPC_TYPE_STORE = GrpcServiceStubClassComposer.createStaticTypes();

    protected GrpcServiceStubClassComposer() {
        super(GrpcContext.instance());
    }

    public static GrpcServiceStubClassComposer instance() {
        return INSTANCE;
    }

    private static TypeStore createStaticTypes() {
        List<Class<?>> concreteClazzes = Arrays.asList(GrpcCallSettings.class, GrpcOperationsStub.class, GrpcStubCallableFactory.class, MethodDescriptor.class, ProtoUtils.class);
        return new TypeStore(concreteClazzes);
    }

    @Override
    protected Statement createMethodDescriptorVariableDecl(Service service, Method protoMethod, VariableExpr methodDescriptorVarExpr, Map<String, Message> messageTypes, boolean restNumericEnumsEnabled) {
        MethodInvocationExpr methodDescriptorMaker = MethodInvocationExpr.builder().setMethodName("newBuilder").setStaticReferenceType(FIXED_GRPC_TYPE_STORE.get("MethodDescriptor")).setGenerics(methodDescriptorVarExpr.variable().type().reference().generics()).build();
        BiFunction<String, Expr, Function> methodMakerFn = (mName, argExpr) -> m4 -> MethodInvocationExpr.builder().setMethodName((String)mName).setArguments(Arrays.asList(argExpr)).setExprReferenceExpr((Expr)m4).build();
        methodDescriptorMaker = (MethodInvocationExpr)methodMakerFn.apply("setType", this.getMethodDescriptorMethodTypeExpr(protoMethod)).apply(methodDescriptorMaker);
        String codeMethodNameArg = this.getProtoRpcFullMethodName(service, protoMethod);
        methodDescriptorMaker = (MethodInvocationExpr)methodMakerFn.apply("setFullMethodName", ValueExpr.withValue(StringObjectValue.withValue(codeMethodNameArg))).apply(methodDescriptorMaker);
        Function<MethodInvocationExpr, MethodInvocationExpr> protoUtilsMarshallerFn = m4 -> MethodInvocationExpr.builder().setStaticReferenceType(FIXED_GRPC_TYPE_STORE.get("ProtoUtils")).setMethodName("marshaller").setArguments(Arrays.asList(m4)).build();
        MethodInvocationExpr methodInvocationArg = MethodInvocationExpr.builder().setMethodName("getDefaultInstance").setStaticReferenceType(protoMethod.inputType()).build();
        methodDescriptorMaker = (MethodInvocationExpr)methodMakerFn.apply("setRequestMarshaller", protoUtilsMarshallerFn.apply(methodInvocationArg)).apply(methodDescriptorMaker);
        methodInvocationArg = MethodInvocationExpr.builder().setMethodName("getDefaultInstance").setStaticReferenceType(protoMethod.outputType()).build();
        methodDescriptorMaker = (MethodInvocationExpr)methodMakerFn.apply("setResponseMarshaller", protoUtilsMarshallerFn.apply(methodInvocationArg)).apply(methodDescriptorMaker);
        methodDescriptorMaker = MethodInvocationExpr.builder().setMethodName("build").setExprReferenceExpr(methodDescriptorMaker).setReturnType(methodDescriptorVarExpr.type()).build();
        return ExprStatement.withExpr(AssignmentExpr.builder().setVariableExpr(methodDescriptorVarExpr.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsStatic(true).setIsFinal(true).build()).setValueExpr(methodDescriptorMaker).build());
    }

    protected EnumRefExpr getMethodDescriptorMethodTypeExpr(Method protoMethod) {
        String enumName = "";
        switch (protoMethod.stream()) {
            case CLIENT: {
                enumName = "CLIENT_STREAMING";
                break;
            }
            case SERVER: {
                enumName = "SERVER_STREAMING";
                break;
            }
            case BIDI: {
                enumName = "BIDI_STREAMING";
                break;
            }
            default: {
                enumName = "UNARY";
            }
        }
        return EnumRefExpr.builder().setName(enumName).setType(TypeNode.withReference(ConcreteReference.builder().setClazz(MethodDescriptor.MethodType.class).build())).build();
    }

    @Override
    protected String getProtoRpcFullMethodName(Service protoService, Method protoMethod) {
        if (protoMethod.isMixin()) {
            return String.format("%s/%s", protoMethod.mixedInApiName(), protoMethod.name());
        }
        if (!REROUTE_TO_GRPC_INTERFACE_SERVICE_ALLOWLIST.contains(protoService.protoPakkage()) || !REROUTE_TO_GRPC_INTERFACE_IAM_METHOD_ALLOWLIST.contains(protoMethod.name())) {
            return String.format("%s.%s/%s", protoService.protoPakkage(), protoService.name(), protoMethod.name());
        }
        return String.format("google.iam.v1.IAMPolicy/%s", protoMethod.name());
    }
}

