/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.NanoClock;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.FixedWatchdogProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.InstantiatingWatchdogProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.BaseApiTracerFactory;
import com.google.auth.oauth2.QuotaProjectIdProvider;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public abstract class StubSettings<SettingsT extends StubSettings<SettingsT>> {
    static final String QUOTA_PROJECT_ID_HEADER_KEY = "x-goog-user-project";
    private final ExecutorProvider backgroundExecutorProvider;
    private final CredentialsProvider credentialsProvider;
    private final HeaderProvider headerProvider;
    private final HeaderProvider internalHeaderProvider;
    private final TransportChannelProvider transportChannelProvider;
    private final ApiClock clock;
    private final String serviceName;
    private final String endpoint;
    private final String mtlsEndpoint;
    private final String quotaProjectId;
    @Nullable
    private final String gdchApiAudience;
    @Nullable
    private final WatchdogProvider streamWatchdogProvider;
    @Nonnull
    private final Duration streamWatchdogCheckInterval;
    @Nonnull
    private final ApiTracerFactory tracerFactory;
    private boolean deprecatedExecutorProviderSet;
    private final String universeDomain;
    private final boolean switchToMtlsEndpointAllowed;

    protected StubSettings(Builder builder) {
        this.backgroundExecutorProvider = builder.backgroundExecutorProvider;
        this.transportChannelProvider = builder.transportChannelProvider;
        this.credentialsProvider = builder.credentialsProvider;
        this.headerProvider = builder.headerProvider;
        this.internalHeaderProvider = builder.internalHeaderProvider;
        this.clock = builder.clock;
        this.serviceName = builder.serviceName;
        this.endpoint = builder.endpoint;
        this.mtlsEndpoint = builder.mtlsEndpoint;
        this.switchToMtlsEndpointAllowed = builder.switchToMtlsEndpointAllowed;
        this.quotaProjectId = builder.quotaProjectId;
        this.streamWatchdogProvider = builder.streamWatchdogProvider;
        this.streamWatchdogCheckInterval = builder.streamWatchdogCheckInterval;
        this.tracerFactory = builder.tracerFactory;
        this.deprecatedExecutorProviderSet = builder.deprecatedExecutorProviderSet;
        this.gdchApiAudience = builder.gdchApiAudience;
        this.universeDomain = builder.universeDomain;
    }

    @Deprecated
    public final ExecutorProvider getExecutorProvider() {
        return this.deprecatedExecutorProviderSet ? this.backgroundExecutorProvider : null;
    }

    public final ExecutorProvider getBackgroundExecutorProvider() {
        return this.backgroundExecutorProvider;
    }

    public final TransportChannelProvider getTransportChannelProvider() {
        return this.transportChannelProvider;
    }

    public final CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public final HeaderProvider getHeaderProvider() {
        return this.headerProvider;
    }

    protected final HeaderProvider getInternalHeaderProvider() {
        return this.internalHeaderProvider;
    }

    public final ApiClock getClock() {
        return this.clock;
    }

    @InternalApi
    public String getServiceName() {
        return "";
    }

    public final String getUniverseDomain() {
        return this.universeDomain;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public final String getMtlsEndpoint() {
        return this.mtlsEndpoint;
    }

    final boolean getSwitchToMtlsEndpointAllowed() {
        return this.switchToMtlsEndpointAllowed;
    }

    public final String getQuotaProjectId() {
        return this.quotaProjectId;
    }

    @Nullable
    public final WatchdogProvider getStreamWatchdogProvider() {
        return this.streamWatchdogProvider;
    }

    @Nonnull
    public final Duration getStreamWatchdogCheckInterval() {
        return this.streamWatchdogCheckInterval;
    }

    @BetaApi(value="The surface for tracing is not stable yet and may change in the future.")
    @Nonnull
    public ApiTracerFactory getTracerFactory() {
        return this.tracerFactory;
    }

    @Nullable
    public final String getGdchApiAudience() {
        return this.gdchApiAudience;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("backgroundExecutorProvider", this.backgroundExecutorProvider).add("transportChannelProvider", this.transportChannelProvider).add("credentialsProvider", this.credentialsProvider).add("headerProvider", this.headerProvider).add("internalHeaderProvider", this.internalHeaderProvider).add("clock", this.clock).add("universeDomain", this.universeDomain).add("endpoint", this.endpoint).add("mtlsEndpoint", this.mtlsEndpoint).add("switchToMtlsEndpointAllowed", this.switchToMtlsEndpointAllowed).add("quotaProjectId", this.quotaProjectId).add("streamWatchdogProvider", this.streamWatchdogProvider).add("streamWatchdogCheckInterval", this.streamWatchdogCheckInterval).add("tracerFactory", this.tracerFactory).add("gdchApiAudience", this.gdchApiAudience).toString();
    }

    public abstract Builder toBuilder();

    public static abstract class Builder<SettingsT extends StubSettings<SettingsT>, B extends Builder<SettingsT, B>> {
        private ExecutorProvider backgroundExecutorProvider;
        private CredentialsProvider credentialsProvider;
        private HeaderProvider headerProvider;
        private HeaderProvider internalHeaderProvider;
        private TransportChannelProvider transportChannelProvider;
        private ApiClock clock;
        private String serviceName;
        private String endpoint;
        private String mtlsEndpoint;
        private String quotaProjectId;
        @Nullable
        private String gdchApiAudience;
        @Nullable
        private WatchdogProvider streamWatchdogProvider;
        @Nonnull
        private Duration streamWatchdogCheckInterval;
        @Nonnull
        private ApiTracerFactory tracerFactory;
        private boolean deprecatedExecutorProviderSet;
        private String universeDomain;
        private boolean switchToMtlsEndpointAllowed = false;

        protected Builder(StubSettings settings) {
            this.backgroundExecutorProvider = settings.backgroundExecutorProvider;
            this.transportChannelProvider = settings.transportChannelProvider;
            this.credentialsProvider = settings.credentialsProvider;
            this.headerProvider = settings.headerProvider;
            this.internalHeaderProvider = settings.internalHeaderProvider;
            this.clock = settings.clock;
            this.serviceName = settings.serviceName;
            this.endpoint = settings.endpoint;
            this.mtlsEndpoint = settings.mtlsEndpoint;
            this.switchToMtlsEndpointAllowed = settings.switchToMtlsEndpointAllowed;
            this.quotaProjectId = settings.quotaProjectId;
            this.streamWatchdogProvider = settings.streamWatchdogProvider;
            this.streamWatchdogCheckInterval = settings.streamWatchdogCheckInterval;
            this.tracerFactory = settings.tracerFactory;
            this.deprecatedExecutorProviderSet = settings.deprecatedExecutorProviderSet;
            this.gdchApiAudience = settings.gdchApiAudience;
            this.universeDomain = settings.universeDomain;
        }

        private static String getQuotaProjectIdFromClientContext(ClientContext clientContext) {
            if (clientContext.getQuotaProjectId() != null) {
                return clientContext.getQuotaProjectId();
            }
            if (clientContext.getCredentials() instanceof QuotaProjectIdProvider) {
                return ((QuotaProjectIdProvider)((Object)clientContext.getCredentials())).getQuotaProjectId();
            }
            if (clientContext.getHeaders().containsKey(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY)) {
                return clientContext.getHeaders().get(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY);
            }
            if (clientContext.getInternalHeaders().containsKey(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY)) {
                return clientContext.getInternalHeaders().get(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY);
            }
            return null;
        }

        protected Builder(ClientContext clientContext) {
            if (clientContext == null) {
                this.backgroundExecutorProvider = InstantiatingExecutorProvider.newBuilder().build();
                this.transportChannelProvider = null;
                this.credentialsProvider = NoCredentialsProvider.create();
                this.headerProvider = new NoHeaderProvider();
                this.internalHeaderProvider = new NoHeaderProvider();
                this.clock = NanoClock.getDefaultClock();
                this.serviceName = null;
                this.endpoint = null;
                this.mtlsEndpoint = null;
                this.quotaProjectId = null;
                this.streamWatchdogProvider = InstantiatingWatchdogProvider.create();
                this.streamWatchdogCheckInterval = Duration.ofSeconds(10L);
                this.tracerFactory = BaseApiTracerFactory.getInstance();
                this.deprecatedExecutorProviderSet = false;
                this.gdchApiAudience = null;
                this.universeDomain = null;
            } else {
                FixedExecutorProvider fixedExecutorProvider = FixedExecutorProvider.create(clientContext.getExecutor());
                this.deprecatedExecutorProviderSet = true;
                this.backgroundExecutorProvider = fixedExecutorProvider;
                this.transportChannelProvider = FixedTransportChannelProvider.create(clientContext.getTransportChannel());
                this.credentialsProvider = FixedCredentialsProvider.create(clientContext.getCredentials());
                this.headerProvider = FixedHeaderProvider.create(clientContext.getHeaders());
                this.internalHeaderProvider = FixedHeaderProvider.create(clientContext.getInternalHeaders());
                this.clock = clientContext.getClock();
                this.serviceName = clientContext.getServiceName();
                this.endpoint = clientContext.getEndpoint();
                if (this.endpoint != null) {
                    this.mtlsEndpoint = this.endpoint.replace("googleapis.com", "mtls.googleapis.com");
                }
                this.streamWatchdogProvider = FixedWatchdogProvider.create(clientContext.getStreamWatchdog());
                this.streamWatchdogCheckInterval = clientContext.getStreamWatchdogCheckInterval();
                this.tracerFactory = clientContext.getTracerFactory();
                this.quotaProjectId = Builder.getQuotaProjectIdFromClientContext(clientContext);
                this.gdchApiAudience = clientContext.getGdchApiAudience();
                this.universeDomain = clientContext.getUniverseDomain();
            }
        }

        protected Builder() {
            this((ClientContext)null);
        }

        protected B self() {
            return (B)this;
        }

        @Deprecated
        public B setExecutorProvider(ExecutorProvider executorProvider) {
            this.deprecatedExecutorProviderSet = true;
            this.backgroundExecutorProvider = executorProvider;
            return this.self();
        }

        public B setBackgroundExecutorProvider(ExecutorProvider backgroundExecutorProvider) {
            this.backgroundExecutorProvider = backgroundExecutorProvider;
            return this.self();
        }

        public B setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = Preconditions.checkNotNull(credentialsProvider);
            return this.self();
        }

        public B setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            if (this.quotaProjectId == null && headerProvider.getHeaders().containsKey(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY)) {
                this.quotaProjectId = headerProvider.getHeaders().get(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY);
            }
            return this.self();
        }

        protected B setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            this.internalHeaderProvider = internalHeaderProvider;
            if (this.quotaProjectId == null && internalHeaderProvider.getHeaders().containsKey(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY)) {
                this.quotaProjectId = internalHeaderProvider.getHeaders().get(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY);
            }
            return this.self();
        }

        public B setTransportChannelProvider(TransportChannelProvider transportChannelProvider) {
            this.transportChannelProvider = transportChannelProvider;
            return this.self();
        }

        public B setStreamWatchdogProvider(@Nullable WatchdogProvider streamWatchdogProvider) {
            this.streamWatchdogProvider = streamWatchdogProvider;
            return this.self();
        }

        public B setClock(ApiClock clock) {
            this.clock = clock;
            return this.self();
        }

        public B setUniverseDomain(String universeDomain) {
            this.universeDomain = universeDomain;
            return this.self();
        }

        public B setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            this.switchToMtlsEndpointAllowed = false;
            if (this.endpoint != null && this.mtlsEndpoint == null) {
                this.mtlsEndpoint = this.endpoint.replace("googleapis.com", "mtls.googleapis.com");
            }
            return this.self();
        }

        protected B setSwitchToMtlsEndpointAllowed(boolean switchToMtlsEndpointAllowed) {
            this.switchToMtlsEndpointAllowed = switchToMtlsEndpointAllowed;
            return this.self();
        }

        public B setMtlsEndpoint(String mtlsEndpoint) {
            this.mtlsEndpoint = mtlsEndpoint;
            return this.self();
        }

        public B setQuotaProjectId(String quotaProjectId) {
            this.quotaProjectId = quotaProjectId;
            return this.self();
        }

        public B setStreamWatchdogCheckInterval(@Nonnull Duration checkInterval) {
            Preconditions.checkNotNull(checkInterval);
            this.streamWatchdogCheckInterval = checkInterval;
            return this.self();
        }

        public B setGdchApiAudience(String gdchApiAudience) {
            this.gdchApiAudience = gdchApiAudience;
            return this.self();
        }

        @BetaApi(value="The surface for tracing is not stable yet and may change in the future.")
        public B setTracerFactory(@Nonnull ApiTracerFactory tracerFactory) {
            Preconditions.checkNotNull(tracerFactory);
            this.tracerFactory = tracerFactory;
            return this.self();
        }

        @Deprecated
        public ExecutorProvider getExecutorProvider() {
            return this.deprecatedExecutorProviderSet ? this.backgroundExecutorProvider : null;
        }

        public ExecutorProvider getBackgroundExecutorProvider() {
            return this.backgroundExecutorProvider;
        }

        public TransportChannelProvider getTransportChannelProvider() {
            return this.transportChannelProvider;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        public HeaderProvider getHeaderProvider() {
            return this.headerProvider;
        }

        protected HeaderProvider getInternalHeaderProvider() {
            return this.internalHeaderProvider;
        }

        @Nullable
        public WatchdogProvider getStreamWatchdogProvider() {
            return this.streamWatchdogProvider;
        }

        public ApiClock getClock() {
            return this.clock;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getMtlsEndpoint() {
            return this.mtlsEndpoint;
        }

        public String getQuotaProjectId() {
            return this.quotaProjectId;
        }

        @Nonnull
        public Duration getStreamWatchdogCheckInterval() {
            return this.streamWatchdogCheckInterval;
        }

        @BetaApi(value="The surface for tracing is not stable yet and may change in the future.")
        @Nonnull
        public ApiTracerFactory getTracerFactory() {
            return this.tracerFactory;
        }

        public String getGdchApiAudience() {
            return this.gdchApiAudience;
        }

        protected static void applyToAllUnaryMethods(Iterable<UnaryCallSettings.Builder<?, ?>> methodSettingsBuilders, ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            for (UnaryCallSettings.Builder<?, ?> settingsBuilder : methodSettingsBuilders) {
                settingsUpdater.apply(settingsBuilder);
            }
        }

        public abstract <B extends StubSettings<B>> StubSettings<B> build() throws IOException;

        public String toString() {
            return MoreObjects.toStringHelper(this).add("backgroundExecutorProvider", this.backgroundExecutorProvider).add("transportChannelProvider", this.transportChannelProvider).add("credentialsProvider", this.credentialsProvider).add("headerProvider", this.headerProvider).add("internalHeaderProvider", this.internalHeaderProvider).add("clock", this.clock).add("universeDomain", this.universeDomain).add("endpoint", this.endpoint).add("mtlsEndpoint", this.mtlsEndpoint).add("switchToMtlsEndpointAllowed", this.switchToMtlsEndpointAllowed).add("quotaProjectId", this.quotaProjectId).add("streamWatchdogProvider", this.streamWatchdogProvider).add("streamWatchdogCheckInterval", this.streamWatchdogCheckInterval).add("tracerFactory", this.tracerFactory).add("gdchApiAudience", this.gdchApiAudience).toString();
        }
    }
}

