/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protowriter;

import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.engine.ast.PackageInfoDefinition;
import com.google.api.generator.engine.writer.JavaWriterVisitor;
import com.google.api.generator.gapic.composer.samplecode.SampleCodeWriter;
import com.google.api.generator.gapic.model.GapicClass;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.GapicPackageInfo;
import com.google.api.generator.gapic.model.ReflectConfig;
import com.google.api.generator.gapic.model.Sample;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.compiler.PluginProtos;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class Writer {
    public static PluginProtos.CodeGeneratorResponse write(GapicContext context, List<GapicClass> clazzes, GapicPackageInfo gapicPackageInfo, List<ReflectConfig> reflectConfigInfo, String outputFilePath) {
        JarOutputStream jos;
        ByteString.Output output = ByteString.newOutput();
        JavaWriterVisitor codeWriter = new JavaWriterVisitor();
        try {
            jos = new JarOutputStream(output);
        }
        catch (IOException e) {
            throw new GapicWriterException(e.getMessage(), e);
        }
        for (GapicClass gapicClazz : clazzes) {
            if (gapicClazz.kind() == GapicClass.Kind.NON_GENERATED) continue;
            String classPath = Writer.writeClazz(gapicClazz, codeWriter, jos);
            Writer.writeSamples(gapicClazz, Writer.getSamplePackage(gapicClazz), classPath, jos);
        }
        Writer.writeMetadataFile(context, Writer.writePackageInfo(gapicPackageInfo, codeWriter, jos), jos);
        Writer.writeReflectConfigFile(gapicPackageInfo.packageInfo().pakkage(), reflectConfigInfo, jos);
        try {
            jos.finish();
            jos.flush();
        }
        catch (IOException e) {
            throw new GapicWriterException(e.getMessage(), e);
        }
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.setSupportedFeatures(1L).addFileBuilder().setName(outputFilePath).setContentBytes(output.toByteString());
        return response.build();
    }

    @VisibleForTesting
    static void writeReflectConfigFile(String pakkage, List<ReflectConfig> reflectConfigInfo, JarOutputStream jos) {
        if (reflectConfigInfo.isEmpty()) {
            return;
        }
        Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
        String jarEntryLocation = String.format("src/main/resources/META-INF/native-image/%s/reflect-config.json", pakkage);
        try {
            jos.putNextEntry(new JarEntry(jarEntryLocation));
            jos.write(prettyGson.toJson(reflectConfigInfo).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new GapicWriterException("Could not write reflect-config.json", e);
        }
    }

    private static String writeClazz(GapicClass gapicClazz, JavaWriterVisitor codeWriter, JarOutputStream jos) {
        ClassDefinition clazz = gapicClazz.classDefinition();
        clazz.accept(codeWriter);
        String code = codeWriter.write();
        codeWriter.clear();
        String path = Writer.getPath(clazz.packageString(), clazz.classIdentifier().name());
        String className = clazz.classIdentifier().name();
        JarEntry jarEntry = new JarEntry(String.format("%s/%s.java", path, className));
        try {
            jos.putNextEntry(jarEntry);
            jos.write(code.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new GapicWriterException(String.format("Could not write code for class %s.%s: %s", clazz.packageString(), clazz.classIdentifier().name(), e.getMessage()), e);
        }
        return path;
    }

    private static void writeSamples(GapicClass gapicClazz, String pakkage, String clazzPath, JarOutputStream jos) {
        for (Sample sample : gapicClazz.samples()) {
            JarEntry jarEntry = new JarEntry(String.format("samples/snippets/generated/%s/%s/%s/%s.java", clazzPath, sample.regionTag().serviceName().toLowerCase(), sample.regionTag().rpcName().toLowerCase(), sample.name()));
            String executableSampleCode = SampleCodeWriter.writeExecutableSample(sample, pakkage);
            try {
                jos.putNextEntry(jarEntry);
                jos.write(executableSampleCode.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new GapicWriterException(String.format("Could not write sample code for %s/%s.: %s", clazzPath, sample.name(), e.getMessage()), e);
            }
        }
    }

    private static String writePackageInfo(GapicPackageInfo gapicPackageInfo, JavaWriterVisitor codeWriter, JarOutputStream jos) {
        PackageInfoDefinition packageInfo = gapicPackageInfo.packageInfo();
        packageInfo.accept(codeWriter);
        String code = codeWriter.write();
        codeWriter.clear();
        String packagePath = "src/main/java/" + packageInfo.pakkage().replaceAll("\\.", "/");
        JarEntry jarEntry = new JarEntry(String.format("%s/package-info.java", packagePath));
        try {
            jos.putNextEntry(jarEntry);
            jos.write(code.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new GapicWriterException("Could not write code for package-info.java", e);
        }
        return packagePath;
    }

    private static void writeMetadataFile(GapicContext context, String path, JarOutputStream jos) {
        if (context.gapicMetadataEnabled()) {
            JarEntry jarEntry = new JarEntry(String.format("%s/gapic_metadata.json", path));
            try {
                jos.putNextEntry(jarEntry);
                jos.write(JsonFormat.printer().print(context.gapicMetadata()).getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new GapicWriterException("Could not write gapic_metadata.json", e);
            }
        }
    }

    private static String getPath(String pakkage, String className) {
        String path = pakkage.replaceAll("\\.", "/");
        path = className.startsWith("Mock") || className.endsWith("Test") ? "src/test/java/" + path : "src/main/java/" + path;
        if (className.endsWith("Name")) {
            path = "proto/" + path;
        }
        return path;
    }

    private static String getSamplePackage(GapicClass gapicClazz) {
        return gapicClazz.classDefinition().packageString().concat(".samples");
    }

    static class GapicWriterException
    extends RuntimeException {
        public GapicWriterException(String errorMessage) {
            super(errorMessage);
        }

        public GapicWriterException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }
    }
}

