/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.ResourceReference;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.api.generator.gapic.utils.ResourceReferenceUtils;
import com.google.api.pathtemplate.PathTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class ResourceReferenceParser {
    private static final String EMPTY_STRING = "";
    private static final String LEFT_BRACE = "{";
    private static final String RIGHT_BRACE = "}";
    private static final String SLASH = "/";

    public static List<ResourceName> parseResourceNames(ResourceReference resourceReference, String servicePackage, @Nullable String description, Map<String, ResourceName> resourceNames, Map<String, ResourceName> patternsToResourceNames) {
        ResourceName resourceName = null;
        if (resourceReference.isOnlyWildcard()) {
            resourceName = ResourceName.createWildcard("*", "com.google.api.wildcard.placeholder");
            resourceNames.put(resourceName.resourceTypeString(), resourceName);
        } else {
            resourceName = resourceNames.get(resourceReference.resourceTypeString());
        }
        if (resourceReference.resourceTypeString().indexOf(SLASH) < 0) {
            Optional<String> actualResourceTypeNameOpt = resourceNames.keySet().stream().filter(k -> k.substring(k.lastIndexOf(SLASH) + 1).equals(resourceReference.resourceTypeString())).findFirst();
            if (actualResourceTypeNameOpt.isPresent()) {
                resourceName = resourceNames.get(actualResourceTypeNameOpt.get());
            }
        } else {
            resourceName = resourceNames.get(resourceReference.resourceTypeString());
        }
        Preconditions.checkNotNull(resourceName, String.format("No resource definition found for reference with type %s", resourceReference.resourceTypeString()));
        if (!resourceReference.isChildType() || resourceName.isOnlyWildcard()) {
            return Arrays.asList(resourceName);
        }
        ArrayList<ResourceName> parentResourceNames = new ArrayList<ResourceName>();
        HashSet<String> resourceTypeStrings = new HashSet<String>();
        for (String pattern : resourceName.patterns()) {
            Optional<ResourceName> parentResourceNameOpt = ResourceReferenceParser.parseParentResourceName(pattern, servicePackage, resourceName.pakkage(), resourceName.resourceTypeString(), description, patternsToResourceNames);
            if (!parentResourceNameOpt.isPresent() || resourceTypeStrings.contains(parentResourceNameOpt.get().resourceTypeString())) continue;
            ResourceName parentResourceName = parentResourceNameOpt.get();
            parentResourceNames.add(parentResourceName);
            resourceTypeStrings.add(parentResourceName.resourceTypeString());
        }
        return parentResourceNames;
    }

    @VisibleForTesting
    static Optional<ResourceName> parseParentResourceName(String pattern, String servicePackage, String resourcePackage, String resourceTypeString, @Nullable String description, Map<String, ResourceName> patternsToResourceNames) {
        Optional<String> parentPatternOpt = ResourceReferenceUtils.parseParentPattern(pattern);
        if (!parentPatternOpt.isPresent()) {
            return Optional.empty();
        }
        String parentPattern = parentPatternOpt.get();
        if (patternsToResourceNames.get(parentPattern) != null) {
            return Optional.of(patternsToResourceNames.get(parentPattern));
        }
        String[] tokens = parentPattern.split(SLASH);
        int numTokens = tokens.length;
        String lastToken = tokens[numTokens - 1];
        Set<String> variableNames = PathTemplate.create(parentPattern).vars();
        String parentVariableName = null;
        for (String variableName : variableNames) {
            if (!lastToken.contains(variableName)) continue;
            parentVariableName = variableName;
        }
        if (Strings.isNullOrEmpty(parentVariableName)) {
            String lowerTypeName = resourceTypeString.substring(resourceTypeString.indexOf(SLASH) + 1).toLowerCase();
            parentVariableName = (lastToken.endsWith("s") || lastToken.contains(lowerTypeName)) && numTokens > 2 ? tokens[numTokens - 2] : lastToken;
            parentVariableName = parentVariableName.replace(LEFT_BRACE, EMPTY_STRING).replace(RIGHT_BRACE, EMPTY_STRING);
        }
        Preconditions.checkNotNull(parentVariableName, String.format("Could not parse variable name from pattern %s", parentPattern));
        String pakkage = ResourceReferenceParser.resolvePackages(resourcePackage, servicePackage);
        String parentResourceTypeString = String.format("%s/%s", resourceTypeString.substring(0, resourceTypeString.indexOf(SLASH)), JavaStyle.toUpperCamelCase(parentVariableName));
        ResourceName parentResourceName = ResourceName.builder().setVariableName(parentVariableName).setPakkage(pakkage).setResourceTypeString(parentResourceTypeString).setPatterns(Arrays.asList(parentPattern)).setDescription(description).build();
        patternsToResourceNames.put(parentPattern, parentResourceName);
        return Optional.of(parentResourceName);
    }

    @VisibleForTesting
    static String resolvePackages(String resourceNamePackage, String servicePackage) {
        return resourceNamePackage.contains(servicePackage) ? resourceNamePackage : servicePackage;
    }
}

