/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.samplecode;

import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.ForStatement;
import com.google.api.generator.engine.ast.LineComment;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.TryCatchStatement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.Variable;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.gapic.composer.defaultvalue.DefaultValueComposer;
import com.google.api.generator.gapic.composer.samplecode.SampleComposerUtil;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.RegionTag;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.Sample;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ServiceClientMethodSampleComposer {
    public static Sample composeEmptyServiceSample(TypeNode clientType, Service service) {
        VariableExpr clientVarExpr = VariableExpr.withVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(clientType.reference().name())).setType(clientType).build());
        ArrayList<Statement> bodyStatements = new ArrayList<Statement>();
        RegionTag regionTag = RegionTag.builder().setServiceName(service.name()).setRpcName("emtpy").build();
        List<Statement> body = Arrays.asList(TryCatchStatement.builder().setTryResourceExpr(SampleComposerUtil.assignClientVariableWithCreateMethodExpr(clientVarExpr)).setTryBody(bodyStatements).setIsSampleCode(true).build());
        return Sample.builder().setBody(body).setRegionTag(regionTag).setIsCanonical(true).build();
    }

    public static Sample composeCanonicalSample(Method method, TypeNode clientType, Map<String, ResourceName> resourceNames, Map<String, Message> messageTypes, Service service) {
        RegionTag regionTag;
        VariableExpr clientVarExpr = VariableExpr.withVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(clientType.reference().name())).setType(clientType).build());
        VariableExpr requestVarExpr = VariableExpr.withVariable(Variable.builder().setName("request").setType(method.inputType()).build());
        List<VariableExpr> rpcMethodArgVarExprs = Arrays.asList(requestVarExpr);
        Message requestMessage = messageTypes.get(method.inputType().reference().fullName());
        Preconditions.checkNotNull(requestMessage, String.format("Could not find the message type %s.", method.inputType().reference().fullName()));
        Expr requestBuilderExpr = DefaultValueComposer.createSimpleMessageBuilderValue(requestMessage, resourceNames, messageTypes, method.httpBindings());
        AssignmentExpr requestAssignmentExpr = AssignmentExpr.builder().setVariableExpr(requestVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(requestBuilderExpr).build();
        ArrayList<Expr> bodyExprs = new ArrayList<Expr>();
        bodyExprs.add(requestAssignmentExpr);
        ArrayList<Statement> bodyStatements = new ArrayList<Statement>();
        if (method.isPaged()) {
            Sample unaryPagedRpc = ServiceClientMethodSampleComposer.composePagedSample(method, clientVarExpr, rpcMethodArgVarExprs, bodyExprs, messageTypes, service);
            bodyStatements.addAll(unaryPagedRpc.body());
            regionTag = unaryPagedRpc.regionTag();
        } else if (method.hasLro()) {
            Sample unaryLroRpc = ServiceClientMethodSampleComposer.composeLroSample(method, clientVarExpr, rpcMethodArgVarExprs, bodyExprs, service);
            bodyStatements.addAll(unaryLroRpc.body());
            regionTag = unaryLroRpc.regionTag();
        } else {
            Sample unaryRpc = ServiceClientMethodSampleComposer.composeSample(method, clientVarExpr, rpcMethodArgVarExprs, bodyExprs, service);
            bodyStatements.addAll(unaryRpc.body());
            regionTag = unaryRpc.regionTag();
        }
        List<Statement> body = Arrays.asList(TryCatchStatement.builder().setTryResourceExpr(SampleComposerUtil.assignClientVariableWithCreateMethodExpr(clientVarExpr)).setTryBody(bodyStatements).setIsSampleCode(true).build());
        return Sample.builder().setBody(body).setRegionTag(regionTag).setIsCanonical(true).build();
    }

    static Sample composeSample(Method method, VariableExpr clientVarExpr, List<VariableExpr> rpcMethodArgVarExprs, List<Expr> bodyExprs, Service service) {
        boolean returnsVoid = method.outputType().isProtoEmptyType();
        MethodInvocationExpr clientRpcMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientVarExpr).setMethodName(JavaStyle.toLowerCamelCase(method.name())).setArguments(rpcMethodArgVarExprs.stream().map(e -> e).collect(Collectors.toList())).setReturnType(method.outputType()).build();
        if (returnsVoid) {
            bodyExprs.add(clientRpcMethodInvocationExpr);
        } else {
            VariableExpr responseVarExpr = VariableExpr.withVariable(Variable.builder().setName("response").setType(method.outputType()).build());
            bodyExprs.add(AssignmentExpr.builder().setVariableExpr(responseVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(clientRpcMethodInvocationExpr).build());
        }
        RegionTag regionTag = RegionTag.builder().setServiceName(service.name()).setRpcName(method.name()).setOverloadDisambiguation(SampleComposerUtil.createOverloadDisambiguation(rpcMethodArgVarExprs)).build();
        return Sample.builder().setBody(bodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).setRegionTag(regionTag).build();
    }

    static Sample composePagedSample(Method method, VariableExpr clientVarExpr, List<VariableExpr> rpcMethodArgVarExprs, List<Expr> bodyExprs, Map<String, Message> messageTypes, Service service) {
        Message methodOutputMessage = messageTypes.get(method.outputType().reference().fullName());
        Preconditions.checkNotNull(methodOutputMessage, "Output message %s not found, keys: ", (Object)method.outputType().reference().fullName(), (Object)messageTypes.keySet().toString());
        Field repeatedPagedResultsField = methodOutputMessage.findAndUnwrapPaginatedRepeatedField();
        Preconditions.checkNotNull(repeatedPagedResultsField, String.format("No repeated field found on message %s for method %s", methodOutputMessage.name(), method.name()));
        TypeNode repeatedResponseType = repeatedPagedResultsField.type();
        MethodInvocationExpr clientMethodIterateAllExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientVarExpr).setMethodName(JavaStyle.toLowerCamelCase(method.name())).setArguments(rpcMethodArgVarExprs.stream().map(e -> e).collect(Collectors.toList())).build();
        clientMethodIterateAllExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientMethodIterateAllExpr).setMethodName("iterateAll").setReturnType(repeatedResponseType).build();
        ForStatement loopIteratorStatement = ForStatement.builder().setLocalVariableExpr(VariableExpr.builder().setVariable(Variable.builder().setName("element").setType(repeatedResponseType).build()).setIsDecl(true).build()).setCollectionExpr(clientMethodIterateAllExpr).setBody(Arrays.asList(CommentStatement.withComment(LineComment.withComment("doThingsWith(element);")))).build();
        List<Statement> bodyStatements = bodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList());
        bodyExprs.clear();
        bodyStatements.add(loopIteratorStatement);
        RegionTag regionTag = RegionTag.builder().setServiceName(service.name()).setRpcName(method.name()).setOverloadDisambiguation(SampleComposerUtil.createOverloadDisambiguation(rpcMethodArgVarExprs)).build();
        return Sample.builder().setBody(bodyStatements).setRegionTag(regionTag).build();
    }

    static Sample composeLroSample(Method method, VariableExpr clientVarExpr, List<VariableExpr> rpcMethodArgVarExprs, List<Expr> bodyExprs, Service service) {
        MethodInvocationExpr invokeLroGetMethodExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientVarExpr).setMethodName(String.format("%sAsync", JavaStyle.toLowerCamelCase(method.name()))).setArguments(rpcMethodArgVarExprs.stream().map(e -> e).collect(Collectors.toList())).build();
        invokeLroGetMethodExpr = MethodInvocationExpr.builder().setExprReferenceExpr(invokeLroGetMethodExpr).setMethodName("get").setReturnType(method.lro().responseType()).build();
        boolean returnsVoid = method.lro().responseType().isProtoEmptyType();
        if (returnsVoid) {
            bodyExprs.add(invokeLroGetMethodExpr);
        } else {
            VariableExpr responseVarExpr = VariableExpr.builder().setVariable(Variable.builder().setName("response").setType(method.lro().responseType()).build()).setIsDecl(true).build();
            bodyExprs.add(AssignmentExpr.builder().setVariableExpr(responseVarExpr).setValueExpr(invokeLroGetMethodExpr).build());
        }
        RegionTag regionTag = RegionTag.builder().setServiceName(service.name()).setRpcName(method.name()).setOverloadDisambiguation(SampleComposerUtil.createOverloadDisambiguation(rpcMethodArgVarExprs)).build();
        return Sample.builder().setBody(bodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).setRegionTag(regionTag).build();
    }
}

