/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AstNode;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_VariableExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.IdentifierNode;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.Variable;
import com.google.api.generator.engine.lexicon.Keyword;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@AutoValue
public abstract class VariableExpr
implements Expr {
    public abstract Variable variable();

    @Nullable
    public abstract Expr exprReferenceExpr();

    @Nullable
    public abstract TypeNode staticReferenceType();

    public abstract boolean isDecl();

    public abstract ScopeNode scope();

    public abstract boolean isStatic();

    public abstract boolean isFinal();

    public abstract boolean isVolatile();

    public abstract ImmutableList<AnnotationNode> annotations();

    public abstract ImmutableList<AstNode> templateNodes();

    abstract ImmutableList<Object> templateObjects();

    @Override
    public TypeNode type() {
        if (this.isDecl()) {
            return TypeNode.VOID;
        }
        return this.variable().type();
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static VariableExpr withVariable(Variable variable) {
        return VariableExpr.builder().setVariable(variable).build();
    }

    public static Builder builder() {
        return new AutoValue_VariableExpr.Builder().setIsDecl(false).setIsFinal(false).setIsStatic(false).setIsVolatile(false).setScope(ScopeNode.LOCAL).setTemplateObjects(ImmutableList.of()).setAnnotations(Collections.emptyList());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setVariable(Variable var1);

        public abstract Builder setExprReferenceExpr(Expr var1);

        public abstract Builder setStaticReferenceType(TypeNode var1);

        public abstract Builder setIsDecl(boolean var1);

        public abstract Builder setScope(ScopeNode var1);

        public abstract Builder setIsStatic(boolean var1);

        public abstract Builder setIsFinal(boolean var1);

        public abstract Builder setIsVolatile(boolean var1);

        public abstract Builder setAnnotations(List<AnnotationNode> var1);

        abstract ImmutableList<AnnotationNode> annotations();

        public abstract Builder setTemplateObjects(List<Object> var1);

        abstract Builder setTemplateNodes(List<AstNode> var1);

        abstract Variable variable();

        abstract ImmutableList<Object> templateObjects();

        abstract VariableExpr autoBuild();

        public VariableExpr build() {
            String varName;
            NodeValidator.checkNoNullElements(this.templateObjects(), "template objects", String.format("variable expr %s", this.variable().identifier().name()));
            this.setTemplateNodes(this.templateObjects().stream().map(o -> {
                Preconditions.checkState(o instanceof String || o instanceof TypeNode, "Template objects can only be Strings or Typenodes");
                if (o instanceof String) {
                    return IdentifierNode.withName((String)o);
                }
                return (AstNode)o;
            }).collect(Collectors.toList()));
            ImmutableList<AnnotationNode> processedAnnotations = this.annotations();
            this.setAnnotations(new LinkedHashSet<AnnotationNode>(processedAnnotations).stream().collect(Collectors.toList()));
            VariableExpr variableExpr = this.autoBuild();
            if (!variableExpr.isDecl()) {
                Preconditions.checkState(variableExpr.annotations().isEmpty(), "Annotation can only be added to variable declaration.");
            }
            if (variableExpr.isDecl() || variableExpr.exprReferenceExpr() != null) {
                Preconditions.checkState(variableExpr.isDecl() ^ variableExpr.exprReferenceExpr() != null, "Variable references cannot be declared");
            }
            Preconditions.checkState(variableExpr.exprReferenceExpr() == null || variableExpr.staticReferenceType() == null, "Only the expression reference or the static reference can be set, not both");
            if (variableExpr.exprReferenceExpr() != null) {
                Preconditions.checkState(TypeNode.isReferenceType(variableExpr.exprReferenceExpr().type()), "Variables can only be referenced from object types");
            }
            if (variableExpr.staticReferenceType() != null) {
                Preconditions.checkState(TypeNode.isReferenceType(variableExpr.staticReferenceType()), String.format("Static field references can only be done on static types, but instead found %s", variableExpr.staticReferenceType()));
            }
            if (Keyword.isKeyword(varName = variableExpr.variable().identifier().name())) {
                Preconditions.checkState(variableExpr.staticReferenceType() != null || variableExpr.exprReferenceExpr() != null && TypeNode.isReferenceType(variableExpr.exprReferenceExpr().type()), String.format("Variable field name %s is invalid on non-static or non-reference types", varName));
            }
            return variableExpr;
        }
    }
}

