/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.WhileStatement;
import com.google.common.collect.ImmutableList;
import java.util.List;

final class AutoValue_WhileStatement
extends WhileStatement {
    private final Expr conditionExpr;
    private final ImmutableList<Statement> body;

    private AutoValue_WhileStatement(Expr conditionExpr, ImmutableList<Statement> body) {
        this.conditionExpr = conditionExpr;
        this.body = body;
    }

    @Override
    public Expr conditionExpr() {
        return this.conditionExpr;
    }

    @Override
    public ImmutableList<Statement> body() {
        return this.body;
    }

    public String toString() {
        return "WhileStatement{conditionExpr=" + this.conditionExpr + ", body=" + this.body + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WhileStatement) {
            WhileStatement that = (WhileStatement)o;
            return this.conditionExpr.equals(that.conditionExpr()) && this.body.equals(that.body());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.conditionExpr.hashCode();
        h$ *= 1000003;
        return h$ ^= this.body.hashCode();
    }

    static final class Builder
    extends WhileStatement.Builder {
        private Expr conditionExpr;
        private ImmutableList<Statement> body;

        Builder() {
        }

        @Override
        public WhileStatement.Builder setConditionExpr(Expr conditionExpr) {
            if (conditionExpr == null) {
                throw new NullPointerException("Null conditionExpr");
            }
            this.conditionExpr = conditionExpr;
            return this;
        }

        @Override
        public WhileStatement.Builder setBody(List<Statement> body) {
            this.body = ImmutableList.copyOf(body);
            return this;
        }

        @Override
        ImmutableList<Statement> body() {
            if (this.body == null) {
                throw new IllegalStateException("Property \"body\" has not been set");
            }
            return this.body;
        }

        @Override
        WhileStatement autoBuild() {
            if (this.conditionExpr == null || this.body == null) {
                StringBuilder missing = new StringBuilder();
                if (this.conditionExpr == null) {
                    missing.append(" conditionExpr");
                }
                if (this.body == null) {
                    missing.append(" body");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_WhileStatement(this.conditionExpr, this.body);
        }
    }
}

