/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2.draft10;

import com.google.api.client.auth.oauth2.draft10.AccessTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.json.JsonHttpParser;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class AccessTokenRequest
extends GenericData {
    public HttpTransport transport;
    public JsonFactory jsonFactory;
    @Key(value="grant_type")
    public GrantType grantType = GrantType.NONE;
    @Key(value="client_id")
    public String clientId;
    public String clientSecret;
    @Key
    public String scope;
    public String authorizationServerUrl;
    public boolean useBasicAuthorization;

    public AccessTokenRequest() {
    }

    protected AccessTokenRequest(HttpTransport transport, JsonFactory jsonFactory, String authorizationServerUrl, String clientSecret) {
        this();
        this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        this.authorizationServerUrl = (String)Preconditions.checkNotNull((Object)authorizationServerUrl);
        this.clientSecret = (String)Preconditions.checkNotNull((Object)clientSecret);
    }

    public AccessTokenRequest(HttpTransport transport, JsonFactory jsonFactory, String authorizationServerUrl, String clientId, String clientSecret) {
        this(transport, jsonFactory, authorizationServerUrl, clientSecret);
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId);
    }

    public final HttpResponse executeUnparsed() throws IOException {
        JsonHttpParser parser = new JsonHttpParser();
        parser.jsonFactory = this.jsonFactory;
        UrlEncodedContent content = new UrlEncodedContent();
        content.data = this;
        HttpRequest request = this.transport.createRequestFactory().buildPostRequest(new GenericUrl(this.authorizationServerUrl), content);
        request.addParser(parser);
        if (this.useBasicAuthorization) {
            request.headers.setBasicAuthentication(this.clientId, this.clientSecret);
        } else {
            this.put("client_secret", (Object)this.clientSecret);
        }
        return request.execute();
    }

    public final AccessTokenResponse execute() throws IOException {
        return this.executeUnparsed().parseAs(AccessTokenResponse.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GrantType {
        AUTHORIZATION_CODE,
        PASSWORD,
        ASSERTION,
        REFRESH_TOKEN,
        NONE;

    }

    public static class RefreshTokenGrant
    extends AccessTokenRequest {
        @Key(value="refresh_token")
        public String refreshToken;

        public RefreshTokenGrant() {
            this.grantType = GrantType.REFRESH_TOKEN;
        }

        public RefreshTokenGrant(HttpTransport transport, JsonFactory jsonFactory, String authorizationServerUrl, String clientId, String clientSecret, String refreshToken) {
            super(transport, jsonFactory, authorizationServerUrl, clientId, clientSecret);
            this.grantType = GrantType.REFRESH_TOKEN;
            this.refreshToken = (String)Preconditions.checkNotNull((Object)refreshToken);
        }
    }

    public static class AssertionGrant
    extends AccessTokenRequest {
        @Key(value="assertion_type")
        public String assertionType;
        @Key
        public String assertion;

        public AssertionGrant() {
            this.grantType = GrantType.ASSERTION;
        }

        public AssertionGrant(HttpTransport transport, JsonFactory jsonFactory, String authorizationServerUrl, String clientSecret, String assertionType, String assertion) {
            super(transport, jsonFactory, authorizationServerUrl, clientSecret);
            this.grantType = GrantType.ASSERTION;
            this.assertionType = (String)Preconditions.checkNotNull((Object)assertionType);
            this.assertion = (String)Preconditions.checkNotNull((Object)assertion);
        }
    }

    public static class ResourceOwnerPasswordCredentialsGrant
    extends AccessTokenRequest {
        @Key
        public String username;
        public String password;

        public ResourceOwnerPasswordCredentialsGrant() {
            this.grantType = GrantType.PASSWORD;
        }

        public ResourceOwnerPasswordCredentialsGrant(HttpTransport transport, JsonFactory jsonFactory, String authorizationServerUrl, String clientId, String clientSecret, String username, String password) {
            super(transport, jsonFactory, authorizationServerUrl, clientId, clientSecret);
            this.grantType = GrantType.PASSWORD;
            this.username = (String)Preconditions.checkNotNull((Object)username);
            this.password = (String)Preconditions.checkNotNull((Object)password);
        }
    }

    public static class AuthorizationCodeGrant
    extends AccessTokenRequest {
        @Key
        public String code;
        @Key(value="redirect_uri")
        public String redirectUri;

        public AuthorizationCodeGrant() {
            this.grantType = GrantType.AUTHORIZATION_CODE;
        }

        public AuthorizationCodeGrant(HttpTransport transport, JsonFactory jsonFactory, String authorizationServerUrl, String clientId, String clientSecret, String code, String redirectUri) {
            super(transport, jsonFactory, authorizationServerUrl, clientId, clientSecret);
            this.grantType = GrantType.AUTHORIZATION_CODE;
            this.code = (String)Preconditions.checkNotNull((Object)code);
            this.redirectUri = (String)Preconditions.checkNotNull((Object)redirectUri);
        }
    }
}

