/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.javanet;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.javanet.NetHttpResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

final class NetHttpRequest
extends LowLevelHttpRequest {
    private final HttpURLConnection connection;
    private HttpContent content;

    NetHttpRequest(String requestMethod, String url) throws IOException {
        HttpURLConnection connection = this.connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod(requestMethod);
        connection.setUseCaches(false);
    }

    public void addHeader(String name, String value) {
        this.connection.addRequestProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LowLevelHttpResponse execute() throws IOException {
        HttpURLConnection connection = this.connection;
        HttpContent content = this.content;
        if (content != null) {
            long contentLength;
            connection.setDoOutput(true);
            this.addHeader("Content-Type", content.getType());
            String contentEncoding = content.getEncoding();
            if (contentEncoding != null) {
                this.addHeader("Content-Encoding", contentEncoding);
            }
            if ((contentLength = content.getLength()) >= 0L) {
                this.addHeader("Content-Length", Long.toString(contentLength));
            }
            content.writeTo(connection.getOutputStream());
        }
        String httpStrictPostRedirect = System.getProperty("http.strictPostRedirect");
        try {
            System.setProperty("http.strictPostRedirect", "true");
            connection.connect();
            NetHttpResponse netHttpResponse = new NetHttpResponse(connection);
            return netHttpResponse;
        }
        finally {
            if (httpStrictPostRedirect == null) {
                System.clearProperty("http.strictPostRedirect");
            } else {
                System.setProperty("http.strictPostRedirect", httpStrictPostRedirect);
            }
        }
    }

    public void setContent(HttpContent content) {
        this.content = content;
    }
}

