/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.rpc2.JsonRpcRequest;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoogleJsonRpcHttpTransport {
    private static final String JSON_RPC_CONTENT_TYPE = "application/json-rpc";
    @Deprecated
    public GenericUrl rpcServerUrl;
    @Deprecated
    public HttpTransport transport;
    @Deprecated
    public JsonFactory jsonFactory;
    @Deprecated
    public String contentType;
    @Deprecated
    public String accept;

    public GoogleJsonRpcHttpTransport(HttpTransport httpTransport, JsonFactory jsonFactory) {
        this((HttpTransport)Preconditions.checkNotNull((Object)httpTransport), (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory), Builder.DEFAULT_SERVER_URL.build(), JSON_RPC_CONTENT_TYPE, JSON_RPC_CONTENT_TYPE);
    }

    protected GoogleJsonRpcHttpTransport(HttpTransport httpTransport, JsonFactory jsonFactory, String rpcServerUrl, String contentType, String accept) {
        this.accept = this.contentType = JSON_RPC_CONTENT_TYPE;
        this.transport = httpTransport;
        this.jsonFactory = jsonFactory;
        this.rpcServerUrl = new GenericUrl(rpcServerUrl);
        this.contentType = contentType;
        this.accept = accept;
    }

    public final HttpTransport getHttpTransport() {
        return this.transport;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final String getRpcServerUrl() {
        return this.rpcServerUrl.build();
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final String getAccept() {
        return this.accept;
    }

    public HttpRequest buildPostRequest(JsonRpcRequest request) {
        return this.internalExecute(request);
    }

    public HttpRequest buildPostRequest(List<JsonRpcRequest> requests) {
        return this.internalExecute(requests);
    }

    private HttpRequest internalExecute(Object data) {
        JsonHttpContent content = new JsonHttpContent(this.jsonFactory, data);
        content.setType(this.contentType);
        try {
            HttpRequest httpRequest = this.transport.createRequestFactory().buildPostRequest(this.rpcServerUrl, (HttpContent)content);
            httpRequest.getHeaders().setAccept(this.accept);
            return httpRequest;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class Builder {
        static final GenericUrl DEFAULT_SERVER_URL = new GenericUrl("https://www.googleapis.com");
        private final HttpTransport httpTransport;
        private final JsonFactory jsonFactory;
        private GenericUrl rpcServerUrl = DEFAULT_SERVER_URL;
        private String contentType;
        private String accept = this.contentType = "application/json-rpc";

        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory) {
            this.httpTransport = (HttpTransport)Preconditions.checkNotNull((Object)httpTransport);
            this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        }

        protected Builder setRpcServerUrl(GenericUrl rpcServerUrl) {
            this.rpcServerUrl = (GenericUrl)Preconditions.checkNotNull((Object)rpcServerUrl);
            return this;
        }

        protected Builder setContentType(String contentType) {
            this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
            return this;
        }

        protected Builder setAccept(String accept) {
            this.accept = (String)Preconditions.checkNotNull((Object)accept);
            return this;
        }

        protected GoogleJsonRpcHttpTransport build() {
            return new GoogleJsonRpcHttpTransport(this.httpTransport, this.jsonFactory, this.rpcServerUrl.build(), this.contentType, this.accept);
        }

        public final HttpTransport getHttpTransport() {
            return this.httpTransport;
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public final GenericUrl getRpcServerUrl() {
            return this.rpcServerUrl;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final String getAccept() {
            return this.accept;
        }
    }
}

