/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.services;

import com.google.api.client.googleapis.MethodOverride;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpClient;
import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import java.io.IOException;

public class GoogleClient
extends JsonHttpClient {
    public GoogleClient(HttpTransport transport, JsonFactory jsonFactory, String baseUrl) {
        super(transport, jsonFactory, baseUrl);
    }

    protected GoogleClient(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, String baseUrl, String applicationName) {
        super(transport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, baseUrl, applicationName);
    }

    @Deprecated
    protected HttpRequest buildHttpRequest(HttpMethod method, String uriTemplate, JsonHttpRequest jsonHttpRequest) throws IOException {
        HttpRequest httpRequest = super.buildHttpRequest(method, uriTemplate, jsonHttpRequest);
        new MethodOverride().intercept(httpRequest);
        httpRequest.setAllowEmptyContent(false);
        return httpRequest;
    }

    protected HttpRequest buildHttpRequest(HttpMethod method, GenericUrl url, Object body) throws IOException {
        HttpRequest httpRequest = super.buildHttpRequest(method, url, body);
        new MethodOverride().intercept(httpRequest);
        httpRequest.setAllowEmptyContent(false);
        if (body != null) {
            httpRequest.setEnableGZipContent(true);
        }
        return httpRequest;
    }

    public static Builder builder(HttpTransport transport, JsonFactory jsonFactory, GenericUrl baseUrl) {
        return new Builder(transport, jsonFactory, baseUrl);
    }

    @Deprecated
    protected HttpResponse execute(HttpMethod method, String uriTemplate, Object body, JsonHttpRequest jsonHttpRequest) throws IOException {
        HttpRequest request = this.buildHttpRequest(method, uriTemplate, jsonHttpRequest);
        if (body != null) {
            request.setContent((HttpContent)this.createSerializer(body));
            request.setEnableGZipContent(true);
        }
        return GoogleJsonResponseException.execute(this.getJsonFactory(), request);
    }

    protected HttpResponse executeUnparsed(HttpMethod method, GenericUrl url, Object body) throws IOException {
        HttpRequest request = this.buildHttpRequest(method, url, body);
        return GoogleJsonResponseException.execute(this.getJsonFactory(), request);
    }

    public static class Builder
    extends JsonHttpClient.Builder {
        protected Builder(HttpTransport transport, JsonFactory jsonFactory, GenericUrl baseUrl) {
            super(transport, jsonFactory, baseUrl);
        }

        public GoogleClient build() {
            return new GoogleClient(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getBaseUrl().build(), this.getApplicationName());
        }
    }
}

