/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.json.CustomizeJsonParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJsonFeedParser<T> {
    private boolean feedParsed;
    final JsonParser parser;
    final Class<T> feedClass;

    AbstractJsonFeedParser(JsonParser parser, Class<T> feedClass) {
        this.parser = parser;
        this.feedClass = feedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T parseFeed() throws IOException {
        boolean close = true;
        try {
            this.feedParsed = true;
            Object result = this.parser.parse(this.feedClass, (CustomizeJsonParser)new StopAtItems());
            close = false;
            Object object = result;
            return (T)object;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseNextItem() throws IOException {
        JsonParser parser = this.parser;
        if (!this.feedParsed) {
            this.feedParsed = true;
            parser.skipToKey("items");
        }
        boolean close = true;
        try {
            if (parser.nextToken() == JsonToken.START_OBJECT) {
                Object result = this.parseItemInternal();
                close = false;
                Object object = result;
                return object;
            }
        }
        finally {
            if (close) {
                this.close();
            }
        }
        return null;
    }

    public void close() throws IOException {
        this.parser.close();
    }

    abstract Object parseItemInternal() throws IOException;

    final class StopAtItems
    extends CustomizeJsonParser {
        StopAtItems() {
        }

        public boolean stopAt(Object context, String key) {
            return "items".equals(key) && context.getClass().equals(AbstractJsonFeedParser.this.feedClass);
        }
    }
}

