/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth;

import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Types;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthKeyValueParser
implements HttpParser {
    public static final AuthKeyValueParser INSTANCE = new AuthKeyValueParser();

    public String getContentType() {
        return "text/plain";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parse(HttpResponse response, Class<T> dataClass) throws IOException {
        Object newInstance = Types.newInstance(dataClass);
        ClassInfo classInfo = ClassInfo.of(dataClass);
        response.setContentLoggingLimit(0);
        InputStream content = response.getContent();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(content));
            while ((line = reader.readLine()) != null) {
                int equals = line.indexOf(61);
                String key = line.substring(0, equals);
                String value = line.substring(equals + 1);
                Field field = classInfo.getField(key);
                if (field != null) {
                    Class<?> fieldClass = field.getType();
                    Object fieldValue = fieldClass == Boolean.TYPE || fieldClass == Boolean.class ? Boolean.valueOf(value) : value;
                    FieldInfo.setFieldValue((Field)field, (Object)newInstance, (Object)fieldValue);
                    continue;
                }
                if (GenericData.class.isAssignableFrom(dataClass)) {
                    GenericData data = (GenericData)newInstance;
                    data.set(key, (Object)value);
                    continue;
                }
                if (!Map.class.isAssignableFrom(dataClass)) continue;
                Map map = (Map)newInstance;
                map.put(key, value);
            }
        }
        finally {
            content.close();
        }
        return (T)newInstance;
    }

    private AuthKeyValueParser() {
    }
}

