/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.batch;

import com.google.api.client.googleapis.batch.BatchCallback;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.ErrorOutput;
import com.google.api.client.googleapis.batch.MockData;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonErrorContainer;
import com.google.api.client.googleapis.services.AbstractGoogleClient;
import com.google.api.client.googleapis.testing.services.MockGoogleClient;
import com.google.api.client.googleapis.testing.services.MockGoogleClientRequest;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.protobuf.ProtoObjectParser;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.Charsets;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class BatchRequestTest
extends TestCase {
    private static final String ROOT_URL = "http://www.test.com/";
    private static final String SERVICE_PATH = "test/";
    private static final String TEST_BATCH_URL = "http://www.testgoogleapis.com/batch";
    private static final String URI_TEMPLATE1 = "uri/template/1";
    private static final String URI_TEMPLATE2 = "uri/template/2";
    private static final String METHOD1 = "GET";
    private static final String METHOD2 = "POST";
    private static final String ERROR_MSG = "Error message";
    private static final String ERROR_REASON = "notFound";
    private static final int ERROR_CODE = 503;
    private static final String ERROR_DOMAIN = "global";
    private static final String RESPONSE_BOUNDARY = "ABC=DE=F";
    private static final String TEST_ID = "Humpty Dumpty";
    private static final String TEST_KIND = "Big\nEgg\n";
    private static final String TEST_NAME = "James Bond";
    private static final String TEST_NUM = "007";
    private TestCallback1 callback1;
    private TestCallback2 callback2;
    private TestCallback3 callback3;
    private MockTransport transport;
    private MockCredential credential;

    protected void setUp() {
        this.callback1 = new TestCallback1();
        this.callback2 = new TestCallback2();
        this.callback3 = new TestCallback3();
    }

    private BatchRequest getBatchPopulatedWithRequests(boolean testServerError, boolean testAuthenticationError, boolean returnSuccessAuthenticatedContent, boolean testRedirect, boolean testBinary, boolean testMissingLength) throws IOException {
        this.transport = new MockTransport(testServerError, testAuthenticationError, testRedirect, testBinary, testMissingLength);
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)this.transport, ROOT_URL, SERVICE_PATH, null, null).setApplicationName("Test Application").build();
        MockGoogleClientRequest jsonHttpRequest1 = new MockGoogleClientRequest((AbstractGoogleClient)client, METHOD1, URI_TEMPLATE1, null, String.class);
        MockGoogleClientRequest jsonHttpRequest2 = new MockGoogleClientRequest((AbstractGoogleClient)client, METHOD2, URI_TEMPLATE2, null, String.class);
        this.credential = new MockCredential();
        ProtoObjectParser parser = testBinary ? new ProtoObjectParser() : new JsonObjectParser((JsonFactory)new GsonFactory());
        BatchRequest batchRequest = new BatchRequest((HttpTransport)this.transport, (HttpRequestInitializer)this.credential).setBatchUrl(new GenericUrl(TEST_BATCH_URL));
        HttpRequest request1 = jsonHttpRequest1.buildHttpRequest();
        request1.setParser((ObjectParser)parser);
        HttpRequest request2 = jsonHttpRequest2.buildHttpRequest();
        request2.setParser((ObjectParser)parser);
        if (testAuthenticationError) {
            request2.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new MockUnsuccessfulResponseHandler(this.transport, returnSuccessAuthenticatedContent));
        }
        if (testBinary) {
            batchRequest.queue(request1, MockData.Class1.class, ErrorOutput.ErrorBody.class, (BatchCallback)new TestCallback1Adapter(this.callback1));
            batchRequest.queue(request2, MockData.Class2.class, ErrorOutput.ErrorBody.class, (BatchCallback)new TestCallback2Adapter(this.callback2));
        } else {
            batchRequest.queue(request1, MockDataClass1.class, GoogleJsonErrorContainer.class, (BatchCallback)this.callback1);
            batchRequest.queue(request2, MockDataClass2.class, GoogleJsonErrorContainer.class, (BatchCallback)this.callback2);
        }
        return batchRequest;
    }

    public void testQueueDatastructures() throws Exception {
        BatchRequest batchRequest = this.getBatchPopulatedWithRequests(false, false, false, false, false, false);
        List requestInfos = batchRequest.requestInfos;
        BatchRequestTest.assertEquals((int)2, (int)requestInfos.size());
        BatchRequestTest.assertEquals(MockDataClass1.class, (Object)((BatchRequest.RequestInfo)requestInfos.get((int)0)).dataClass);
        BatchRequestTest.assertEquals((Object)this.callback1, (Object)((BatchRequest.RequestInfo)requestInfos.get((int)0)).callback);
        BatchRequestTest.assertEquals(MockDataClass2.class, (Object)((BatchRequest.RequestInfo)requestInfos.get((int)1)).dataClass);
        BatchRequestTest.assertEquals((Object)this.callback2, (Object)((BatchRequest.RequestInfo)requestInfos.get((int)1)).callback);
        BatchRequestTest.assertEquals((String)"http://www.test.com/test/uri/template/1", (String)((BatchRequest.RequestInfo)requestInfos.get((int)0)).request.getUrl().build());
        BatchRequestTest.assertEquals((String)"http://www.test.com/test/uri/template/2", (String)((BatchRequest.RequestInfo)requestInfos.get((int)1)).request.getUrl().build());
        BatchRequestTest.assertEquals((String)METHOD1, (String)((BatchRequest.RequestInfo)requestInfos.get((int)0)).request.getRequestMethod());
        BatchRequestTest.assertEquals((String)METHOD2, (String)((BatchRequest.RequestInfo)requestInfos.get((int)1)).request.getRequestMethod());
    }

    public void testExecute() throws IOException {
        BatchRequest batchRequest = this.getBatchPopulatedWithRequests(false, false, false, false, false, false);
        batchRequest.execute();
        BatchRequestTest.assertEquals((int)1, (int)this.callback1.successCalls);
        BatchRequestTest.assertEquals((int)1, (int)this.callback2.successCalls);
        BatchRequestTest.assertEquals((int)0, (int)this.callback2.failureCalls);
        BatchRequestTest.assertTrue((boolean)batchRequest.requestInfos.isEmpty());
    }

    public void testExecuteWithError() throws IOException {
        BatchRequest batchRequest = this.getBatchPopulatedWithRequests(true, false, false, false, false, false);
        batchRequest.execute();
        BatchRequestTest.assertEquals((int)1, (int)this.callback1.successCalls);
        BatchRequestTest.assertEquals((int)0, (int)this.callback2.successCalls);
        BatchRequestTest.assertEquals((int)1, (int)this.callback2.failureCalls);
        BatchRequestTest.assertTrue((boolean)batchRequest.requestInfos.isEmpty());
        BatchRequestTest.assertEquals((int)1, (int)this.transport.actualCalls);
    }

    public void testExecuteWithVoidCallback() throws Exception {
        this.subTestExecuteWithVoidCallback(false);
        BatchRequestTest.assertEquals((int)1, (int)this.callback1.successCalls);
        BatchRequestTest.assertEquals((int)1, (int)this.callback3.successCalls);
        BatchRequestTest.assertEquals((int)0, (int)this.callback3.failureCalls);
    }

    public void testExecuteWithVoidCallbackError() throws Exception {
        this.subTestExecuteWithVoidCallback(true);
        BatchRequestTest.assertEquals((int)1, (int)this.callback1.successCalls);
        BatchRequestTest.assertEquals((int)0, (int)this.callback3.successCalls);
        BatchRequestTest.assertEquals((int)1, (int)this.callback3.failureCalls);
    }

    public void subTestExecuteWithVoidCallback(boolean testServerError) throws IOException {
        MockTransport transport = new MockTransport(testServerError, false, false, false, false);
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, null, null).setApplicationName("Test Application").build();
        MockGoogleClientRequest jsonHttpRequest1 = new MockGoogleClientRequest((AbstractGoogleClient)client, METHOD1, URI_TEMPLATE1, null, String.class);
        MockGoogleClientRequest jsonHttpRequest2 = new MockGoogleClientRequest((AbstractGoogleClient)client, METHOD2, URI_TEMPLATE2, null, String.class);
        JsonObjectParser parser = new JsonObjectParser((JsonFactory)new GsonFactory());
        BatchRequest batchRequest = new BatchRequest((HttpTransport)transport, null).setBatchUrl(new GenericUrl(TEST_BATCH_URL));
        HttpRequest request1 = jsonHttpRequest1.buildHttpRequest();
        request1.setParser((ObjectParser)parser);
        HttpRequest request2 = jsonHttpRequest2.buildHttpRequest();
        request2.setParser((ObjectParser)parser);
        batchRequest.queue(request1, MockDataClass1.class, GoogleJsonErrorContainer.class, (BatchCallback)this.callback1);
        batchRequest.queue(request2, Void.class, Void.class, (BatchCallback)this.callback3);
        batchRequest.execute();
        BatchRequestTest.assertEquals((int)1, (int)transport.actualCalls);
    }

    public void testExecuteWithAuthenticationErrorThenSuccessCallback() throws Exception {
        BatchRequest batchRequest = this.getBatchPopulatedWithRequests(false, true, true, false, false, false);
        batchRequest.execute();
        BatchRequestTest.assertEquals((int)1, (int)this.callback1.successCalls);
        BatchRequestTest.assertEquals((int)1, (int)this.callback2.successCalls);
        BatchRequestTest.assertEquals((int)0, (int)this.callback2.failureCalls);
        BatchRequestTest.assertEquals((int)2, (int)this.transport.actualCalls);
        BatchRequestTest.assertTrue((boolean)batchRequest.requestInfos.isEmpty());
    }

    public void testExecuteWithAuthenticationErrorThenErrorCallback() throws Exception {
        BatchRequest batchRequest = this.getBatchPopulatedWithRequests(false, true, false, false, false, false);
        batchRequest.execute();
        BatchRequestTest.assertEquals((int)1, (int)this.callback1.successCalls);
        BatchRequestTest.assertEquals((int)0, (int)this.callback2.successCalls);
        BatchRequestTest.assertEquals((int)1, (int)this.callback2.failureCalls);
        BatchRequestTest.assertEquals((int)2, (int)this.transport.actualCalls);
        BatchRequestTest.assertTrue((boolean)batchRequest.requestInfos.isEmpty());
    }

    public void testInterceptor() throws Exception {
        BatchRequest batchRequest = this.getBatchPopulatedWithRequests(true, false, false, false, false, false);
        batchRequest.execute();
        BatchRequestTest.assertTrue((boolean)this.credential.initializerCalled);
        BatchRequestTest.assertTrue((boolean)this.credential.interceptorCalled);
    }

    public void testRedirect() throws Exception {
        BatchRequest batchRequest = this.getBatchPopulatedWithRequests(false, false, false, true, false, false);
        this.transport.callsBeforeSuccess = 2;
        batchRequest.execute();
        BatchRequestTest.assertEquals((int)2, (int)this.transport.actualCalls);
        BatchRequestTest.assertTrue((boolean)batchRequest.requestInfos.isEmpty());
    }

    public void testExecute_checkWriteTo() throws Exception {
        String request1Method = METHOD2;
        String request1Url = "http://test/dummy/url1";
        String request1ContentType = "application/json";
        String request1Content = "{\"data\":{\"foo\":{\"v1\":{}}}}";
        String request2Method = METHOD1;
        String request2Url = "http://test/dummy/url2";
        StringBuilder part1 = new StringBuilder();
        part1.append("Content-Length: 118\r\n");
        part1.append("Content-Type: application/http\r\n");
        part1.append("content-id: 1\r\n");
        part1.append("content-transfer-encoding: binary\r\n");
        part1.append("\r\n");
        part1.append("POST http://test/dummy/url1 HTTP/1.1\r\n");
        part1.append("Content-Length: 26\r\n");
        part1.append("Content-Type: " + request1ContentType + "\r\n");
        part1.append("\r\n");
        part1.append(request1Content + "\r\n");
        part1.append("--__END_OF_PART__");
        String expected1 = part1.toString();
        StringBuilder part2 = new StringBuilder();
        part2.append("Content-Length: 39\r\n");
        part2.append("Content-Type: application/http\r\n");
        part2.append("content-id: 2\r\n");
        part2.append("content-transfer-encoding: binary\r\n");
        part2.append("\r\n");
        part2.append("GET http://test/dummy/url2 HTTP/1.1\r\n");
        part2.append("\r\n");
        part2.append("\r\n");
        part2.append("--__END_OF_PART__");
        String expected2 = part2.toString();
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request1 = transport.createRequestFactory().buildRequest(request1Method, new GenericUrl(request1Url), (HttpContent)new ByteArrayContent(request1ContentType, request1Content.getBytes(StandardCharsets.UTF_8)));
        HttpRequest request2 = transport.createRequestFactory().buildRequest(request2Method, new GenericUrl(request2Url), null);
        this.subtestExecute_checkWriteTo(expected1, expected2, request1, request2);
    }

    private void subtestExecute_checkWriteTo(final String part1, final String part2, HttpRequest ... requests) throws IOException {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) {
                return new MockLowLevelHttpRequest(url){

                    public LowLevelHttpResponse execute() throws IOException {
                        TestCase.assertTrue((boolean)this.getContentType().startsWith("multipart/mixed; boundary=__END_OF_PART__"));
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        this.getStreamingContent().writeTo((OutputStream)out);
                        String actual = out.toString("UTF-8");
                        TestCase.assertTrue((String)(actual + "\n does not contain \n" + part1), (boolean)actual.contains(part1));
                        TestCase.assertTrue((boolean)actual.contains(part2));
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                        response.setStatusCode(200);
                        response.addHeader("Content-Type", "multipart/mixed; boundary=ABC=DE=F");
                        String content2 = "{\"name\": \"James Bond\", \"number\": \"007\"}";
                        StringBuilder responseContent = new StringBuilder();
                        responseContent.append("--ABC=DE=F\n").append("Content-Type: application/http\n").append("Content-Transfer-Encoding: binary\n").append("Content-ID: response-1\n\n").append("HTTP/1.1 200 OK\n").append("Content-Type: application/json; charset=UTF-8\n").append("Content-Length: " + content2.length() + "\n\n").append(content2 + "\n\n").append("--ABC=DE=F--\n\n");
                        response.setContent(responseContent.toString());
                        return response;
                    }
                };
            }
        };
        BatchRequest batchRequest = new BatchRequest((HttpTransport)transport, null);
        BatchCallback<Void, Void> callback = new BatchCallback<Void, Void>(){

            public void onSuccess(Void t, HttpHeaders responseHeaders) {
            }

            public void onFailure(Void e, HttpHeaders responseHeaders) {
            }
        };
        for (HttpRequest request : requests) {
            batchRequest.queue(request, Void.class, Void.class, (BatchCallback)callback);
        }
        batchRequest.execute();
    }

    public void testExecute_checkWriteToNoHeaders() throws IOException {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request = transport.createRequestFactory().buildPostRequest(HttpTesting.SIMPLE_GENERIC_URL, new HttpContent(){

            public long getLength() {
                return -1L;
            }

            public String getType() {
                return null;
            }

            public void writeTo(OutputStream out) {
            }

            public boolean retrySupported() {
                return true;
            }
        });
        String expected = "Content-Length: 36\r\n" + "Content-Type: application/http\r\n" + "content-id: 1\r\n" + "content-transfer-encoding: binary\r\n" + "\r\n" + "POST http://google.com/ HTTP/1.1\r\n" + "\r\n" + "\r\n" + "--__END_OF_PART__";
        this.subtestExecute_checkWriteTo(expected, expected, request);
    }

    public void testProtoExecute() throws IOException {
        BatchRequest batchRequest = this.getBatchPopulatedWithRequests(false, false, false, false, true, false);
        batchRequest.execute();
        BatchRequestTest.assertEquals((int)1, (int)this.callback1.successCalls);
        BatchRequestTest.assertEquals((int)1, (int)this.callback2.successCalls);
        BatchRequestTest.assertEquals((int)0, (int)this.callback2.failureCalls);
        BatchRequestTest.assertTrue((boolean)batchRequest.requestInfos.isEmpty());
    }

    public void testProtoExecuteWithError() throws IOException {
        BatchRequest batchRequest = this.getBatchPopulatedWithRequests(true, false, false, false, true, false);
        batchRequest.execute();
        BatchRequestTest.assertEquals((int)1, (int)this.callback1.successCalls);
        BatchRequestTest.assertEquals((int)0, (int)this.callback2.successCalls);
        BatchRequestTest.assertEquals((int)1, (int)this.callback2.failureCalls);
        BatchRequestTest.assertTrue((boolean)batchRequest.requestInfos.isEmpty());
        BatchRequestTest.assertEquals((int)1, (int)this.transport.actualCalls);
    }

    public void testProtoExecuteWithoutLength() throws IOException {
        BatchRequest batchRequest = this.getBatchPopulatedWithRequests(false, false, false, false, true, true);
        batchRequest.execute();
        BatchRequestTest.assertEquals((int)1, (int)this.callback1.successCalls);
        BatchRequestTest.assertEquals((int)1, (int)this.callback2.successCalls);
        BatchRequestTest.assertEquals((int)0, (int)this.callback2.failureCalls);
        BatchRequestTest.assertTrue((boolean)batchRequest.requestInfos.isEmpty());
    }

    private static class MockCredential
    implements HttpRequestInitializer,
    HttpExecuteInterceptor {
        boolean initializerCalled = false;
        boolean interceptorCalled = false;

        MockCredential() {
        }

        public void initialize(HttpRequest request) {
            request.setInterceptor((HttpExecuteInterceptor)this);
            this.initializerCalled = true;
        }

        public void intercept(HttpRequest request) {
            this.interceptorCalled = true;
        }
    }

    private static class MockTransport
    extends MockHttpTransport {
        final boolean testServerError;
        final boolean testAuthenticationError;
        boolean returnSuccessAuthenticatedContent;
        boolean returnErrorAuthenticatedContent;
        final boolean testRedirect;
        final boolean testBinary;
        final boolean testMissingLength;
        int actualCalls;
        int callsBeforeSuccess;

        MockTransport(boolean testServerError, boolean testAuthenticationError, boolean testRedirect, boolean testBinary, boolean testMissingLength) {
            this.testServerError = testServerError;
            this.testAuthenticationError = testAuthenticationError;
            this.testRedirect = testRedirect;
            this.testBinary = testBinary;
            this.testMissingLength = testMissingLength;
        }

        public LowLevelHttpRequest buildRequest(String name, String url) {
            ++this.actualCalls;
            return new MockLowLevelHttpRequest(){

                public LowLevelHttpResponse execute() throws IOException {
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    response.setStatusCode(200);
                    response.addHeader("Content-Type", "multipart/mixed; boundary=ABC=DE=F");
                    String contentType = MockTransport.this.testBinary ? "application/x-protobuf" : "application/json; charset=UTF-8";
                    byte[] content1 = MockTransport.this.testBinary ? MockData.Class1.newBuilder().setId(BatchRequestTest.TEST_ID).setKind(BatchRequestTest.TEST_KIND).build().toByteArray() : this.utf8Encode("{\n \"id\": \"Humpty Dumpty\",\n \"kind\": \"" + BatchRequestTest.TEST_KIND.replace("\n", "\\n") + "\"\n}");
                    byte[] content2 = MockTransport.this.testBinary ? MockData.Class2.newBuilder().setName(BatchRequestTest.TEST_NAME).setNumber(BatchRequestTest.TEST_NUM).build().toByteArray() : this.utf8Encode("{\"name\": \"James Bond\", \"number\": \"007\"}");
                    byte[] errorContent = MockTransport.this.testBinary ? ErrorOutput.ErrorBody.newBuilder().setError(ErrorOutput.ErrorProto.newBuilder().setCode(503).setMessage(BatchRequestTest.ERROR_MSG).addErrors(ErrorOutput.IndividualError.newBuilder().setDomain(BatchRequestTest.ERROR_DOMAIN).setReason(BatchRequestTest.ERROR_REASON).setMessage(BatchRequestTest.ERROR_MSG))).build().toByteArray() : this.utf8Encode("{\"error\": { \"errors\": [{\"domain\": \"global\",\"reason\": \"notFound\", \"message\": \"Error message\"}],\"code\": 503, \"message\": \"Error message\"}}");
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    OutputStreamWriter responseContent = new OutputStreamWriter((OutputStream)outputStream, "ISO-8859-1");
                    if (MockTransport.this.returnSuccessAuthenticatedContent || MockTransport.this.testRedirect && MockTransport.this.actualCalls > 1) {
                        if (MockTransport.this.returnSuccessAuthenticatedContent || MockTransport.this.actualCalls == MockTransport.this.callsBeforeSuccess) {
                            ((Writer)responseContent).append("--ABC=DE=F\n").append("Content-Type: application/http\n").append("Content-Transfer-Encoding: binary\n").append("Content-ID: response-1\n\n").append("HTTP/1.1 200 OK\n").append("Content-Type: " + contentType + "\n");
                            if (!MockTransport.this.testMissingLength) {
                                ((Writer)responseContent).append("Content-Length: " + content2.length + "\n");
                            }
                            ((Writer)responseContent).append("\n");
                            ((Writer)responseContent).flush();
                            outputStream.write(content2);
                            ((Writer)responseContent).append("\n--ABC=DE=F--\n\n");
                        } else {
                            ((Writer)responseContent).append("--ABC=DE=F\n").append("Content-Type: application/http\n").append("Content-Transfer-Encoding: binary\n").append("Content-ID: response-1\n\n").append("HTTP/1.1 503 Not Found\n").append("Content-Type: " + contentType + "\n");
                            if (!MockTransport.this.testMissingLength) {
                                ((Writer)responseContent).append("Content-Length: " + errorContent.length + "\n");
                            }
                            ((Writer)responseContent).append("\n");
                            ((Writer)responseContent).flush();
                            outputStream.write(errorContent);
                            ((Writer)responseContent).append("\n--ABC=DE=F--\n\n");
                        }
                    } else if (MockTransport.this.returnErrorAuthenticatedContent) {
                        ((Writer)responseContent).append("Content-Type: application/http\n").append("Content-Transfer-Encoding: binary\n").append("Content-ID: response-1\n\n");
                        ((Writer)responseContent).append("HTTP/1.1 503 Not Found\n").append("Content-Type: " + contentType + "\n");
                        if (!MockTransport.this.testMissingLength) {
                            ((Writer)responseContent).append("Content-Length: " + errorContent.length + "\n");
                        }
                        ((Writer)responseContent).append("\n");
                        ((Writer)responseContent).flush();
                        outputStream.write(errorContent);
                        ((Writer)responseContent).append("\n--ABC=DE=F--\n\n");
                    } else {
                        ((Writer)responseContent).append("--ABC=DE=F\n").append("Content-Type: application/http\n").append("Content-Transfer-Encoding: binary\n").append("Content-ID: response-1\n\n").append("HTTP/1.1 200 OK\n").append("Content-Type: " + contentType + "\n");
                        if (!MockTransport.this.testMissingLength) {
                            ((Writer)responseContent).append("Content-Length: " + content1.length + "\n");
                        }
                        ((Writer)responseContent).append("\n");
                        ((Writer)responseContent).flush();
                        outputStream.write(content1);
                        ((Writer)responseContent).append("\n--ABC=DE=F\n").append("Content-Type: application/http\n").append("Content-Transfer-Encoding: binary\n").append("Content-ID: response-2\n\n");
                        if (MockTransport.this.testServerError) {
                            ((Writer)responseContent).append("HTTP/1.1 503 Not Found\n").append("Content-Type: " + contentType + "\n");
                            if (!MockTransport.this.testMissingLength) {
                                ((Writer)responseContent).append("Content-Length: " + errorContent.length + "\n");
                            }
                            ((Writer)responseContent).append("\n");
                            ((Writer)responseContent).flush();
                            outputStream.write(errorContent);
                            ((Writer)responseContent).append("\n--ABC=DE=F--\n\n");
                        } else if (MockTransport.this.testAuthenticationError) {
                            ((Writer)responseContent).append("HTTP/1.1 401 Unauthorized\n").append("Content-Type: application/json; charset=UTF-8\n\n").append("--ABC=DE=F--\n\n");
                        } else if (MockTransport.this.testRedirect && MockTransport.this.actualCalls == 1) {
                            ((Writer)responseContent).append("HTTP/1.1 301 MovedPermanently\n").append("Content-Type: " + contentType + "\n").append("Location: http://redirect/location\n\n").append("--ABC=DE=F--\n\n");
                        } else {
                            ((Writer)responseContent).append("HTTP/1.1 200 OK\n").append("Content-Type: " + contentType + "\n");
                            if (!MockTransport.this.testMissingLength) {
                                ((Writer)responseContent).append("Content-Length: " + content2.length + "\n");
                            }
                            ((Writer)responseContent).append("\n");
                            ((Writer)responseContent).flush();
                            outputStream.write(content2);
                            ((Writer)responseContent).append("\n--ABC=DE=F--\n\n");
                        }
                    }
                    ((Writer)responseContent).flush();
                    response.setContent(outputStream.toByteArray());
                    return response;
                }

                private byte[] utf8Encode(String string) {
                    return Charsets.UTF_8.encode(string).array();
                }
            };
        }
    }

    private static class MockUnsuccessfulResponseHandler
    implements HttpUnsuccessfulResponseHandler {
        MockTransport transport;
        boolean returnSuccessAuthenticatedContent;

        MockUnsuccessfulResponseHandler(MockTransport transport, boolean returnSuccessAuthenticatedContent) {
            this.transport = transport;
            this.returnSuccessAuthenticatedContent = returnSuccessAuthenticatedContent;
        }

        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) {
            if (this.transport.returnErrorAuthenticatedContent) {
                return false;
            }
            if (this.returnSuccessAuthenticatedContent) {
                this.transport.returnSuccessAuthenticatedContent = true;
            } else {
                this.transport.returnErrorAuthenticatedContent = true;
            }
            return true;
        }
    }

    private static class TestCallback2Adapter
    extends TestCallbackBaseAdapter<MockData.Class2, MockDataClass2> {
        public TestCallback2Adapter(TestCallback2 callback) {
            super(callback);
        }

        public void onSuccess(MockData.Class2 message, HttpHeaders responseHeaders) throws IOException {
            MockDataClass2 dataClass = new MockDataClass2();
            dataClass.name = message.hasName() ? message.getName() : null;
            dataClass.number = message.hasNumber() ? message.getNumber() : null;
            this.callback.onSuccess((Object)dataClass, responseHeaders);
        }
    }

    private static class TestCallback1Adapter
    extends TestCallbackBaseAdapter<MockData.Class1, MockDataClass1> {
        public TestCallback1Adapter(TestCallback1 callback) {
            super(callback);
        }

        public void onSuccess(MockData.Class1 message, HttpHeaders responseHeaders) throws IOException {
            MockDataClass1 dataClass = new MockDataClass1();
            dataClass.id = message.hasId() ? message.getId() : null;
            dataClass.kind = message.hasKind() ? message.getKind() : null;
            this.callback.onSuccess((Object)dataClass, responseHeaders);
        }
    }

    private static abstract class TestCallbackBaseAdapter<InputType, OutputType>
    implements BatchCallback<InputType, ErrorOutput.ErrorBody> {
        protected final BatchCallback<OutputType, GoogleJsonErrorContainer> callback;

        protected TestCallbackBaseAdapter(BatchCallback<OutputType, GoogleJsonErrorContainer> callback) {
            this.callback = callback;
        }

        public void onFailure(ErrorOutput.ErrorBody e, HttpHeaders responseHeaders) throws IOException {
            GoogleJsonErrorContainer errorContainer = new GoogleJsonErrorContainer();
            if (e.hasError()) {
                ErrorOutput.ErrorProto errorProto = e.getError();
                GoogleJsonError error = new GoogleJsonError();
                if (errorProto.hasCode()) {
                    error.setCode(errorProto.getCode());
                }
                if (errorProto.hasMessage()) {
                    error.setMessage(errorProto.getMessage());
                }
                ArrayList<GoogleJsonError.ErrorInfo> errorInfos = new ArrayList<GoogleJsonError.ErrorInfo>(errorProto.getErrorsCount());
                for (ErrorOutput.IndividualError individualError : errorProto.getErrorsList()) {
                    GoogleJsonError.ErrorInfo errorInfo = new GoogleJsonError.ErrorInfo();
                    if (individualError.hasDomain()) {
                        errorInfo.setDomain(individualError.getDomain());
                    }
                    if (individualError.hasMessage()) {
                        errorInfo.setMessage(individualError.getMessage());
                    }
                    if (individualError.hasReason()) {
                        errorInfo.setReason(individualError.getReason());
                    }
                    errorInfos.add(errorInfo);
                }
                error.setErrors(errorInfos);
                errorContainer.setError(error);
            }
            this.callback.onFailure((Object)errorContainer, responseHeaders);
        }
    }

    private static class TestCallback3
    implements BatchCallback<Void, Void> {
        int successCalls;
        int failureCalls;

        TestCallback3() {
        }

        public void onSuccess(Void dataClass, HttpHeaders responseHeaders) {
            ++this.successCalls;
            TestCase.assertNull((Object)dataClass);
        }

        public void onFailure(Void e, HttpHeaders responseHeaders) {
            ++this.failureCalls;
            TestCase.assertNull((Object)e);
        }
    }

    private static class TestCallback2
    implements BatchCallback<MockDataClass2, GoogleJsonErrorContainer> {
        int successCalls;
        int failureCalls;

        TestCallback2() {
        }

        public void onSuccess(MockDataClass2 dataClass, HttpHeaders responseHeaders) {
            ++this.successCalls;
            TestCase.assertEquals((String)BatchRequestTest.TEST_NAME, (String)dataClass.name);
            TestCase.assertEquals((String)BatchRequestTest.TEST_NUM, (String)dataClass.number);
        }

        public void onFailure(GoogleJsonErrorContainer e, HttpHeaders responseHeaders) {
            ++this.failureCalls;
            GoogleJsonError error = e.getError();
            GoogleJsonError.ErrorInfo errorInfo = (GoogleJsonError.ErrorInfo)error.getErrors().get(0);
            TestCase.assertEquals((String)BatchRequestTest.ERROR_DOMAIN, (String)errorInfo.getDomain());
            TestCase.assertEquals((String)BatchRequestTest.ERROR_REASON, (String)errorInfo.getReason());
            TestCase.assertEquals((String)BatchRequestTest.ERROR_MSG, (String)errorInfo.getMessage());
            TestCase.assertEquals((int)503, (int)error.getCode());
            TestCase.assertEquals((String)BatchRequestTest.ERROR_MSG, (String)error.getMessage());
        }
    }

    private static class TestCallback1
    implements BatchCallback<MockDataClass1, GoogleJsonErrorContainer> {
        int successCalls;

        TestCallback1() {
        }

        public void onSuccess(MockDataClass1 dataClass, HttpHeaders responseHeaders) {
            ++this.successCalls;
            TestCase.assertEquals((String)BatchRequestTest.TEST_ID, (String)dataClass.id);
            TestCase.assertEquals((String)BatchRequestTest.TEST_KIND, (String)dataClass.kind);
        }

        public void onFailure(GoogleJsonErrorContainer e, HttpHeaders responseHeaders) {
            TestCase.fail((String)"Should not be invoked in this test");
        }
    }

    public static class MockDataClass2
    extends GenericJson {
        @Key
        String name;
        @Key
        String number;
    }

    public static class MockDataClass1
    extends GenericJson {
        @Key
        String id;
        @Key
        String kind;
    }
}

