/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.batch;

import com.google.api.client.googleapis.batch.BatchCallback;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BatchRequestStressTest {
    private static final int BATCH_SIZE = 100;
    public static BatchRequest batchRequest;
    private static AtomicInteger parseCount;
    private static AtomicInteger errorCount;

    @BeforeClass
    public static void setup() throws IOException {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                        response.setStatusCode(200);
                        response.addHeader("Content-Type", "multipart/mixed; boundary=__END_OF_PART__");
                        response.setContentEncoding("gzip");
                        StringBuilder responseContent = new StringBuilder();
                        for (int i = 0; i < 100; ++i) {
                            responseContent.append("--__END_OF_PART__\n").append("Content-Type: application/http\n").append("Content-ID: response-" + i + "\n\n").append("HTTP/1.1 200 OK\n").append("Content-Type: application/json\n\n").append("{}\n\n");
                        }
                        responseContent.append("--__END_OF_PART__--\n\n");
                        PipedInputStream is = new PipedInputStream();
                        PipedOutputStream os = new PipedOutputStream(is);
                        GZIPOutputStream gzip = new GZIPOutputStream(os);
                        gzip.write(responseContent.toString().getBytes("UTF-8"));
                        gzip.close();
                        response.setContent((InputStream)is);
                        return response;
                    }
                };
            }
        };
        BatchCallback<Void, Void> callback = new BatchCallback<Void, Void>(){

            public void onSuccess(Void t, HttpHeaders responseHeaders) {
                parseCount.incrementAndGet();
            }

            public void onFailure(Void e, HttpHeaders responseHeaders) {
                errorCount.incrementAndGet();
            }
        };
        batchRequest = new BatchRequest((HttpTransport)transport, null);
        byte[] content = new byte[300];
        Arrays.fill(content, (byte)32);
        HttpRequest request1 = transport.createRequestFactory().buildRequest("POST", new GenericUrl("http://www.google.com/"), (HttpContent)new ByteArrayContent(new HttpMediaType("text/plain").setCharsetParameter(Charsets.UTF_8).build(), content));
        for (int i = 0; i < 100; ++i) {
            batchRequest.queue(request1, Void.class, Void.class, (BatchCallback)callback);
        }
    }

    @Test(timeout=4000L)
    public void testResponse() throws IOException {
        batchRequest.execute();
        Assert.assertEquals((long)100L, (long)parseCount.get());
        Assert.assertEquals((long)0L, (long)errorCount.get());
    }

    static {
        parseCount = new AtomicInteger(0);
        errorCount = new AtomicInteger(0);
    }
}

