/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import junit.framework.TestCase;

public class GoogleAuthorizationCodeTokenRequestTest
extends TestCase {
    private static final String CLIENT_ID = "812741506391.apps.googleusercontent.com";
    private static final String CLIENT_SECRET = "{client_secret}";
    private static final String CODE = "4/P7q7W91a-oMsCeLvIaQm6bTrgtp7";
    private static final String REDIRECT_URI = "https://oauth2-login-demo.appspot.com/code";

    public void test() {
        GoogleAuthorizationCodeTokenRequest request = new GoogleAuthorizationCodeTokenRequest((HttpTransport)new MockHttpTransport(), (JsonFactory)new GsonFactory(), CLIENT_ID, CLIENT_SECRET, CODE, REDIRECT_URI);
        ClientParametersAuthentication clientAuthentication = (ClientParametersAuthentication)request.getClientAuthentication();
        GoogleAuthorizationCodeTokenRequestTest.assertEquals((String)CLIENT_ID, (String)clientAuthentication.getClientId());
        GoogleAuthorizationCodeTokenRequestTest.assertEquals((String)CLIENT_SECRET, (String)clientAuthentication.getClientSecret());
        GoogleAuthorizationCodeTokenRequestTest.assertEquals((String)CODE, (String)request.getCode());
        GoogleAuthorizationCodeTokenRequestTest.assertEquals((String)REDIRECT_URI, (String)request.getRedirectUri());
        GoogleAuthorizationCodeTokenRequestTest.assertEquals((String)"authorization_code", (String)request.getGrantType());
        GoogleAuthorizationCodeTokenRequestTest.assertNull((Object)request.getScopes());
        GoogleAuthorizationCodeTokenRequestTest.assertNotNull((Object)request.getTokenServerUrl());
    }
}

