/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.subscriptions;

import com.google.api.client.googleapis.batch.BatchCallback;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.subscriptions.NotificationCallback;
import com.google.api.client.googleapis.subscriptions.SubscribeResponse;
import com.google.api.client.googleapis.subscriptions.Subscription;
import com.google.api.client.googleapis.subscriptions.SubscriptionHeaders;
import com.google.api.client.googleapis.subscriptions.SubscriptionStore;
import com.google.api.client.googleapis.subscriptions.TypedNotificationCallback;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscribeRequest {
    private final HttpRequest request;
    private NotificationCallback notificationCallback;
    private SubscriptionStore subscriptionStore;
    Subscription subscription;

    public SubscribeRequest(HttpRequest request, String notificationDeliveryMethod) {
        this.request = (HttpRequest)Preconditions.checkNotNull((Object)request);
        Preconditions.checkArgument((boolean)"GET".equals(request.getRequestMethod()));
        request.setRequestMethod("POST");
        request.setContent((HttpContent)new EmptyContent());
        this.setNotificationDeliveryMethod(notificationDeliveryMethod);
        this.setSubscriptionId(UUID.randomUUID().toString());
    }

    public SubscribeRequest withNotificationCallback(final SubscriptionStore subscriptionStore, final NotificationCallback notificationCallback) {
        Preconditions.checkArgument((this.notificationCallback == null ? 1 : 0) != 0);
        this.subscriptionStore = (SubscriptionStore)Preconditions.checkNotNull((Object)subscriptionStore);
        this.notificationCallback = (NotificationCallback)Preconditions.checkNotNull((Object)notificationCallback);
        final HttpExecuteInterceptor executeInterceptor = this.request.getInterceptor();
        this.request.setInterceptor(new HttpExecuteInterceptor(){

            public void intercept(HttpRequest request) throws IOException {
                if (SubscribeRequest.this.subscription == null) {
                    SubscribeRequest.this.subscription = new Subscription(notificationCallback, SubscribeRequest.this.getClientToken(), SubscribeRequest.this.getSubscriptionId());
                    subscriptionStore.storeSubscription(SubscribeRequest.this.subscription);
                }
                if (executeInterceptor != null) {
                    executeInterceptor.intercept(request);
                }
            }
        });
        final HttpResponseInterceptor responseInterceptor = this.request.getResponseInterceptor();
        this.request.setResponseInterceptor(new HttpResponseInterceptor(){

            public void interceptResponse(HttpResponse response) throws IOException {
                HttpHeaders headers = response.getHeaders();
                Preconditions.checkArgument((boolean)SubscriptionHeaders.getSubscriptionId(headers).equals(SubscribeRequest.this.getSubscriptionId()));
                if (response.isSuccessStatusCode()) {
                    SubscribeRequest.this.subscription.processResponse(SubscriptionHeaders.getSubscriptionExpires(headers), SubscriptionHeaders.getTopicId(headers));
                    subscriptionStore.storeSubscription(SubscribeRequest.this.subscription);
                } else {
                    subscriptionStore.removeSubscription(SubscribeRequest.this.subscription);
                }
                if (responseInterceptor != null) {
                    responseInterceptor.interceptResponse(response);
                }
            }
        });
        return this;
    }

    public <N> SubscribeRequest withTypedNotificationCallback(SubscriptionStore subscriptionStore, Class<N> notificationCallbackClass, TypedNotificationCallback<N> typedNotificationCallback) {
        this.withNotificationCallback(subscriptionStore, typedNotificationCallback);
        typedNotificationCallback.setDataType(notificationCallbackClass);
        return this;
    }

    public final HttpRequest getRequest() {
        return this.request;
    }

    public final String getNotificationDeliveryMethod() {
        return SubscriptionHeaders.getSubscribe(this.request.getHeaders());
    }

    public SubscribeRequest setNotificationDeliveryMethod(String notificationDeliveryMethod) {
        SubscriptionHeaders.setSubscribe(this.request.getHeaders(), (String)Preconditions.checkNotNull((Object)notificationDeliveryMethod));
        return this;
    }

    public final NotificationCallback getNotificationCallback() {
        return this.notificationCallback;
    }

    public final SubscriptionStore getSubscriptionStore() {
        return this.subscriptionStore;
    }

    public String getClientToken() {
        return SubscriptionHeaders.getClientToken(this.request.getHeaders());
    }

    public SubscribeRequest setClientToken(String clientToken) {
        SubscriptionHeaders.setClientToken(this.request.getHeaders(), clientToken);
        return this;
    }

    public String getSubscriptionId() {
        return SubscriptionHeaders.getSubscriptionId(this.request.getHeaders());
    }

    public SubscribeRequest setSubscriptionId(String subscriptionId) {
        SubscriptionHeaders.setSubscriptionId(this.request.getHeaders(), (String)Preconditions.checkNotNull((Object)subscriptionId));
        return this;
    }

    public SubscribeResponse execute() throws IOException {
        HttpResponse response = this.request.execute();
        return new SubscribeResponse(response, this.subscription);
    }

    public final <E> void queue(BatchRequest batchRequest, Class<E> errorClass, BatchCallback<Void, E> callback) throws IOException {
        batchRequest.queue(this.request, Void.class, errorClass, callback);
    }
}

