/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.services;

import com.google.api.client.googleapis.MethodOverride;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpClient;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import java.io.IOException;
import java.util.Arrays;

public class GoogleClient
extends JsonHttpClient {
    private boolean suppressPatternChecks;

    @Deprecated
    public GoogleClient(HttpTransport transport, JsonFactory jsonFactory, String baseUrl) {
        super(transport, jsonFactory, baseUrl);
    }

    public GoogleClient(HttpTransport transport, JsonFactory jsonFactory, String rootUrl, String servicePath, HttpRequestInitializer httpRequestInitializer) {
        super(transport, jsonFactory, rootUrl, servicePath, httpRequestInitializer);
    }

    @Deprecated
    protected GoogleClient(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, JsonObjectParser jsonObjectParser, String baseUrl, String applicationName) {
        super(transport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, jsonObjectParser, baseUrl, applicationName);
    }

    @Deprecated
    protected GoogleClient(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, JsonObjectParser jsonObjectParser, String rootUrl, String servicePath, String applicationName) {
        super(transport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, jsonObjectParser, rootUrl, servicePath, applicationName);
    }

    protected GoogleClient(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, JsonObjectParser jsonObjectParser, String rootUrl, String servicePath, String applicationName, boolean suppressPatternChecks) {
        super(transport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, jsonObjectParser, rootUrl, servicePath, applicationName);
        this.suppressPatternChecks = suppressPatternChecks;
    }

    protected HttpRequest buildHttpRequest(HttpMethod method, GenericUrl url, Object body) throws IOException {
        HttpRequest httpRequest = super.buildHttpRequest(method, url, body);
        new MethodOverride().intercept(httpRequest);
        if (body == null && method.equals((Object)HttpMethod.POST)) {
            httpRequest.setContent((HttpContent)new EmptyContent());
        }
        return httpRequest;
    }

    public BatchRequest batch() {
        return this.batch(null);
    }

    public BatchRequest batch(HttpRequestInitializer httpRequestInitializer) {
        GenericUrl baseUrl;
        BatchRequest batch = new BatchRequest(this.getRequestFactory().getTransport(), httpRequestInitializer);
        if (this.isBaseUrlUsed()) {
            baseUrl = new GenericUrl(this.getBaseUrl());
            baseUrl.setPathParts(Arrays.asList("", "batch"));
        } else {
            baseUrl = new GenericUrl(this.getRootUrl() + "batch");
        }
        batch.setBatchUrl(baseUrl);
        return batch;
    }

    protected HttpResponse executeUnparsed(HttpMethod method, GenericUrl url, Object body) throws IOException {
        HttpRequest request = this.buildHttpRequest(method, url, body);
        return this.executeUnparsed(request);
    }

    protected HttpResponse executeUnparsed(HttpRequest request) throws IOException {
        return GoogleJsonResponseException.execute(this.getJsonFactory(), request);
    }

    public final boolean getSuppressPatternChecks() {
        return this.suppressPatternChecks;
    }

    public static class Builder
    extends JsonHttpClient.Builder {
        private boolean suppressPatternChecks;

        public final boolean getSuppressPatternChecks() {
            return this.suppressPatternChecks;
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            this.suppressPatternChecks = suppressPatternChecks;
            return this;
        }

        @Deprecated
        protected Builder(HttpTransport transport, JsonFactory jsonFactory, GenericUrl baseUrl) {
            super(transport, jsonFactory, baseUrl);
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, String rootUrl, String servicePath, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, rootUrl, servicePath, httpRequestInitializer);
        }

        public GoogleClient build() {
            if (this.isBaseUrlUsed()) {
                return new GoogleClient(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getObjectParser(), this.getBaseUrl().build(), this.getApplicationName());
            }
            return new GoogleClient(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getObjectParser(), this.getRootUrl(), this.getServicePath(), this.getApplicationName(), this.getSuppressPatternChecks());
        }
    }
}

