/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.media;

import com.google.api.client.googleapis.GoogleHeaders;
import com.google.api.client.googleapis.MethodOverride;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.googleapis.media.MediaUploadExponentialBackOffPolicy;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.BackOffPolicy;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.MultipartRelatedContent;
import com.google.common.base.Preconditions;
import com.google.common.io.LimitInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class MediaHttpUploader {
    private UploadState uploadState = UploadState.NOT_STARTED;
    static final int MB = 0x100000;
    private static final int KB = 1024;
    public static final int MINIMUM_CHUNK_SIZE = 262144;
    public static final int DEFAULT_CHUNK_SIZE = 0xA00000;
    private final AbstractInputStreamContent mediaContent;
    private final HttpRequestFactory requestFactory;
    private final HttpTransport transport;
    private HttpContent metadata;
    private long mediaContentLength;
    private HttpMethod initiationMethod = HttpMethod.POST;
    private GoogleHeaders initiationHeaders = new GoogleHeaders();
    private HttpRequest currentRequest;
    private InputStream contentInputStream;
    private boolean backOffPolicyEnabled = true;
    private boolean directUploadEnabled;
    private MediaHttpUploaderProgressListener progressListener;
    private long bytesUploaded;
    private int chunkSize = 0xA00000;

    public MediaHttpUploader(AbstractInputStreamContent mediaContent, HttpTransport transport, HttpRequestInitializer httpRequestInitializer) {
        this.mediaContent = (AbstractInputStreamContent)Preconditions.checkNotNull((Object)mediaContent);
        this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse upload(GenericUrl initiationRequestUrl) throws IOException {
        GenericUrl uploadUrl;
        Preconditions.checkArgument((this.uploadState == UploadState.NOT_STARTED ? 1 : 0) != 0);
        if (this.directUploadEnabled) {
            this.updateStateAndNotifyListener(UploadState.MEDIA_IN_PROGRESS);
            AbstractInputStreamContent content = this.mediaContent;
            if (this.metadata != null) {
                content = new MultipartRelatedContent(this.metadata, new HttpContent[]{this.mediaContent});
                initiationRequestUrl.put("uploadType", (Object)"multipart");
            } else {
                initiationRequestUrl.put("uploadType", (Object)"media");
            }
            HttpRequest request = this.requestFactory.buildRequest(this.initiationMethod, initiationRequestUrl, (HttpContent)content);
            request.setEnableGZipContent(true);
            this.addMethodOverride(request);
            HttpResponse response = request.execute();
            boolean responseProcessed = false;
            try {
                this.bytesUploaded = this.getMediaContentLength();
                this.updateStateAndNotifyListener(UploadState.MEDIA_COMPLETE);
                responseProcessed = true;
            }
            finally {
                if (!responseProcessed) {
                    response.disconnect();
                }
            }
            return response;
        }
        HttpResponse initialResponse = this.executeUploadInitiation(initiationRequestUrl);
        try {
            uploadUrl = new GenericUrl(initialResponse.getHeaders().getLocation());
        }
        finally {
            initialResponse.disconnect();
        }
        this.contentInputStream = this.mediaContent.getInputStream();
        if (!this.contentInputStream.markSupported()) {
            this.contentInputStream = new BufferedInputStream(this.contentInputStream);
        }
        while (true) {
            this.currentRequest = this.requestFactory.buildPutRequest(uploadUrl, null);
            new MethodOverride().intercept(this.currentRequest);
            this.setContentAndHeadersOnCurrentRequest(this.bytesUploaded);
            if (this.backOffPolicyEnabled) {
                this.currentRequest.setBackOffPolicy((BackOffPolicy)new MediaUploadExponentialBackOffPolicy(this));
            }
            this.currentRequest.setThrowExceptionOnExecuteError(false);
            this.currentRequest.setRetryOnExecuteIOException(true);
            HttpResponse response = this.currentRequest.execute();
            boolean returningResponse = false;
            try {
                HttpResponse httpResponse;
                if (response.isSuccessStatusCode()) {
                    this.bytesUploaded = this.mediaContentLength;
                    this.contentInputStream.close();
                    this.updateStateAndNotifyListener(UploadState.MEDIA_COMPLETE);
                    returningResponse = true;
                    httpResponse = response;
                    return httpResponse;
                }
                if (response.getStatusCode() != 308) {
                    returningResponse = true;
                    httpResponse = response;
                    return httpResponse;
                }
                String updatedUploadUrl = response.getHeaders().getLocation();
                if (updatedUploadUrl != null) {
                    uploadUrl = new GenericUrl(updatedUploadUrl);
                }
                this.bytesUploaded = this.getNextByteIndex(response.getHeaders().getRange());
                this.updateStateAndNotifyListener(UploadState.MEDIA_IN_PROGRESS);
                continue;
            }
            finally {
                if (returningResponse) continue;
                response.disconnect();
                continue;
            }
            break;
        }
    }

    private long getMediaContentLength() throws IOException {
        if (this.mediaContentLength == 0L) {
            this.mediaContentLength = this.mediaContent.getLength();
            Preconditions.checkArgument((this.mediaContentLength != -1L ? 1 : 0) != 0);
        }
        return this.mediaContentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeUploadInitiation(GenericUrl initiationRequestUrl) throws IOException {
        this.updateStateAndNotifyListener(UploadState.INITIATION_STARTED);
        initiationRequestUrl.put("uploadType", (Object)"resumable");
        EmptyContent content = this.metadata == null ? new EmptyContent() : this.metadata;
        HttpRequest request = this.requestFactory.buildRequest(this.initiationMethod, initiationRequestUrl, (HttpContent)content);
        this.addMethodOverride(request);
        this.initiationHeaders.setUploadContentType(this.mediaContent.getType());
        this.initiationHeaders.setUploadContentLength(this.getMediaContentLength());
        request.setHeaders((HttpHeaders)this.initiationHeaders);
        request.setRetryOnExecuteIOException(true);
        request.setEnableGZipContent(true);
        HttpResponse response = request.execute();
        boolean notificationCompleted = false;
        try {
            this.updateStateAndNotifyListener(UploadState.INITIATION_COMPLETE);
            notificationCompleted = true;
        }
        finally {
            if (!notificationCompleted) {
                response.disconnect();
            }
        }
        return response;
    }

    private void addMethodOverride(HttpRequest request) {
        new MethodOverride().intercept(request);
    }

    private void setContentAndHeadersOnCurrentRequest(long bytesWritten) throws IOException {
        int blockSize = (int)Math.min((long)this.chunkSize, this.getMediaContentLength() - bytesWritten);
        InputStreamContent contentChunk = new InputStreamContent(this.mediaContent.getType(), (InputStream)new LimitInputStream(this.contentInputStream, (long)blockSize));
        contentChunk.setCloseInputStream(false);
        contentChunk.setRetrySupported(true);
        contentChunk.setLength((long)blockSize);
        this.contentInputStream.mark(blockSize);
        this.currentRequest.setContent((HttpContent)contentChunk);
        this.currentRequest.getHeaders().setContentRange("bytes " + bytesWritten + "-" + (bytesWritten + (long)blockSize - 1L) + "/" + this.getMediaContentLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverErrorCallback() throws IOException {
        Preconditions.checkNotNull((Object)this.currentRequest, (Object)"The current request should not be null");
        HttpRequest request = this.requestFactory.buildPutRequest(this.currentRequest.getUrl(), null);
        new MethodOverride().intercept(request);
        request.getHeaders().setContentRange("bytes */" + this.getMediaContentLength());
        request.setThrowExceptionOnExecuteError(false);
        request.setRetryOnExecuteIOException(true);
        HttpResponse response = request.execute();
        try {
            long bytesWritten = this.getNextByteIndex(response.getHeaders().getRange());
            String updatedUploadUrl = response.getHeaders().getLocation();
            if (updatedUploadUrl != null) {
                this.currentRequest.setUrl(new GenericUrl(updatedUploadUrl));
            }
            this.contentInputStream.reset();
            long skipValue = this.bytesUploaded - bytesWritten;
            long actualSkipValue = this.contentInputStream.skip(skipValue);
            Preconditions.checkState((skipValue == actualSkipValue ? 1 : 0) != 0);
            this.setContentAndHeadersOnCurrentRequest(bytesWritten);
        }
        finally {
            response.disconnect();
        }
    }

    private long getNextByteIndex(String rangeHeader) {
        if (rangeHeader == null) {
            return 0L;
        }
        return Long.parseLong(rangeHeader.substring(rangeHeader.indexOf(45) + 1)) + 1L;
    }

    public HttpContent getMetadata() {
        return this.metadata;
    }

    public MediaHttpUploader setMetadata(HttpContent metadata) {
        this.metadata = metadata;
        return this;
    }

    public HttpContent getMediaContent() {
        return this.mediaContent;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public MediaHttpUploader setBackOffPolicyEnabled(boolean backOffPolicyEnabled) {
        this.backOffPolicyEnabled = backOffPolicyEnabled;
        return this;
    }

    public boolean isBackOffPolicyEnabled() {
        return this.backOffPolicyEnabled;
    }

    public MediaHttpUploader setDirectUploadEnabled(boolean directUploadEnabled) {
        this.directUploadEnabled = directUploadEnabled;
        return this;
    }

    public boolean isDirectUploadEnabled() {
        return this.directUploadEnabled;
    }

    public MediaHttpUploader setProgressListener(MediaHttpUploaderProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public MediaHttpUploaderProgressListener getProgressListener() {
        return this.progressListener;
    }

    public MediaHttpUploader setChunkSize(int chunkSize) {
        Preconditions.checkArgument((chunkSize >= 262144 ? 1 : 0) != 0);
        this.chunkSize = chunkSize;
        return this;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public MediaHttpUploader setInitiationMethod(HttpMethod initiationMethod) {
        Preconditions.checkArgument((initiationMethod == HttpMethod.POST || initiationMethod == HttpMethod.PUT ? 1 : 0) != 0);
        this.initiationMethod = initiationMethod;
        return this;
    }

    public HttpMethod getInitiationMethod() {
        return this.initiationMethod;
    }

    public MediaHttpUploader setInitiationHeaders(GoogleHeaders initiationHeaders) {
        this.initiationHeaders = initiationHeaders;
        return this;
    }

    public GoogleHeaders getInitiationHeaders() {
        return this.initiationHeaders;
    }

    public long getNumBytesUploaded() {
        return this.bytesUploaded;
    }

    private void updateStateAndNotifyListener(UploadState uploadState) throws IOException {
        this.uploadState = uploadState;
        if (this.progressListener != null) {
            this.progressListener.progressChanged(this);
        }
    }

    public UploadState getUploadState() {
        return this.uploadState;
    }

    public double getProgress() throws IOException {
        return (double)this.bytesUploaded / (double)this.getMediaContentLength();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UploadState {
        NOT_STARTED,
        INITIATION_STARTED,
        INITIATION_COMPLETE,
        MEDIA_IN_PROGRESS,
        MEDIA_COMPLETE;

    }
}

