/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import java.util.Collections;

public class GoogleAuthorizationCodeFlow
extends AuthorizationCodeFlow {
    private final String approvalPrompt;
    private final String accessType;

    protected GoogleAuthorizationCodeFlow(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl, CredentialStore credentialStore, HttpRequestInitializer requestInitializer, String scopes, String accessType, String approvalPrompt) {
        super(method, transport, jsonFactory, tokenServerUrl, clientAuthentication, clientId, authorizationServerEncodedUrl, credentialStore, requestInitializer, scopes);
        this.accessType = accessType;
        this.approvalPrompt = approvalPrompt;
    }

    public GoogleAuthorizationCodeTokenRequest newTokenRequest(String authorizationCode) {
        return new GoogleAuthorizationCodeTokenRequest(this.getTransport(), this.getJsonFactory(), "", "", authorizationCode, "").setClientAuthentication(this.getClientAuthentication()).setRequestInitializer(this.getRequestInitializer()).setScopes(this.getScopes());
    }

    public GoogleAuthorizationCodeRequestUrl newAuthorizationUrl() {
        return new GoogleAuthorizationCodeRequestUrl(this.getClientId(), "", Collections.singleton(this.getScopes())).setAccessType(this.accessType).setApprovalPrompt(this.approvalPrompt);
    }

    public final String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public final String getAccessType() {
        return this.accessType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AuthorizationCodeFlow.Builder {
        private String approvalPrompt;
        private String accessType;

        public Builder(HttpTransport transport, JsonFactory jsonFactory, String clientId, String clientSecret, Iterable<String> scopes) {
            super(BearerToken.authorizationHeaderAccessMethod(), transport, jsonFactory, new GenericUrl("https://accounts.google.com/o/oauth2/token"), (HttpExecuteInterceptor)new ClientParametersAuthentication(clientId, clientSecret), clientId, "https://accounts.google.com/o/oauth2/auth");
            this.setScopes((Iterable)Preconditions.checkNotNull(scopes));
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, GoogleClientSecrets clientSecrets, Iterable<String> scopes) {
            super(BearerToken.authorizationHeaderAccessMethod(), transport, jsonFactory, new GenericUrl("https://accounts.google.com/o/oauth2/token"), (HttpExecuteInterceptor)new ClientParametersAuthentication(clientSecrets.getDetails().getClientId(), clientSecrets.getDetails().getClientSecret()), clientSecrets.getDetails().getClientId(), "https://accounts.google.com/o/oauth2/auth");
            this.setScopes((Iterable)Preconditions.checkNotNull(scopes));
        }

        public GoogleAuthorizationCodeFlow build() {
            return new GoogleAuthorizationCodeFlow(this.getMethod(), this.getTransport(), this.getJsonFactory(), this.getTokenServerUrl(), this.getClientAuthentication(), this.getClientId(), this.getAuthorizationServerEncodedUrl(), this.getCredentialStore(), this.getRequestInitializer(), this.getScopes(), this.accessType, this.approvalPrompt);
        }

        public Builder setCredentialStore(CredentialStore credentialStore) {
            return (Builder)super.setCredentialStore(credentialStore);
        }

        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            return (Builder)super.setRequestInitializer(requestInitializer);
        }

        public Builder setScopes(Iterable<String> scopes) {
            return (Builder)super.setScopes(scopes);
        }

        public Builder setScopes(String ... scopes) {
            return (Builder)super.setScopes(scopes);
        }

        public Builder setApprovalPrompt(String approvalPrompt) {
            this.approvalPrompt = approvalPrompt;
            return this;
        }

        public final String getApprovalPrompt() {
            return this.approvalPrompt;
        }

        public Builder setAccessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        public final String getAccessType() {
            return this.accessType;
        }
    }
}

