/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.servlet.subscriptions;

import com.google.api.client.googleapis.subscriptions.SubscriptionStore;
import com.google.api.client.googleapis.subscriptions.UnparsedNotification;
import com.google.api.client.util.Beta;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Beta
public abstract class AbstractWebHookServlet
extends HttpServlet {
    public static final String UNSUBSCRIBE_HEADER = "X-Goog-Unsubscribe";
    private static SubscriptionStore subscriptionStore;

    protected abstract SubscriptionStore createSubscriptionStore();

    public final synchronized SubscriptionStore getSubscriptionStore() {
        if (subscriptionStore == null) {
            subscriptionStore = this.createSubscriptionStore();
        }
        return subscriptionStore;
    }

    protected void sendUnsubscribeResponse(HttpServletResponse resp, UnparsedNotification notification) {
        resp.setStatus(200);
        resp.setHeader(UNSUBSCRIBE_HEADER, notification.getSubscriptionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String subscriptionId = req.getHeader("X-Goog-Subscription-ID");
        String topicId = req.getHeader("X-Goog-Topic-ID");
        String topicUri = req.getHeader("X-Goog-Topic-URI");
        String eventType = req.getHeader("X-Goog-Event-Type");
        String clientToken = req.getHeader("X-Goog-Client-Token");
        String messageNumber = req.getHeader("X-Goog-Message-Number");
        String changeType = req.getHeader("X-Goog-Changed");
        if (subscriptionId == null || topicId == null || topicUri == null || eventType == null || messageNumber == null) {
            resp.sendError(400, "Notification did not contain all required information.");
            return;
        }
        ServletInputStream contentStream = req.getInputStream();
        try {
            UnparsedNotification notification = new UnparsedNotification(subscriptionId, topicId, topicUri, clientToken, Long.valueOf(messageNumber).longValue(), eventType, changeType, req.getContentType(), (InputStream)contentStream);
            if (!notification.deliverNotification(this.getSubscriptionStore())) {
                this.sendUnsubscribeResponse(resp, notification);
            }
        }
        finally {
            contentStream.close();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }
}

