/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.servlet.subscriptions;

import com.google.api.client.http.GenericUrl;
import com.google.common.base.Preconditions;

public class WebHookDeliveryMethod {
    private GenericUrl url;

    public WebHookDeliveryMethod(String callbackURL) {
        Preconditions.checkArgument((boolean)new GenericUrl(callbackURL).getScheme().equalsIgnoreCase("https"), (Object)"Callback scheme has to be https://");
        GenericUrl url = new GenericUrl("http://example.com/web_hook");
        url.set("url", (Object)callbackURL);
        this.url = url;
    }

    public final GenericUrl getUrl() {
        return this.url;
    }

    public final String build() {
        return this.url.buildRelativeUrl().substring("/".length());
    }

    public final String getHost() {
        return (String)this.url.get((Object)"host");
    }

    public WebHookDeliveryMethod setHost(String host) {
        this.url.set("host", (Object)host);
        return this;
    }

    public final boolean isPayloadRequested() {
        return Boolean.valueOf((String)this.url.get((Object)"invalidate")) == false;
    }

    public WebHookDeliveryMethod setPayloadRequested(boolean isPayloadRequested) {
        this.url.set("invalidate", (Object)String.valueOf(!isPayloadRequested));
        return this;
    }
}

