/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.auth.helpers.oauth;

import com.google.api.client.auth.oauth.OAuthCredentialsResponse;
import com.google.api.client.auth.oauth.OAuthHmacSigner;
import com.google.api.client.extensions.auth.helpers.Credential;
import com.google.api.client.extensions.auth.helpers.ThreeLeggedFlow;
import com.google.api.client.extensions.auth.helpers.oauth.OAuthHmacCredential;
import com.google.api.client.googleapis.auth.oauth.GoogleOAuthAuthorizeTemporaryTokenUrl;
import com.google.api.client.googleapis.auth.oauth.GoogleOAuthGetAccessToken;
import com.google.api.client.googleapis.auth.oauth.GoogleOAuthGetTemporaryToken;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;

@javax.jdo.annotations.PersistenceCapable
public class GoogleOAuthHmacThreeLeggedFlow
implements ThreeLeggedFlow,
PersistenceCapable {
    @PrimaryKey
    private String userId;
    @Persistent
    private String tempToken;
    @Persistent
    private String tempTokenSecret;
    @Persistent
    private String consumerSecret;
    @Persistent
    private String consumerKey;
    @Persistent
    private final String authorizationUrl;
    @NotPersistent
    private HttpTransport transport;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public GoogleOAuthHmacThreeLeggedFlow(String userId, String consumerKey, String consumerSecret, String scope, String xoauthDisplayname, String callbackUrl, HttpTransport transport) throws IOException {
        this.userId = userId;
        this.consumerSecret = consumerSecret;
        this.consumerKey = consumerKey;
        this.transport = transport;
        GoogleOAuthGetTemporaryToken temporaryToken = new GoogleOAuthGetTemporaryToken();
        OAuthHmacSigner signer = new OAuthHmacSigner();
        signer.clientSharedSecret = consumerSecret;
        temporaryToken.signer = signer;
        temporaryToken.consumerKey = consumerKey;
        temporaryToken.scope = scope;
        temporaryToken.displayName = xoauthDisplayname;
        temporaryToken.callback = callbackUrl;
        temporaryToken.transport = this.transport;
        OAuthCredentialsResponse tempCredentials = temporaryToken.execute();
        this.tempToken = tempCredentials.token;
        this.tempTokenSecret = tempCredentials.tokenSecret;
        GoogleOAuthAuthorizeTemporaryTokenUrl authorizeUrl = new GoogleOAuthAuthorizeTemporaryTokenUrl();
        authorizeUrl.temporaryToken = tempCredentials.token;
        this.authorizationUrl = authorizeUrl.build();
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public Credential complete(String authorizationCode) throws IOException {
        Preconditions.checkNotNull((Object)this.transport, (Object)"Must call setHttpTransport before calling complete.");
        GoogleOAuthGetAccessToken accessToken = new GoogleOAuthGetAccessToken();
        accessToken.temporaryToken = GoogleOAuthHmacThreeLeggedFlow.jdoGettempToken(this);
        accessToken.transport = this.transport;
        OAuthHmacSigner signer = new OAuthHmacSigner();
        signer.clientSharedSecret = GoogleOAuthHmacThreeLeggedFlow.jdoGetconsumerSecret(this);
        signer.tokenSharedSecret = GoogleOAuthHmacThreeLeggedFlow.jdoGettempTokenSecret(this);
        accessToken.signer = signer;
        accessToken.consumerKey = GoogleOAuthHmacThreeLeggedFlow.jdoGetconsumerKey(this);
        accessToken.verifier = authorizationCode;
        OAuthCredentialsResponse credentials = accessToken.execute();
        signer.tokenSharedSecret = credentials.tokenSecret;
        OAuthHmacCredential accessCredential = new OAuthHmacCredential(GoogleOAuthHmacThreeLeggedFlow.jdoGetuserId(this), GoogleOAuthHmacThreeLeggedFlow.jdoGetconsumerKey(this), GoogleOAuthHmacThreeLeggedFlow.jdoGetconsumerSecret(this), credentials.tokenSecret, credentials.token);
        return accessCredential;
    }

    public Credential loadCredential(PersistenceManager pm) {
        try {
            return (Credential)pm.getObjectById(OAuthHmacCredential.class, (Object)GoogleOAuthHmacThreeLeggedFlow.jdoGetuserId(this));
        }
        catch (JDOObjectNotFoundException e) {
            return null;
        }
    }

    public void setHttpTransport(HttpTransport transport) {
        this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
    }

    public void setJsonFactory(JsonFactory jsonFactory) {
    }

    static {
        jdoFieldNames = GoogleOAuthHmacThreeLeggedFlow.__jdoFieldNamesInit();
        jdoFieldTypes = GoogleOAuthHmacThreeLeggedFlow.__jdoFieldTypesInit();
        jdoFieldFlags = GoogleOAuthHmacThreeLeggedFlow.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = GoogleOAuthHmacThreeLeggedFlow.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = GoogleOAuthHmacThreeLeggedFlow.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)GoogleOAuthHmacThreeLeggedFlow.___jdo$loadClass("com.google.api.client.googleapis.extensions.auth.helpers.oauth.GoogleOAuthHmacThreeLeggedFlow"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new GoogleOAuthHmacThreeLeggedFlow());
    }

    protected GoogleOAuthHmacThreeLeggedFlow() {
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(4, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.userId = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        return null;
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        return null;
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        return false;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.userId);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public boolean jdoIsDetached() {
        return false;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        GoogleOAuthHmacThreeLeggedFlow result = new GoogleOAuthHmacThreeLeggedFlow();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        GoogleOAuthHmacThreeLeggedFlow result = new GoogleOAuthHmacThreeLeggedFlow();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.consumerKey = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.consumerSecret = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.tempToken = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.tempTokenSecret = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.userId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.consumerKey);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.consumerSecret);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.tempToken);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.tempTokenSecret);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.userId);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(GoogleOAuthHmacThreeLeggedFlow obj, int index) {
        switch (index) {
            case 0: {
                this.consumerKey = obj.consumerKey;
                break;
            }
            case 1: {
                this.consumerSecret = obj.consumerSecret;
                break;
            }
            case 2: {
                this.tempToken = obj.tempToken;
                break;
            }
            case 3: {
                this.tempTokenSecret = obj.tempTokenSecret;
                break;
            }
            case 4: {
                this.userId = obj.userId;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof GoogleOAuthHmacThreeLeggedFlow)) {
            throw new IllegalArgumentException("object is not an object of type com.google.api.client.googleapis.extensions.auth.helpers.oauth.GoogleOAuthHmacThreeLeggedFlow");
        }
        GoogleOAuthHmacThreeLeggedFlow other = (GoogleOAuthHmacThreeLeggedFlow)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"consumerKey", "consumerSecret", "tempToken", "tempTokenSecret", "userId"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{GoogleOAuthHmacThreeLeggedFlow.___jdo$loadClass("java.lang.String"), GoogleOAuthHmacThreeLeggedFlow.___jdo$loadClass("java.lang.String"), GoogleOAuthHmacThreeLeggedFlow.___jdo$loadClass("java.lang.String"), GoogleOAuthHmacThreeLeggedFlow.___jdo$loadClass("java.lang.String"), GoogleOAuthHmacThreeLeggedFlow.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 24};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 5;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        GoogleOAuthHmacThreeLeggedFlow o = (GoogleOAuthHmacThreeLeggedFlow)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetconsumerKey(GoogleOAuthHmacThreeLeggedFlow objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.consumerKey);
        }
        return objPC.consumerKey;
    }

    private static void jdoSetconsumerKey(GoogleOAuthHmacThreeLeggedFlow objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.consumerKey, val);
        } else {
            objPC.consumerKey = val;
        }
    }

    private static String jdoGetconsumerSecret(GoogleOAuthHmacThreeLeggedFlow objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.consumerSecret);
        }
        return objPC.consumerSecret;
    }

    private static void jdoSetconsumerSecret(GoogleOAuthHmacThreeLeggedFlow objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.consumerSecret, val);
        } else {
            objPC.consumerSecret = val;
        }
    }

    private static String jdoGettempToken(GoogleOAuthHmacThreeLeggedFlow objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.tempToken);
        }
        return objPC.tempToken;
    }

    private static void jdoSettempToken(GoogleOAuthHmacThreeLeggedFlow objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.tempToken, val);
        } else {
            objPC.tempToken = val;
        }
    }

    private static String jdoGettempTokenSecret(GoogleOAuthHmacThreeLeggedFlow objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.tempTokenSecret);
        }
        return objPC.tempTokenSecret;
    }

    private static void jdoSettempTokenSecret(GoogleOAuthHmacThreeLeggedFlow objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.tempTokenSecret, val);
        } else {
            objPC.tempTokenSecret = val;
        }
    }

    private static String jdoGetuserId(GoogleOAuthHmacThreeLeggedFlow objPC) {
        return objPC.userId;
    }

    private static void jdoSetuserId(GoogleOAuthHmacThreeLeggedFlow objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.userId = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.userId, val);
        }
    }
}

