/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.appengine.auth.oauth2;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppIdentityCredential
implements HttpRequestInitializer,
HttpExecuteInterceptor {
    private final AppIdentityService appIdentityService;
    private final ImmutableList<String> scopes;

    public AppIdentityCredential(Iterable<String> scopes) {
        this(AppIdentityServiceFactory.getAppIdentityService(), (List<String>)ImmutableList.copyOf(scopes));
    }

    public AppIdentityCredential(String ... scopes) {
        this(AppIdentityServiceFactory.getAppIdentityService(), (List<String>)ImmutableList.copyOf((Object[])scopes));
    }

    protected AppIdentityCredential(AppIdentityService appIdentityService, List<String> scopes) {
        this.appIdentityService = (AppIdentityService)Preconditions.checkNotNull((Object)appIdentityService);
        this.scopes = ImmutableList.copyOf(scopes);
    }

    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor((HttpExecuteInterceptor)this);
    }

    public void intercept(HttpRequest request) throws IOException {
        String accessToken = this.appIdentityService.getAccessToken(this.scopes).getAccessToken();
        BearerToken.authorizationHeaderAccessMethod().intercept(request, accessToken);
    }

    public final AppIdentityService getAppIdentityService() {
        return this.appIdentityService;
    }

    public final List<String> getScopes() {
        return this.scopes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private AppIdentityService appIdentityService;
        private final ImmutableList<String> scopes;

        public Builder(Iterable<String> scopes) {
            this.scopes = ImmutableList.copyOf(scopes);
        }

        public Builder(String ... scopes) {
            this.scopes = ImmutableList.copyOf((Object[])scopes);
        }

        public Builder setAppIdentityService(AppIdentityService appIdentityService) {
            this.appIdentityService = (AppIdentityService)Preconditions.checkNotNull((Object)appIdentityService);
            return this;
        }

        public AppIdentityCredential build() {
            AppIdentityService appIdentityService = this.appIdentityService;
            if (appIdentityService == null) {
                appIdentityService = AppIdentityServiceFactory.getAppIdentityService();
            }
            return new AppIdentityCredential(appIdentityService, (List<String>)this.scopes);
        }
    }
}

