/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.android.gms.auth;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.common.AccountPicker;
import com.google.api.client.googleapis.extensions.android.accounts.GoogleAccountManager;
import com.google.api.client.googleapis.extensions.android.gms.auth.GoogleAuthIOException;
import com.google.api.client.googleapis.extensions.android.gms.auth.GooglePlayServicesAvailabilityIOException;
import com.google.api.client.googleapis.extensions.android.gms.auth.UserRecoverableAuthIOException;
import com.google.api.client.http.ExponentialBackOffPolicy;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.Preconditions;
import java.io.IOException;

public class GoogleAccountCredential
implements HttpRequestInitializer {
    final Context context;
    final String scope;
    private final GoogleAccountManager accountManager;
    private String accountName;
    private Account selectedAccount;

    public GoogleAccountCredential(Context context, String scope) {
        this.accountManager = new GoogleAccountManager(context);
        this.context = context;
        this.scope = scope;
    }

    public static GoogleAccountCredential usingOAuth2(Context context, String scope, String ... extraScopes) {
        StringBuilder scopeBuilder = new StringBuilder("oauth2:").append(scope);
        for (String extraScope : extraScopes) {
            scopeBuilder.append(' ').append(extraScope);
        }
        return new GoogleAccountCredential(context, scopeBuilder.toString());
    }

    public static GoogleAccountCredential usingAudience(Context context, String audience) {
        Preconditions.checkArgument((audience.length() != 0 ? 1 : 0) != 0);
        return new GoogleAccountCredential(context, "audience:" + audience);
    }

    public final GoogleAccountCredential setSelectedAccountName(String accountName) {
        this.selectedAccount = this.accountManager.getAccountByName(accountName);
        this.accountName = this.selectedAccount == null ? null : accountName;
        return this;
    }

    public void initialize(HttpRequest request) {
        RequestHandler handler = new RequestHandler();
        request.setInterceptor((HttpExecuteInterceptor)handler);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)handler);
    }

    public final Context getContext() {
        return this.context;
    }

    public final String getScope() {
        return this.scope;
    }

    public final GoogleAccountManager getGoogleAccountManager() {
        return this.accountManager;
    }

    public final Account[] getAllAccounts() {
        return this.accountManager.getAccounts();
    }

    public final Account getSelectedAccount() {
        return this.selectedAccount;
    }

    public final String getSelectedAccountName() {
        return this.accountName;
    }

    public final Intent newChooseAccountIntent() {
        return AccountPicker.newChooseAccountIntent((Account)this.selectedAccount, null, (String[])new String[]{"com.google"}, (boolean)true, null, null, null, null);
    }

    public final String getToken() throws IOException, GoogleAuthException {
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        while (true) {
            try {
                return GoogleAuthUtil.getToken((Context)this.context, (String)this.accountName, (String)this.scope);
            }
            catch (IOException e) {
                long backOffMillis = backOffPolicy.getNextBackOffMillis();
                if (backOffMillis == -1L) {
                    throw e;
                }
                try {
                    Thread.sleep(backOffMillis);
                }
                catch (InterruptedException e2) {
                }
                continue;
            }
            break;
        }
    }

    class RequestHandler
    implements HttpExecuteInterceptor,
    HttpUnsuccessfulResponseHandler {
        boolean received401;
        String token;

        RequestHandler() {
        }

        public void intercept(HttpRequest request) throws IOException {
            try {
                this.token = GoogleAccountCredential.this.getToken();
                request.getHeaders().setAuthorization("Bearer " + this.token);
            }
            catch (GooglePlayServicesAvailabilityException e) {
                throw new GooglePlayServicesAvailabilityIOException(e);
            }
            catch (UserRecoverableAuthException e) {
                throw new UserRecoverableAuthIOException(e);
            }
            catch (GoogleAuthException e) {
                throw new GoogleAuthIOException(e);
            }
        }

        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) {
            if (response.getStatusCode() == 401 && !this.received401) {
                this.received401 = true;
                GoogleAuthUtil.invalidateToken((Context)GoogleAccountCredential.this.context, (String)this.token);
                return true;
            }
            return false;
        }
    }
}

