/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.admanager.axis.v202311;

import com.google.api.ads.admanager.axis.v202311.NetworkService;
import com.google.api.ads.admanager.axis.v202311.NetworkServiceInterface;
import com.google.api.ads.admanager.axis.v202311.NetworkServiceSoapBindingStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class NetworkServiceLocator
extends Service
implements NetworkService {
    private String NetworkServiceInterfacePort_address = "https://ads.google.com/apis/ads/publisher/v202311/NetworkService";
    private String NetworkServiceInterfacePortWSDDServiceName = "NetworkServiceInterfacePort";
    private HashSet ports = null;

    public NetworkServiceLocator() {
    }

    public NetworkServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public NetworkServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getNetworkServiceInterfacePortAddress() {
        return this.NetworkServiceInterfacePort_address;
    }

    public String getNetworkServiceInterfacePortWSDDServiceName() {
        return this.NetworkServiceInterfacePortWSDDServiceName;
    }

    public void setNetworkServiceInterfacePortWSDDServiceName(String name) {
        this.NetworkServiceInterfacePortWSDDServiceName = name;
    }

    @Override
    public NetworkServiceInterface getNetworkServiceInterfacePort() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.NetworkServiceInterfacePort_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getNetworkServiceInterfacePort(endpoint);
    }

    @Override
    public NetworkServiceInterface getNetworkServiceInterfacePort(URL portAddress) throws ServiceException {
        try {
            NetworkServiceSoapBindingStub _stub = new NetworkServiceSoapBindingStub(portAddress, this);
            _stub.setPortName(this.getNetworkServiceInterfacePortWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setNetworkServiceInterfacePortEndpointAddress(String address) {
        this.NetworkServiceInterfacePort_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (NetworkServiceInterface.class.isAssignableFrom(serviceEndpointInterface)) {
                NetworkServiceSoapBindingStub _stub = new NetworkServiceSoapBindingStub(new URL(this.NetworkServiceInterfacePort_address), this);
                _stub.setPortName(this.getNetworkServiceInterfacePortWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("NetworkServiceInterfacePort".equals(inputPortName)) {
            return this.getNetworkServiceInterfacePort();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("https://www.google.com/apis/ads/publisher/v202311", "NetworkService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("https://www.google.com/apis/ads/publisher/v202311", "NetworkServiceInterfacePort"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"NetworkServiceInterfacePort".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setNetworkServiceInterfacePortEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

