/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.admanager.axis.utils.v202311;

import com.google.api.ads.admanager.axis.utils.v202311.DateTimes;
import com.google.api.ads.admanager.axis.v202311.BooleanValue;
import com.google.api.ads.admanager.axis.v202311.ColumnType;
import com.google.api.ads.admanager.axis.v202311.Date;
import com.google.api.ads.admanager.axis.v202311.DateTime;
import com.google.api.ads.admanager.axis.v202311.DateTimeValue;
import com.google.api.ads.admanager.axis.v202311.DateValue;
import com.google.api.ads.admanager.axis.v202311.NumberValue;
import com.google.api.ads.admanager.axis.v202311.ResultSet;
import com.google.api.ads.admanager.axis.v202311.Row;
import com.google.api.ads.admanager.axis.v202311.SetValue;
import com.google.api.ads.admanager.axis.v202311.Targeting;
import com.google.api.ads.admanager.axis.v202311.TargetingValue;
import com.google.api.ads.admanager.axis.v202311.TextValue;
import com.google.api.ads.admanager.axis.v202311.Value;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

public final class Pql {
    private Pql() {
    }

    public static Value createValue(Object value) {
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value == null) {
            return new TextValue();
        }
        if (value instanceof Boolean) {
            BooleanValue booleanValue = new BooleanValue();
            booleanValue.setValue((Boolean)value);
            return booleanValue;
        }
        if (value instanceof Double || value instanceof Long || value instanceof Integer) {
            NumberValue numberValue = new NumberValue();
            numberValue.setValue(value.toString());
            return numberValue;
        }
        if (value instanceof String) {
            TextValue textValue = new TextValue();
            textValue.setValue((String)value);
            return textValue;
        }
        if (value instanceof DateTime) {
            DateTimeValue dateTimeValue = new DateTimeValue();
            dateTimeValue.setValue((DateTime)value);
            return dateTimeValue;
        }
        if (value instanceof Date) {
            DateValue dateValue = new DateValue();
            dateValue.setValue((Date)value);
            return dateValue;
        }
        if (value instanceof Targeting) {
            TargetingValue targetingValue = new TargetingValue();
            targetingValue.setValue((Targeting)value);
            return targetingValue;
        }
        if (value instanceof Set) {
            SetValue setValue = new SetValue();
            LinkedHashSet<Value> values = new LinkedHashSet<Value>();
            for (Object entry : (Set)value) {
                Pql.validateSetValueEntryForSet(Pql.createValue(entry), values);
                values.add(Pql.createValue(entry));
            }
            setValue.setValues(values.toArray(new Value[0]));
            return setValue;
        }
        throw new IllegalArgumentException("Unsupported Value type [" + value.getClass() + "]");
    }

    private static void validateSetValueEntryForSet(Object entry, Set<?> set) {
        Object existingEntry;
        if (entry instanceof Set || entry instanceof SetValue) {
            throw new IllegalArgumentException("Unsupported Value type [nested sets]");
        }
        if (!set.isEmpty() && !(existingEntry = set.iterator().next()).getClass().isAssignableFrom(entry.getClass())) {
            throw new IllegalArgumentException(String.format("Unsupported Value type [SetValue with mixed types %s and %s]", existingEntry.getClass(), entry.getClass()));
        }
    }

    public static String toString(Value value) {
        Object unwrappedValue = Pql.getCsvValue(value);
        if (unwrappedValue == null) {
            return "";
        }
        return unwrappedValue.toString();
    }

    public static Object getApiValue(Value value) {
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).getValue();
        }
        if (value instanceof NumberValue) {
            if (Strings.isNullOrEmpty((String)((NumberValue)value).getValue())) {
                return null;
            }
            try {
                return NumberFormat.getInstance().parse(((NumberValue)value).getValue());
            }
            catch (ParseException e) {
                throw new IllegalStateException("Received invalid number format from API: " + ((NumberValue)value).getValue());
            }
        }
        if (value instanceof TextValue) {
            return ((TextValue)value).getValue();
        }
        if (value instanceof DateTimeValue) {
            return ((DateTimeValue)value).getValue();
        }
        if (value instanceof DateValue) {
            return ((DateValue)value).getValue();
        }
        if (value instanceof TargetingValue) {
            return ((TargetingValue)value).getValue();
        }
        if (value instanceof SetValue) {
            Value[] setValues = ((SetValue)value).getValues();
            LinkedHashSet<Object> apiValue = new LinkedHashSet<Object>();
            if (setValues != null) {
                for (Value setValue : setValues) {
                    Pql.validateSetValueEntryForSet(Pql.getApiValue(setValue), apiValue);
                    apiValue.add(Pql.getApiValue(setValue));
                }
            }
            return apiValue;
        }
        throw new IllegalArgumentException("Unsupported Value type [" + value.getClass() + "]");
    }

    public static Object getNativeValue(Value value) {
        return Pql.getNativeValue(Pql.getApiValue(value));
    }

    private static Object getNativeValue(Object apiValue) {
        if (apiValue == null) {
            return null;
        }
        if (apiValue instanceof DateTime) {
            return DateTimes.toDateTime((DateTime)apiValue);
        }
        if (apiValue instanceof Date) {
            return DateTimes.toString((Date)apiValue);
        }
        if (apiValue instanceof Set) {
            LinkedHashSet<Object> nativeValues = new LinkedHashSet<Object>();
            for (Object entry : (Set)apiValue) {
                Pql.validateSetValueEntryForSet(Pql.getNativeValue(entry), nativeValues);
                nativeValues.add(Pql.getNativeValue(entry));
            }
            return nativeValues;
        }
        return apiValue;
    }

    public static Object getCsvValue(Value value) {
        return Pql.getCsvValue(Pql.getApiValue(value));
    }

    private static Object getCsvValue(Object apiValue) {
        if (apiValue == null) {
            return null;
        }
        if (apiValue instanceof DateTime) {
            return DateTimes.toStringWithTimeZone((DateTime)apiValue);
        }
        if (apiValue instanceof Date) {
            return DateTimes.toString((Date)apiValue);
        }
        if (apiValue instanceof Set) {
            LinkedHashSet<Object> csvValues = new LinkedHashSet<Object>();
            for (Object entry : (Set)apiValue) {
                Object csvValue = Pql.getCsvValue(entry);
                Pql.validateSetValueEntryForSet(csvValue, csvValues);
                if (csvValue instanceof String) {
                    csvValue = StringEscapeUtils.escapeCsv((String)((String)csvValue));
                }
                csvValues.add(csvValue);
            }
            return Joiner.on((String)",").join(csvValues);
        }
        if (apiValue instanceof Targeting) {
            throw new IllegalArgumentException("Unsupported Value type [" + apiValue.getClass() + "]");
        }
        return apiValue;
    }

    public static List<String[]> resultSetToStringArrayList(ResultSet resultSet) {
        ArrayList stringArrayList = Lists.newArrayList();
        stringArrayList.add(Pql.getColumnLabels(resultSet).toArray(new String[0]));
        if (resultSet.getRows() != null) {
            for (Row row : resultSet.getRows()) {
                try {
                    stringArrayList.add(Pql.getRowStringValues(row).toArray(new String[0]));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Cannot convert result set to string array list", e);
                }
            }
        }
        return stringArrayList;
    }

    public static String resultSetToString(ResultSet resultSet) throws IllegalAccessException {
        StringBuilder resultSetStringBuilder = new StringBuilder();
        List<String[]> resultSetStringArrayList = Pql.resultSetToStringArrayList(resultSet);
        List<Integer> maxColumnSizes = Pql.getMaxColumnSizes(resultSetStringArrayList);
        String rowTemplate = Pql.createRowTemplate(maxColumnSizes);
        String rowSeparator = Pql.createRowSeperator(maxColumnSizes);
        resultSetStringBuilder.append(rowSeparator);
        for (int i = 0; i < resultSetStringArrayList.size(); ++i) {
            resultSetStringBuilder.append(String.format(rowTemplate, resultSetStringArrayList.get(i))).append(rowSeparator);
        }
        return resultSetStringBuilder.toString();
    }

    private static String createRowTemplate(List<Integer> maxColumnSizes) {
        ArrayList columnFormatSpecifiers = Lists.newArrayList();
        for (int maxColumnSize : maxColumnSizes) {
            columnFormatSpecifiers.add("%-" + maxColumnSize + "s");
        }
        return "| " + Joiner.on((String)" | ").join((Iterable)columnFormatSpecifiers) + " |\n";
    }

    private static String createRowSeperator(List<Integer> maxColumnSizes) {
        StringBuilder rowSeparator = new StringBuilder("+");
        for (int maxColumnSize : maxColumnSizes) {
            rowSeparator.append(Strings.repeat((String)"-", (int)(maxColumnSize + 2))).append("+");
        }
        return rowSeparator.append("\n").toString();
    }

    private static List<Integer> getMaxColumnSizes(List<String[]> resultSet) {
        ArrayList maxColumnSizes = Lists.newArrayList();
        for (int i = 0; i < resultSet.get(0).length; ++i) {
            int maxColumnSize = -1;
            for (int j = 0; j < resultSet.size(); ++j) {
                if (resultSet.get(j)[i].length() <= maxColumnSize) continue;
                maxColumnSize = resultSet.get(j)[i].length();
            }
            maxColumnSizes.add(maxColumnSize);
        }
        return maxColumnSizes;
    }

    public static List<String> getColumnLabels(ResultSet resultSet) {
        return Lists.transform((List)Lists.newArrayList((Object[])resultSet.getColumnTypes()), (Function)new Function<ColumnType, String>(){

            public String apply(ColumnType input) {
                return input.getLabelName();
            }
        });
    }

    public static List<String> getRowStringValues(Row row) {
        return Lists.transform((List)Lists.newArrayList((Object[])row.getValues()), (Function)new Function<Value, String>(){

            public String apply(Value input) {
                return Pql.toString(input);
            }
        });
    }

    public static ResultSet combineResultSets(ResultSet first, ResultSet second) {
        List secondColumns;
        Function<ColumnType, String> columnTypeToString = new Function<ColumnType, String>(){

            public String apply(ColumnType input) {
                return input.getLabelName();
            }
        };
        List firstColumns = Lists.transform((List)Lists.newArrayList((Object[])first.getColumnTypes()), (Function)columnTypeToString);
        if (!firstColumns.equals(secondColumns = Lists.transform((List)Lists.newArrayList((Object[])second.getColumnTypes()), (Function)columnTypeToString))) {
            throw new IllegalArgumentException(String.format("First result set columns [%s] do not match second columns [%s]", Joiner.on((String)",").join((Iterable)firstColumns), Joiner.on((String)",").join((Iterable)secondColumns)));
        }
        ArrayList combinedRows = Lists.newArrayList((Object[])first.getRows());
        if (second.getRows() != null) {
            Collections.addAll(combinedRows, second.getRows());
        }
        ResultSet combinedResultSet = new ResultSet();
        combinedResultSet.setColumnTypes(first.getColumnTypes());
        combinedResultSet.setRows(combinedRows.toArray(new Row[0]));
        return combinedResultSet;
    }
}

