/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.admanager.axis.utils.v201805;

import com.google.api.ads.admanager.axis.v201805.ExportFormat;
import com.google.api.ads.admanager.axis.v201805.ReportDownloadOptions;
import com.google.api.ads.admanager.axis.v201805.ReportJobStatus;
import com.google.api.ads.admanager.axis.v201805.ReportServiceInterface;
import com.google.api.ads.admanager.lib.utils.ReportCallback;
import com.google.api.client.util.Sleeper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.zip.GZIPInputStream;

public class ReportDownloader {
    public static final Charset REPORT_CHARSET = Charset.forName("UTF-8");
    public static final int SLEEP_TIMER = 30000;
    private final ReportServiceInterface reportService;
    private final long reportJobId;
    private final Sleeper sleeper;
    private static final ImmutableSet<ExportFormat> SUPPORTED_CHARSOURCE_EXPORT_FORMATS = ImmutableSet.of((Object)ExportFormat.CSV_DUMP, (Object)ExportFormat.TSV, (Object)ExportFormat.XML);

    public ReportDownloader(ReportServiceInterface reportService, long reportJobId) {
        this(reportService, reportJobId, Sleeper.DEFAULT);
    }

    @VisibleForTesting
    ReportDownloader(ReportServiceInterface reportService, long reportJobId, Sleeper sleeper) {
        this.reportJobId = reportJobId;
        this.reportService = reportService;
        this.sleeper = sleeper;
    }

    public Thread whenReportReady(final ReportCallback callback) {
        Preconditions.checkNotNull((Object)callback, (Object)"Report callback cannot be null.");
        Thread waitThread = new Thread("ReportUtils.whenReportReady " + this.reportJobId){

            @Override
            public void run() {
                try {
                    if (ReportDownloader.this.waitForReportReady()) {
                        callback.onSuccess();
                    } else {
                        callback.onFailure();
                    }
                }
                catch (RemoteException e) {
                    callback.onException((Exception)e);
                }
                catch (InterruptedException e) {
                    callback.onInterruption();
                }
                catch (RuntimeException e) {
                    callback.onException((Exception)e);
                }
            }
        };
        waitThread.start();
        return waitThread;
    }

    public boolean waitForReportReady() throws RemoteException, InterruptedException {
        ReportJobStatus status = this.reportService.getReportJobStatus(this.reportJobId);
        while (status == ReportJobStatus.IN_PROGRESS) {
            this.sleeper.sleep(30000L);
            status = this.reportService.getReportJobStatus(this.reportJobId);
        }
        return status == ReportJobStatus.COMPLETED;
    }

    public URL getDownloadUrl(ReportDownloadOptions options) throws RemoteException, MalformedURLException {
        ReportJobStatus status = this.reportService.getReportJobStatus(this.reportJobId);
        Preconditions.checkState((status == ReportJobStatus.COMPLETED ? 1 : 0) != 0, (Object)("Report " + this.reportJobId + " must be completed before downloading. It is currently: " + status));
        return new URL(this.reportService.getReportDownloadUrlWithOptions(this.reportJobId, options));
    }

    public CharSource getReportAsCharSource(ReportDownloadOptions options) throws IOException {
        Preconditions.checkArgument((boolean)SUPPORTED_CHARSOURCE_EXPORT_FORMATS.contains((Object)options.getExportFormat()), (Object)("ExportFormat " + options.getExportFormat() + " cannot be used with CharSource"));
        ByteSource byteSource = Resources.asByteSource((URL)this.getDownloadUrl(options));
        return (options.getUseGzipCompression() != false ? new GZippedByteSource(byteSource) : byteSource).asCharSource(REPORT_CHARSET);
    }

    private static class GZippedByteSource
    extends ByteSource {
        private ByteSource containedByteSource;

        public GZippedByteSource(ByteSource zippedByteSource) {
            this.containedByteSource = zippedByteSource;
        }

        public InputStream openStream() throws IOException {
            return new GZIPInputStream(this.containedByteSource.openStream());
        }
    }
}

