/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.axis.utils.v201308;

import com.google.api.ads.common.lib.utils.Streams;
import com.google.api.ads.dfp.axis.v201308.ExportFormat;
import com.google.api.ads.dfp.axis.v201308.ReportJobStatus;
import com.google.api.ads.dfp.axis.v201308.ReportServiceInterface;
import com.google.api.ads.dfp.lib.utils.ReportCallback;
import com.google.common.base.Preconditions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.zip.GZIPInputStream;

public class ReportDownloader {
    public static final Charset REPORT_CHARSET = StandardCharsets.UTF_8;
    public static final int SLEEP_TIMER = 30000;
    private final ReportServiceInterface reportService;
    private final long reportJobId;

    public ReportDownloader(ReportServiceInterface reportService, long reportJobId) {
        this.reportJobId = reportJobId;
        this.reportService = reportService;
    }

    public Thread whenReportReady(final ReportCallback callback) {
        Preconditions.checkNotNull((Object)callback, (Object)"Report callback cannot be null.");
        Thread waitThread = new Thread("ReportUtils.whenReportReady " + this.reportJobId){

            public void run() {
                try {
                    if (ReportDownloader.this.waitForReportReady()) {
                        callback.onSuccess();
                    } else {
                        callback.onFailure();
                    }
                }
                catch (RemoteException e) {
                    callback.onException((Exception)e);
                }
                catch (InterruptedException interruptedException) {
                    callback.onInterruption();
                }
                catch (RuntimeException e) {
                    callback.onException((Exception)e);
                }
            }
        };
        waitThread.start();
        return waitThread;
    }

    public boolean waitForReportReady() throws RemoteException, InterruptedException {
        ReportJobStatus status = this.reportService.getReportJob(this.reportJobId).getReportJobStatus();
        while (status == ReportJobStatus.IN_PROGRESS) {
            Thread.sleep(30000L);
            status = this.reportService.getReportJob(this.reportJobId).getReportJobStatus();
        }
        return status == ReportJobStatus.COMPLETED;
    }

    public void downloadReport(ExportFormat exportFormat, String fileName) throws IOException {
        this.downloadReport(exportFormat, new FileOutputStream(fileName));
    }

    public void downloadReport(ExportFormat exportFormat, OutputStream outputStream) throws IOException {
        Streams.copy((InputStream)new URL(this.getDownloadUrl(exportFormat)).openStream(), (OutputStream)outputStream);
    }

    public String getReport(ExportFormat exportFormat) throws IOException {
        return this.getGzipUrlStringContents(this.getDownloadUrl(exportFormat));
    }

    private String getDownloadUrl(ExportFormat exportFormat) throws RemoteException {
        ReportJobStatus status = this.reportService.getReportJob(this.reportJobId).getReportJobStatus();
        Preconditions.checkState((status == ReportJobStatus.COMPLETED ? 1 : 0) != 0, (Object)("Report " + this.reportJobId + " must be completed before downloading. It is currently: " + status));
        return this.reportService.getReportDownloadURL(this.reportJobId, exportFormat);
    }

    private String getGzipUrlStringContents(String url) throws IOException {
        return Streams.readAll((InputStream)new GZIPInputStream(new URL(url).openStream()), (Charset)REPORT_CHARSET);
    }
}

