/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.axis.utils.v201111;

import com.google.api.ads.dfp.axis.utils.v201111.Dates;
import com.google.api.ads.dfp.axis.v201111.DateTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class DateTimes {
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    private DateTimes() {
    }

    public static DateTime fromString(String dateTimeString) throws ParseException {
        return DateTimes.fromDate(new SimpleDateFormat(DATE_TIME_FORMAT).parse(dateTimeString));
    }

    public static DateTime fromDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateTime dfpDateTime = new DateTime();
        dfpDateTime.setDate(Dates.fromDate(date));
        dfpDateTime.setHour(calendar.get(11));
        dfpDateTime.setMinute(calendar.get(12));
        dfpDateTime.setSecond(calendar.get(13));
        return dfpDateTime;
    }

    public static DateTime now(String timeZoneId) {
        return DateTimes.fromDate(Calendar.getInstance(TimeZone.getTimeZone(timeZoneId)).getTime());
    }

    public static DateTime today(String timeZoneId) {
        DateTime dateTime = DateTimes.fromDate(Calendar.getInstance(TimeZone.getTimeZone(timeZoneId)).getTime());
        dateTime.setHour(0);
        dateTime.setMinute(0);
        dateTime.setSecond(0);
        return dateTime;
    }

    public static Date toDate(DateTime dateTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(dateTime.getTimeZoneID()));
        calendar.set(1, dateTime.getDate().getYear());
        calendar.set(2, dateTime.getDate().getMonth() - 1);
        calendar.set(5, dateTime.getDate().getDay());
        calendar.set(11, dateTime.getHour());
        calendar.set(12, dateTime.getMinute());
        calendar.set(13, dateTime.getSecond());
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String toString(DateTime dateTime) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(DATE_TIME_FORMAT);
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone(dateTime.getTimeZoneID()));
        return dateTimeFormat.format(DateTimes.toDate(dateTime));
    }
}

