/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.admanager.jaxws.utils.v202302;

import com.google.api.ads.admanager.jaxws.utils.v202302.Pql;
import com.google.api.ads.admanager.jaxws.v202302.Statement;
import com.google.api.ads.admanager.jaxws.v202302.StringValueMapEntry;
import com.google.api.ads.admanager.jaxws.v202302.Value;
import com.google.api.ads.admanager.lib.utils.QueryBuilder;
import com.google.api.ads.admanager.lib.utils.QueryBuilderInterface;
import com.google.api.ads.common.lib.utils.Maps;
import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;

public final class StatementBuilder {
    public static final int SUGGESTED_PAGE_LIMIT = 500;
    private final QueryBuilderInterface<Value> queryBuilder;

    public StatementBuilder() {
        this((QueryBuilderInterface<Value>)new QueryBuilder());
    }

    @VisibleForTesting
    StatementBuilder(QueryBuilderInterface<Value> queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    @CanIgnoreReturnValue
    public StatementBuilder withBindVariableValue(String key, Object value) {
        return this.withBindVariableValue(key, Pql.createValue(value));
    }

    @CanIgnoreReturnValue
    public StatementBuilder withBindVariableValue(String key, Value value) {
        this.queryBuilder.withBindVariableValue(key, (Object)value);
        return this;
    }

    public Statement toStatement() {
        Statement statement = new Statement();
        statement.setQuery(this.queryBuilder.buildQuery());
        statement.getValues().addAll(Maps.toList((Map)this.queryBuilder.getBindVariableMap(), StringValueMapEntry.class));
        return statement;
    }

    @CanIgnoreReturnValue
    public StatementBuilder select(String columns) {
        this.queryBuilder.select(columns);
        return this;
    }

    @CanIgnoreReturnValue
    public StatementBuilder from(String table) {
        this.queryBuilder.from(table);
        return this;
    }

    @CanIgnoreReturnValue
    public StatementBuilder where(String conditions) {
        this.queryBuilder.where(conditions);
        return this;
    }

    @CanIgnoreReturnValue
    public StatementBuilder limit(Integer count) {
        this.queryBuilder.limit(count);
        return this;
    }

    @CanIgnoreReturnValue
    public StatementBuilder offset(Integer count) {
        this.queryBuilder.offset(count);
        return this;
    }

    @CanIgnoreReturnValue
    public StatementBuilder increaseOffsetBy(Integer amount) {
        this.queryBuilder.increaseOffsetBy(amount);
        return this;
    }

    public Integer getOffset() {
        return this.queryBuilder.getOffset();
    }

    @CanIgnoreReturnValue
    public StatementBuilder removeLimitAndOffset() {
        this.queryBuilder.removeLimitAndOffset();
        return this;
    }

    @CanIgnoreReturnValue
    public StatementBuilder orderBy(String orderBy) {
        this.queryBuilder.orderBy(orderBy);
        return this;
    }

    public Map<String, Value> getBindVariableMap() {
        return this.queryBuilder.getBindVariableMap();
    }

    public String buildQuery() {
        return this.queryBuilder.buildQuery();
    }
}

